/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.util.PasswordUtil;

class ScramDigestPasswordImpl
extends AbstractPasswordImpl
implements ScramDigestPassword {
    private static final long serialVersionUID = 5831469808883867480L;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String HMAC_SHA384_ALGORITHM = "HmacSHA384";
    private static final String HMAC_SHA512_ALGORITHM = "HmacSHA512";
    private final String algorithm;
    private final byte[] digest;
    private final byte[] salt;
    private final int iterationCount;

    ScramDigestPasswordImpl(String algorithm, byte[] digest, byte[] salt, int iterationCount) {
        this.algorithm = algorithm;
        this.digest = digest;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    ScramDigestPasswordImpl(ScramDigestPassword password) {
        this(password.getAlgorithm(), (byte[])password.getDigest().clone(), (byte[])password.getSalt().clone(), password.getIterationCount());
    }

    ScramDigestPasswordImpl(String algorithm, IteratedSaltedHashPasswordSpec spec) {
        this(algorithm, (byte[])spec.getHash().clone(), (byte[])spec.getSalt().clone(), spec.getIterationCount());
    }

    ScramDigestPasswordImpl(String algorithm, SaltedHashPasswordSpec spec) {
        this(algorithm, (byte[])spec.getHash().clone(), (byte[])spec.getSalt().clone(), 20000);
    }

    ScramDigestPasswordImpl(String algorithm, ClearPasswordSpec spec) throws InvalidKeySpecException {
        this.algorithm = algorithm;
        this.salt = PasswordUtil.generateRandomSalt(12);
        this.iterationCount = 20000;
        try {
            this.digest = ScramDigestPasswordImpl.scramDigest(this.algorithm, ScramDigestPasswordImpl.getNormalizedPasswordBytes(spec.getEncodedPassword()), this.salt, this.iterationCount);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    ScramDigestPasswordImpl(String algorithm, EncryptablePasswordSpec spec) throws InvalidKeySpecException {
        this(algorithm, spec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)spec.getAlgorithmParameterSpec());
    }

    private ScramDigestPasswordImpl(String algorithm, char[] password, IteratedSaltedPasswordAlgorithmSpec spec) throws InvalidKeySpecException {
        this.algorithm = algorithm;
        this.salt = spec.getSalt() == null ? PasswordUtil.generateRandomSalt(12) : (byte[])spec.getSalt().clone();
        this.iterationCount = spec.getIterationCount() == 0 ? 20000 : spec.getIterationCount();
        try {
            this.digest = ScramDigestPasswordImpl.scramDigest(algorithm, ScramDigestPasswordImpl.getNormalizedPasswordBytes(password), this.salt, this.iterationCount);
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getDigest() {
        try {
            return (byte[])this.digest.clone();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException();
        }
    }

    @Override
    public byte[] getSalt() {
        try {
            return (byte[])this.salt.clone();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException();
        }
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(IteratedSaltedHashPasswordSpec.class);
    }

    @Override
    Password translate(AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec updateSpec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            byte[] updateSalt = updateSpec.getSalt();
            if (updateSalt != null && !Arrays.equals(updateSalt, this.salt)) {
                throw new InvalidAlgorithmParameterException();
            }
            int updateIterationCount = updateSpec.getIterationCount();
            if (updateIterationCount < this.iterationCount) {
                throw new InvalidAlgorithmParameterException();
            }
            if (updateIterationCount == this.iterationCount) {
                return this;
            }
            byte[] digest = (byte[])this.digest.clone();
            try {
                ScramDigestPasswordImpl.addIterations(digest, ScramDigestPasswordImpl.getMacInstance(this.algorithm, digest), this.iterationCount, updateIterationCount);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new InvalidKeyException(e);
            }
            return new ScramDigestPasswordImpl(this.algorithm, digest, updateSalt, updateIterationCount);
        }
        throw new InvalidAlgorithmParameterException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            byte[] output = ScramDigestPasswordImpl.scramDigest(this.getAlgorithm(), ScramDigestPasswordImpl.getNormalizedPasswordBytes(guess), this.getSalt(), this.getIterationCount());
            return Arrays.equals(this.digest, output);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException(nsae);
        }
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(IteratedSaltedHashPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new IteratedSaltedHashPasswordSpec(this.getDigest(), this.getSalt(), this.getIterationCount())));
        }
        throw new InvalidKeySpecException();
    }

    static byte[] scramDigest(String algorithm, byte[] password, byte[] salt, int iterationCount) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = ScramDigestPasswordImpl.getMacInstance(algorithm, password);
        hmac.update(salt);
        hmac.update("\u0000\u0000\u0000\u0001".getBytes(StandardCharsets.UTF_8));
        byte[] hi = hmac.doFinal();
        ScramDigestPasswordImpl.addIterations(hi, hmac, 1, iterationCount);
        return hi;
    }

    static void addIterations(byte[] hi, Mac hmac, int currentIterationCount, int newIterationCount) {
        byte[] current = hi;
        for (int i = currentIterationCount; i < newIterationCount; ++i) {
            hmac.update(current);
            current = hmac.doFinal();
            for (int j = 0; j < hi.length; ++j) {
                int n = j;
                hi[n] = (byte)(hi[n] ^ current[j]);
            }
        }
    }

    private static Mac getMacInstance(String algorithm, byte[] password) throws NoSuchAlgorithmException, InvalidKeyException {
        switch (algorithm) {
            case "scram-sha-1": {
                Mac hmac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
                SecretKeySpec key = new SecretKeySpec(password, HMAC_SHA1_ALGORITHM);
                hmac.init(key);
                return hmac;
            }
            case "scram-sha-256": {
                Mac hmac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
                SecretKeySpec key = new SecretKeySpec(password, HMAC_SHA256_ALGORITHM);
                hmac.init(key);
                return hmac;
            }
            case "scram-sha-384": {
                Mac hmac = Mac.getInstance(HMAC_SHA384_ALGORITHM);
                SecretKeySpec key = new SecretKeySpec(password, HMAC_SHA384_ALGORITHM);
                hmac.init(key);
                return hmac;
            }
            case "scram-sha-512": {
                Mac hmac = Mac.getInstance(HMAC_SHA512_ALGORITHM);
                SecretKeySpec key = new SecretKeySpec(password, HMAC_SHA512_ALGORITHM);
                hmac.init(key);
                return hmac;
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return ScramDigestPassword.createRaw(this.algorithm, this.digest, this.salt, this.iterationCount);
    }

    @Override
    public ScramDigestPasswordImpl clone() {
        return this;
    }
}

