/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

public final class MechanismUtil {
    private MechanismUtil() {
    }

    public static <S extends Password> S getPasswordCredential(String userName, CallbackHandler callbackHandler, Class<S> passwordType, String passwordAlgorithm, AlgorithmParameterSpec defaultParameters) throws AuthenticationMechanismException {
        Assert.checkNotNullParam((String)"userName", (Object)userName);
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        Assert.checkNotNullParam((String)"passwordType", passwordType);
        Assert.checkNotNullParam((String)"passwordAlgorithm", (Object)passwordAlgorithm);
        try {
            PasswordFactory passwordFactory;
            block15: {
                CredentialCallback credentialCallback;
                block14: {
                    passwordFactory = PasswordFactory.getInstance(passwordAlgorithm);
                    credentialCallback = new CredentialCallback(PasswordCredential.class, passwordAlgorithm);
                    try {
                        MechanismUtil.handleCallbacks(passwordAlgorithm, callbackHandler, credentialCallback);
                        Password password = credentialCallback.applyToCredential(PasswordCredential.class, c -> c.getPassword(passwordType));
                        if (password != null) {
                            return (S)password;
                        }
                    }
                    catch (UnsupportedCallbackException e) {
                        if (e.getCallback() == credentialCallback) break block14;
                        throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(passwordAlgorithm, e);
                    }
                }
                credentialCallback = new CredentialCallback(PasswordCredential.class, "clear");
                try {
                    MechanismUtil.handleCallbacks(passwordAlgorithm, callbackHandler, credentialCallback);
                    TwoWayPassword twoWayPassword = credentialCallback.applyToCredential(PasswordCredential.class, c -> c.getPassword(TwoWayPassword.class));
                    if (twoWayPassword != null) {
                        PasswordFactory clearFactory = PasswordFactory.getInstance(twoWayPassword.getAlgorithm());
                        ClearPasswordSpec spec = clearFactory.getKeySpec(clearFactory.translate(twoWayPassword), ClearPasswordSpec.class);
                        if (defaultParameters != null) {
                            return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new EncryptablePasswordSpec(spec.getEncodedPassword(), defaultParameters))));
                        }
                        return (S)((Password)passwordType.cast(passwordFactory.generatePassword(spec)));
                    }
                }
                catch (UnsupportedCallbackException e) {
                    if (e.getCallback() == credentialCallback) break block15;
                    throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(passwordAlgorithm, e);
                }
            }
            PasswordCallback passwordCallback = new PasswordCallback("User password", false);
            try {
                MechanismUtil.handleCallbacks(passwordAlgorithm, callbackHandler, passwordCallback);
                char[] password = passwordCallback.getPassword();
                if (password != null) {
                    if (defaultParameters != null) {
                        return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new EncryptablePasswordSpec(password, defaultParameters))));
                    }
                    return (S)((Password)passwordType.cast(passwordFactory.generatePassword(new ClearPasswordSpec(password))));
                }
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != passwordCallback) {
                    throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(passwordAlgorithm, e);
                }
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition(passwordAlgorithm, e);
        }
        throw ElytronMessages.log.mechUnableToRetrievePassword(passwordAlgorithm, userName);
    }

    public static void handleCallbacks(String mechName, CallbackHandler callbackHandler, Callback ... callbacks) throws AuthenticationMechanismException, UnsupportedCallbackException {
        try {
            callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException | AuthenticationMechanismException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(mechName, e);
        }
    }
}

