/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialUpdateCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.ExclusiveNameCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.MechanismInformationCallback;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityLocator;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.auth.server.event.RealmFailedAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmIdentityFailedAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmIdentitySuccessfulAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmSuccessfulAuthenticationEvent;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public final class ServerAuthenticationContext {
    private final AtomicReference<State> stateRef;
    private static final State FAILED = new State(){

        @Override
        void fail() {
        }

        @Override
        boolean isDone() {
            return true;
        }
    };

    ServerAuthenticationContext(SecurityDomain domain, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this(domain.getCurrentSecurityIdentity(), mechanismConfigurationSelector);
    }

    ServerAuthenticationContext(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechanismConfigurationSelector) {
        this.stateRef = new AtomicReference<InactiveState>(new InactiveState(capturedIdentity, mechanismConfigurationSelector));
    }

    public void setMechanismInformation(MechanismInformation mechanismInformation) throws IllegalStateException {
        this.stateRef.get().setMechanismInformation(mechanismInformation);
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        return this.stateRef.get().getAuthorizedIdentity();
    }

    public boolean authorizeAnonymous() throws IllegalStateException {
        return this.authorizeAnonymous(true);
    }

    public boolean authorizeAnonymous(boolean requireLoginPermission) throws IllegalStateException {
        return this.stateRef.get().authorizeAnonymous(requireLoginPermission);
    }

    public void setAuthenticationName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        this.setAuthenticationName(name, false);
    }

    public void setAuthenticationName(String name, boolean exclusive) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.stateRef.get().setName(name, exclusive);
    }

    public void setAuthenticationPrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        this.stateRef.get().setPrincipal(principal);
    }

    public boolean isSameName(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.stateRef.get().isSameName(name);
    }

    public boolean isSamePrincipal(Principal principal) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        return this.stateRef.get().isSamePrincipal(principal);
    }

    public boolean exists() throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().getRealmIdentity().exists();
    }

    public void fail() throws IllegalStateException {
        this.stateRef.get().fail();
    }

    public boolean authorize() throws RealmUnavailableException, IllegalStateException {
        return this.authorize(true);
    }

    boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException, IllegalStateException {
        return this.stateRef.get().authorize(requireLoginPermission);
    }

    public boolean authorize(String name) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        return this.authorize(name, true);
    }

    boolean authorize(String name, boolean authorizeRunAs) throws IllegalArgumentException, RealmUnavailableException, IllegalStateException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.stateRef.get().authorize(name, authorizeRunAs);
    }

    public void succeed() throws IllegalStateException, RealmUnavailableException {
        this.stateRef.get().succeed();
    }

    public boolean isDone() {
        return this.stateRef.get().isDone();
    }

    public Principal getAuthenticationPrincipal() {
        return this.stateRef.get().getAuthenticationPrincipal();
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.stateRef.get().getCredentialAcquireSupport(credentialType, algorithmName);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.getCredentialAcquireSupport(credentialType, null);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return this.stateRef.get().getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return this.getEvidenceVerifySupport(evidenceType, null);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.stateRef.get().getCredential(credentialType, algorithmName);
    }

    public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.stateRef.get().getCredential(credentialType, null);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        return this.stateRef.get().verifyEvidence(evidence);
    }

    public boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"identity", (Object)identity);
        return this.stateRef.get().importIdentity(identity);
    }

    public void setMechanismRealmName(String realmName) throws IllegalStateException, IllegalArgumentException {
        Assert.checkNotNullParam((String)"realmName", (Object)realmName);
        this.stateRef.get().setMechanismRealmName(realmName);
    }

    public void updateCredential(Credential credential) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        this.stateRef.get().updateCredential(credential);
    }

    AtomicReference<State> getStateRef() {
        return this.stateRef;
    }

    CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                this.handleOne(callbacks, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleOne(Callback[] callbacks, int idx) throws IOException, UnsupportedCallbackException {
                if (idx == callbacks.length) {
                    return;
                }
                AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
                Callback callback = callbacks[idx];
                if (callback instanceof AnonymousAuthorizationCallback) {
                    ((AnonymousAuthorizationCallback)callback).setAuthorized(ServerAuthenticationContext.this.authorizeAnonymous());
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof AuthorizeCallback) {
                    String authorizationID;
                    AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                    String authenticationID = authorizeCallback.getAuthenticationID();
                    if (authenticationID != null) {
                        ServerAuthenticationContext.this.setAuthenticationName(authenticationID);
                    }
                    if ((authorizationID = authorizeCallback.getAuthorizationID()) != null) {
                        authorizeCallback.setAuthorized(ServerAuthenticationContext.this.authorize(authorizationID));
                    } else {
                        authorizeCallback.setAuthorized(ServerAuthenticationContext.this.authorize());
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof ExclusiveNameCallback) {
                    ExclusiveNameCallback exclusiveNameCallback = (ExclusiveNameCallback)callback;
                    String name = exclusiveNameCallback.getDefaultName();
                    try {
                        if (exclusiveNameCallback.needsExclusiveAccess()) {
                            ServerAuthenticationContext.this.setAuthenticationName(name, true);
                            exclusiveNameCallback.setExclusiveAccess(true);
                        } else {
                            ServerAuthenticationContext.this.setAuthenticationName(name);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof NameCallback) {
                    String name = ((NameCallback)callback).getDefaultName();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationName(name);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else if (callback instanceof PeerPrincipalCallback) {
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    try {
                        ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    this.handleOne(callbacks, idx + 1);
                } else {
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        if (ServerAuthenticationContext.this.getCredentialAcquireSupport(PasswordCredential.class).mayBeSupported()) {
                            TwoWayPassword password = ServerAuthenticationContext.this.applyToCredential(PasswordCredential.class, c -> c.getPassword(TwoWayPassword.class));
                            if (password != null) {
                                ClearPasswordSpec clearPasswordSpec;
                                try {
                                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                                    clearPasswordSpec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                                }
                                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                                    throw new FastUnsupportedCallbackException(callback);
                                }
                                passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                                this.handleOne(callbacks, idx + 1);
                                return;
                            }
                            throw new FastUnsupportedCallbackException(callback);
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof CredentialCallback) {
                        CredentialCallback credentialCallback = (CredentialCallback)callback;
                        Credential credential = ServerAuthenticationContext.this.getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm());
                        if (credential != null) {
                            credentialCallback.setCredential(credential);
                            this.handleOne(callbacks, idx + 1);
                            return;
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof ServerCredentialCallback) {
                        ServerCredentialCallback serverCredentialCallback = (ServerCredentialCallback)callback;
                        SecurityFactory<Credential> serverCredentialFactory = stateRef.get().getMechanismConfiguration().getServerCredentialFactory();
                        if (serverCredentialFactory != null) {
                            try {
                                Credential credential = serverCredentialFactory.create();
                                if (serverCredentialCallback.isCredentialSupported(credential)) {
                                    serverCredentialCallback.setCredential(credential);
                                    this.handleOne(callbacks, idx + 1);
                                    return;
                                }
                            }
                            catch (GeneralSecurityException credential) {
                                // empty catch block
                            }
                        }
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    if (callback instanceof EvidenceVerifyCallback) {
                        EvidenceVerifyCallback evidenceVerifyCallback = (EvidenceVerifyCallback)callback;
                        evidenceVerifyCallback.setVerified(ServerAuthenticationContext.this.verifyEvidence(evidenceVerifyCallback.getEvidence()));
                    } else if (callback instanceof AuthenticationCompleteCallback) {
                        if (!ServerAuthenticationContext.this.isDone()) {
                            if (((AuthenticationCompleteCallback)callback).succeeded()) {
                                ServerAuthenticationContext.this.succeed();
                            } else {
                                ServerAuthenticationContext.this.fail();
                            }
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SocketAddressCallback) {
                        SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                        if (socketAddressCallback.getKind() == SocketAddressCallback.Kind.PEER) {
                            // empty if block
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof SecurityIdentityCallback) {
                        ((SecurityIdentityCallback)callback).setSecurityIdentity(ServerAuthenticationContext.this.getAuthorizedIdentity());
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof AvailableRealmsCallback) {
                        Collection<String> names = stateRef.get().getMechanismConfiguration().getMechanismRealmNames();
                        if (!names.isEmpty()) {
                            ((AvailableRealmsCallback)callback).setRealmNames(names.toArray(new String[names.size()]));
                        }
                        this.handleOne(callbacks, idx + 1);
                    } else if (callback instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)callback;
                        String mechanismRealm = rcb.getText();
                        if (mechanismRealm == null) {
                            mechanismRealm = rcb.getDefaultText();
                        }
                        ServerAuthenticationContext.this.setMechanismRealmName(mechanismRealm);
                        this.handleOne(callbacks, idx + 1);
                    } else {
                        if (callback instanceof MechanismInformationCallback) {
                            MechanismInformationCallback mic = (MechanismInformationCallback)callback;
                            try {
                                ServerAuthenticationContext.this.setMechanismInformation(mic.getMechanismInformation());
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                        if (callback instanceof CredentialUpdateCallback) {
                            CredentialUpdateCallback credentialUpdateCallback = (CredentialUpdateCallback)callback;
                            ServerAuthenticationContext.this.updateCredential(credentialUpdateCallback.getCredential());
                            this.handleOne(callbacks, idx + 1);
                        } else if (callback instanceof CachedIdentityAuthorizeCallback) {
                            SecurityIdentity authorizedIdentity;
                            CachedIdentityAuthorizeCallback authorizeCallback;
                            block64: {
                                authorizeCallback = (CachedIdentityAuthorizeCallback)callback;
                                authorizeCallback.setSecurityDomain(stateRef.get().getSecurityDomain());
                                authorizedIdentity = null;
                                try {
                                    SecurityIdentity identity = authorizeCallback.getIdentity();
                                    if (identity == null || !ServerAuthenticationContext.this.importIdentity(identity)) break block64;
                                    authorizedIdentity = ServerAuthenticationContext.this.getAuthorizedIdentity();
                                    authorizeCallback.setAuthorized(authorizedIdentity);
                                    return;
                                }
                                catch (Throwable throwable) {
                                    authorizeCallback.setAuthorized(authorizedIdentity);
                                    throw throwable;
                                }
                            }
                            Principal principal = authorizeCallback.getPrincipal();
                            if (principal == null) {
                                principal = authorizeCallback.getAuthorizationPrincipal();
                            }
                            if (principal != null) {
                                ServerAuthenticationContext.this.setAuthenticationPrincipal(principal);
                                ServerAuthenticationContext.this.authorize();
                                authorizedIdentity = ServerAuthenticationContext.this.getAuthorizedIdentity();
                                authorizeCallback.setAuthorized(authorizedIdentity);
                                return;
                            }
                            authorizeCallback.setAuthorized(authorizedIdentity);
                            this.handleOne(callbacks, idx + 1);
                        } else {
                            CallbackUtil.unsupported(callback);
                        }
                    }
                }
            }
        };
    }

    private static String validatedRewrite(String name, NameRewriter rewriter) {
        String newName = rewriter.rewriteName(name);
        if (newName == null) {
            throw ElytronMessages.log.invalidName();
        }
        return newName;
    }

    static String rewriteAll(String name, NameRewriter r1, NameRewriter r2, NameRewriter r3) {
        if (r1 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r1);
        }
        if (r2 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r2);
        }
        if (r3 != null) {
            return ServerAuthenticationContext.validatedRewrite(name, r3);
        }
        return name;
    }

    static String mapAll(String name, RealmMapper r1, RealmMapper r2, RealmMapper r3, String defaultRealmName) {
        if (r1 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r1, defaultRealmName);
        }
        if (r2 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r2, defaultRealmName);
        }
        if (r3 != null) {
            return ServerAuthenticationContext.mapRealmName(name, r3, defaultRealmName);
        }
        return defaultRealmName;
    }

    private static String mapRealmName(String name, RealmMapper realmMapper, String defaultRealmName) {
        String realmName = realmMapper.getRealmMapping(name, null, null);
        return realmName != null ? realmName : defaultRealmName;
    }

    NameAssignedState assignName(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, String name, Principal originalPrincipal, Evidence evidence) throws RealmUnavailableException {
        return this.assignName(capturedIdentity, mechanismConfiguration, mechanismRealmConfiguration, name, originalPrincipal, evidence, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    NameAssignedState assignName(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration, String name, Principal originalPrincipal, Evidence evidence, boolean exclusive) throws RealmUnavailableException {
        RealmIdentity realmIdentity;
        SecurityDomain domain = capturedIdentity.getSecurityDomain();
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPreRealmRewriter(), mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
        NamePrincipal principal = new NamePrincipal(name);
        String realmName = ServerAuthenticationContext.mapAll(name, mechanismRealmConfiguration.getRealmMapper(), mechanismConfiguration.getRealmMapper(), domain.getRealmMapper(), domain.getDefaultRealmName());
        RealmInfo realmInfo = domain.getRealmInfo(realmName);
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getPostRealmRewriter(), mechanismConfiguration.getPostRealmRewriter(), domain.getPostRealmRewriter());
        name = ServerAuthenticationContext.rewriteAll(name, mechanismRealmConfiguration.getFinalRewriter(), mechanismConfiguration.getFinalRewriter(), realmInfo.getNameRewriter());
        SecurityRealm securityRealm = realmInfo.getSecurityRealm();
        IdentityLocator.Builder locatorBuilder = IdentityLocator.builder();
        locatorBuilder.setName(name);
        locatorBuilder.setPrincipal(principal);
        locatorBuilder.setEvidence(evidence);
        if (exclusive) {
            if (!(securityRealm instanceof ModifiableSecurityRealm)) throw ElytronMessages.log.unableToObtainExclusiveAccess();
            realmIdentity = ((ModifiableSecurityRealm)securityRealm).getRealmIdentityForUpdate(locatorBuilder.build());
            return new NameAssignedState(capturedIdentity, realmInfo, realmIdentity, principal, mechanismConfiguration, mechanismRealmConfiguration);
        } else {
            realmIdentity = securityRealm.getRealmIdentity(locatorBuilder.build());
        }
        return new NameAssignedState(capturedIdentity, realmInfo, realmIdentity, principal, mechanismConfiguration, mechanismRealmConfiguration);
    }

    static final class CompleteState
    extends State {
        private final SecurityIdentity identity;

        public CompleteState(SecurityIdentity identity) {
            this.identity = identity;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.identity;
        }

        @Override
        boolean isDone() {
            return true;
        }

        @Override
        void succeed() {
        }
    }

    final class AuthorizedAuthenticationState
    extends AuthorizedState {
        private final RealmIdentity realmIdentity;

        AuthorizedAuthenticationState(SecurityIdentity authorizedIdentity, Principal authenticationPrincipal, RealmInfo realmInfo, RealmIdentity realmIdentity, MechanismRealmConfiguration mechanismRealmConfiguration, MechanismConfiguration mechanismConfiguration) {
            super(authorizedIdentity, authenticationPrincipal, realmInfo, mechanismConfiguration, mechanismRealmConfiguration);
            this.realmIdentity = realmIdentity;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.realmIdentity.verifyEvidence(evidence);
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
            this.realmIdentity.updateCredential(credential);
        }

        @Override
        void succeed() {
            SecurityIdentity authorizedIdentity = this.getSourceIdentity();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (stateRef.compareAndSet(this, new CompleteState(authorizedIdentity))) {
                SecurityRealm.safeHandleRealmEvent(this.getRealmInfo().getSecurityRealm(), new RealmSuccessfulAuthenticationEvent(this.realmIdentity, authorizedIdentity.getAuthorizationIdentity(), null, null));
                this.realmIdentity.dispose();
                return;
            }
            stateRef.get().succeed();
        }

        @Override
        void fail() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (stateRef.compareAndSet(this, FAILED)) {
                SecurityRealm.safeHandleRealmEvent(this.getRealmInfo().getSecurityRealm(), new RealmFailedAuthenticationEvent(this.realmIdentity, null, null));
                this.realmIdentity.dispose();
                return;
            }
            stateRef.get().fail();
        }
    }

    class AuthorizedState
    extends ActiveState {
        private final SecurityIdentity authorizedIdentity;
        private final Principal authenticationPrincipal;
        private final RealmInfo realmInfo;
        private final MechanismConfiguration mechanismConfiguration;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        AuthorizedState(SecurityIdentity authorizedIdentity, Principal authenticationPrincipal, RealmInfo realmInfo, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.authorizedIdentity = authorizedIdentity;
            this.authenticationPrincipal = authenticationPrincipal;
            this.realmInfo = realmInfo;
            this.mechanismConfiguration = mechanismConfiguration;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.authorizedIdentity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.authorizedIdentity.getSecurityDomain();
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.authorizedIdentity;
        }

        @Override
        boolean isSameName(String name) {
            SecurityDomain domain = this.authorizedIdentity.getSecurityDomain();
            name = ServerAuthenticationContext.rewriteAll(name, this.mechanismRealmConfiguration.getPreRealmRewriter(), this.mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
            return this.authenticationPrincipal.equals(new NamePrincipal(name));
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            String name = this.authorizedIdentity.getSecurityDomain().getPrincipalDecoder().getName(principal);
            return this.isSameName(name);
        }

        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            return !requireLoginPermission || this.authorizedIdentity.implies(LoginPermission.getInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AuthorizedState authorizeRunAs(String authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            if (this.isSameName(authorizationId)) {
                return this;
            }
            NameAssignedState nameAssignedState = ServerAuthenticationContext.this.assignName(this.authorizedIdentity, this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), authorizationId, null, null);
            RealmIdentity realmIdentity = nameAssignedState.getRealmIdentity();
            boolean ok = false;
            try {
                if (authorizeRunAs && !this.authorizedIdentity.implies(new RunAsPrincipalPermission(nameAssignedState.getAuthenticationPrincipal().getName()))) {
                    AuthorizedState authorizedState = null;
                    return authorizedState;
                }
                AuthorizedAuthenticationState newState = nameAssignedState.doAuthorization(false);
                if (newState == null) {
                    AuthorizedState authorizedState = null;
                    return authorizedState;
                }
                ok = true;
                AuthorizedAuthenticationState authorizedAuthenticationState = newState;
                return authorizedAuthenticationState;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        void succeed() {
            if (this.authorizedIdentity != null) {
                return;
            }
            super.succeed();
        }
    }

    final class AnonymousAuthorizedState
    extends ActiveState {
        private final SecurityIdentity anonymousIdentity;

        AnonymousAuthorizedState(SecurityIdentity anonymousIdentity) {
            this.anonymousIdentity = anonymousIdentity;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return MechanismConfiguration.EMPTY;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return MechanismRealmConfiguration.NO_REALM;
        }

        @Override
        SecurityIdentity getAuthorizedIdentity() {
            return this.anonymousIdentity;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        boolean isSameName(String name) {
            return false;
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            return principal instanceof AnonymousPrincipal;
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return false;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return RealmIdentity.ANONYMOUS;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.anonymousIdentity.getSecurityDomain();
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            return true;
        }

        @Override
        void setName(String name) throws RealmUnavailableException {
            this.setName(name, false);
        }

        @Override
        void setName(String name, boolean exclusive) throws RealmUnavailableException {
            super.setName(name);
        }

        @Override
        void setPrincipal(Principal principal) throws RealmUnavailableException {
            if (!(principal instanceof AnonymousPrincipal)) {
                super.setPrincipal(principal);
            }
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            return !requireLoginPermission || this.anonymousIdentity.implies(LoginPermission.getInstance());
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
        }

        @Override
        void succeed() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, new CompleteState(this.anonymousIdentity))) {
                stateRef.get().succeed();
            }
        }

        @Override
        void fail() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail();
            }
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.anonymousIdentity;
        }
    }

    final class NameAssignedState
    extends ActiveState {
        private final SecurityIdentity capturedIdentity;
        private final RealmInfo realmInfo;
        private final RealmIdentity realmIdentity;
        private final Principal authenticationPrincipal;
        private final MechanismConfiguration mechanismConfiguration;
        private final MechanismRealmConfiguration mechanismRealmConfiguration;

        NameAssignedState(SecurityIdentity capturedIdentity, RealmInfo realmInfo, RealmIdentity realmIdentity, Principal authenticationPrincipal, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration) {
            this.capturedIdentity = capturedIdentity;
            this.realmInfo = realmInfo;
            this.realmIdentity = realmIdentity;
            this.authenticationPrincipal = authenticationPrincipal;
            this.mechanismConfiguration = mechanismConfiguration;
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }

        @Override
        Principal getAuthenticationPrincipal() {
            return this.authenticationPrincipal;
        }

        @Override
        RealmIdentity getRealmIdentity() {
            return this.realmIdentity;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.realmIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            AuthorizedAuthenticationState newState = this.doAuthorization(requireLoginPermission);
            if (newState == null) {
                return false;
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            return stateRef.compareAndSet(this, newState) || stateRef.get().authorize(requireLoginPermission);
        }

        AuthorizedAuthenticationState doAuthorization(boolean requireLoginPermission) throws RealmUnavailableException {
            RealmIdentity realmIdentity = this.realmIdentity;
            if (!realmIdentity.exists()) {
                return null;
            }
            RealmInfo realmInfo = this.realmInfo;
            Principal authenticationPrincipal = this.authenticationPrincipal;
            AuthorizationIdentity authorizationIdentity = realmIdentity.getAuthorizationIdentity();
            SecurityDomain domain = this.capturedIdentity.getSecurityDomain();
            PeerIdentity[] peerIdentities = this.capturedIdentity.getPeerIdentities();
            SecurityIdentity authorizedIdentity = (SecurityIdentity)Assert.assertNotNull((Object)domain.transform(new SecurityIdentity(domain, authenticationPrincipal, realmInfo, authorizationIdentity, domain.getCategoryRoleMappers(), peerIdentities, this.capturedIdentity.getPublicCredentials(), this.capturedIdentity.getPrivateCredentialsPrivate())));
            if (requireLoginPermission) {
                if (!authorizedIdentity.implies(LoginPermission.getInstance())) {
                    SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentityFailedAuthorizationEvent(authorizedIdentity.getAuthorizationIdentity(), authorizedIdentity.getPrincipal(), authenticationPrincipal));
                    return null;
                }
                SecurityRealm.safeHandleRealmEvent(realmInfo.getSecurityRealm(), new RealmIdentitySuccessfulAuthorizationEvent(authorizedIdentity.getAuthorizationIdentity(), authorizedIdentity.getPrincipal(), authenticationPrincipal));
            }
            return new AuthorizedAuthenticationState(authorizedIdentity, authenticationPrincipal, realmInfo, realmIdentity, this.mechanismRealmConfiguration, this.mechanismConfiguration);
        }

        @Override
        boolean authorize(String authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            AuthorizedAuthenticationState authzState = this.doAuthorization(true);
            if (authzState == null) {
                return false;
            }
            AuthorizedState newState = authzState.authorizeRunAs(authorizationId, authorizeRunAs);
            if (newState == null) {
                return false;
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (stateRef.compareAndSet(this, newState)) {
                this.getRealmIdentity().dispose();
                return true;
            }
            return stateRef.get().authorize(authorizationId, authorizeRunAs);
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.capturedIdentity;
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Principal evidencePrincipal = evidence.getPrincipal();
            return (evidencePrincipal == null || this.isSamePrincipal(evidencePrincipal)) && this.getRealmIdentity().verifyEvidence(evidence);
        }

        @Override
        void updateCredential(Credential credential) throws RealmUnavailableException {
            this.realmIdentity.updateCredential(credential);
        }

        @Override
        void succeed() {
            throw ElytronMessages.log.cannotSucceedNotAuthorized();
        }

        @Override
        void fail() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail();
                return;
            }
            this.realmIdentity.dispose();
        }

        @Override
        void setName(String name) {
            this.setName(name, false);
        }

        @Override
        void setName(String name, boolean exclusive) {
            if (this.isSameName(name)) {
                return;
            }
            throw ElytronMessages.log.nameAlreadySet();
        }

        @Override
        void setPrincipal(Principal principal) {
            if (this.isSamePrincipal(principal)) {
                return;
            }
            throw ElytronMessages.log.nameAlreadySet();
        }

        @Override
        boolean isSameName(String name) {
            SecurityDomain domain = this.capturedIdentity.getSecurityDomain();
            name = ServerAuthenticationContext.rewriteAll(name, this.mechanismRealmConfiguration.getPreRealmRewriter(), this.mechanismConfiguration.getPreRealmRewriter(), domain.getPreRealmRewriter());
            return this.authenticationPrincipal.equals(new NamePrincipal(name));
        }

        @Override
        boolean isSamePrincipal(Principal principal) {
            String name = this.capturedIdentity.getSecurityDomain().getPrincipalDecoder().getName(principal);
            return this.isSameName(name);
        }

        RealmInfo getRealmInfo() {
            return this.realmInfo;
        }
    }

    final class RealmAssignedState
    extends UnassignedState {
        final MechanismRealmConfiguration mechanismRealmConfiguration;

        RealmAssignedState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration, MechanismRealmConfiguration mechanismRealmConfiguration) {
            super(capturedIdentity, mechanismConfiguration);
            this.mechanismRealmConfiguration = mechanismRealmConfiguration;
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            return this.mechanismRealmConfiguration;
        }
    }

    final class InitialState
    extends UnassignedState {
        InitialState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration) {
            super(capturedIdentity, mechanismConfiguration);
        }

        @Override
        void setMechanismRealmName(String realmName) {
            MechanismConfiguration mechanismConfiguration = this.getMechanismConfiguration();
            if (mechanismConfiguration.getMechanismRealmNames().isEmpty()) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            MechanismRealmConfiguration configuration = mechanismConfiguration.getMechanismRealmConfiguration(realmName);
            if (configuration == null) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, new RealmAssignedState(this.capturedIdentity, mechanismConfiguration, configuration))) {
                stateRef.get().setMechanismRealmName(realmName);
            }
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            Collection<String> mechanismRealmNames = this.mechanismConfiguration.getMechanismRealmNames();
            Iterator<String> iterator = mechanismRealmNames.iterator();
            if (iterator.hasNext()) {
                return this.mechanismConfiguration.getMechanismRealmConfiguration(iterator.next());
            }
            return MechanismRealmConfiguration.NO_REALM;
        }
    }

    abstract class UnassignedState
    extends ActiveState {
        final SecurityIdentity capturedIdentity;
        final MechanismConfiguration mechanismConfiguration;

        UnassignedState(SecurityIdentity capturedIdentity, MechanismConfiguration mechanismConfiguration) {
            this.capturedIdentity = capturedIdentity;
            this.mechanismConfiguration = mechanismConfiguration;
        }

        @Override
        SecurityIdentity getSourceIdentity() {
            return this.capturedIdentity;
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        void fail() {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, FAILED)) {
                stateRef.get().fail();
            }
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity anonymousIdentity = this.getSecurityDomain().getAnonymousSecurityIdentity();
            return !(requireLoginPermission && !anonymousIdentity.implies(LoginPermission.getInstance()) || !stateRef.compareAndSet(this, new AnonymousAuthorizedState(anonymousIdentity)) && !stateRef.get().authorizeAnonymous(requireLoginPermission));
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            SecurityIdentity capturedIdentity = this.capturedIdentity;
            if (capturedIdentity.getPrincipal() instanceof AnonymousPrincipal) {
                return this.authorizeAnonymous(requireLoginPermission);
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            return !(requireLoginPermission && !capturedIdentity.implies(LoginPermission.getInstance()) || !stateRef.compareAndSet(this, new AuthorizedState(capturedIdentity, capturedIdentity.getPrincipal(), capturedIdentity.getRealmInfo(), this.mechanismConfiguration, this.getMechanismRealmConfiguration())) && !stateRef.get().authorize(requireLoginPermission));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean importIdentity(SecurityIdentity importedIdentity) throws RealmUnavailableException {
            String name;
            RealmInfo evidenceRealmInfo = importedIdentity.getRealmInfo();
            SecurityRealm evidenceSecurityRealm = evidenceRealmInfo.getSecurityRealm();
            SecurityDomain evidenceSecurityDomain = importedIdentity.getSecurityDomain();
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            SecurityDomain domain = sourceIdentity.getSecurityDomain();
            Principal importedPrincipal = importedIdentity.getPrincipal();
            if (AnonymousPrincipal.getInstance().equals(importedPrincipal)) {
                AnonymousAuthorizedState newState = new AnonymousAuthorizedState(domain.getAnonymousSecurityIdentity());
                return stateRef.compareAndSet(this, newState) || stateRef.get().importIdentity(importedIdentity);
            }
            if (domain == importedIdentity.getSecurityDomain()) {
                AuthorizedState newState = new AuthorizedState(importedIdentity, importedPrincipal, importedIdentity.getRealmInfo(), this.mechanismConfiguration, this.getMechanismRealmConfiguration());
                return stateRef.compareAndSet(this, newState) || stateRef.get().importIdentity(importedIdentity);
            }
            boolean trusted = false;
            if (domain.trustsDomain(evidenceSecurityDomain)) {
                trusted = true;
            }
            if ((name = domain.getPrincipalDecoder().getName(importedPrincipal)) == null) {
                throw ElytronMessages.log.unrecognizedPrincipalType(importedPrincipal);
            }
            NameAssignedState nameState = ServerAuthenticationContext.this.assignName(sourceIdentity, this.mechanismConfiguration, this.getMechanismRealmConfiguration(), name, null, null);
            RealmIdentity realmIdentity = nameState.getRealmIdentity();
            boolean ok = false;
            try {
                if (!trusted && nameState.getRealmInfo().getSecurityRealm() != evidenceSecurityRealm) {
                    boolean bl = false;
                    return bl;
                }
                AuthorizedAuthenticationState authzState = nameState.doAuthorization(false);
                if (authzState == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!stateRef.compareAndSet(this, authzState)) {
                    boolean bl = stateRef.get().importIdentity(importedIdentity);
                    return bl;
                }
                ok = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        void setName(String name) throws RealmUnavailableException {
            this.setName(name, false);
        }

        @Override
        void setName(String name, boolean exclusive) throws RealmUnavailableException {
            NameAssignedState newState;
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, newState = ServerAuthenticationContext.this.assignName(this.capturedIdentity, this.mechanismConfiguration, this.getMechanismRealmConfiguration(), name, null, null, exclusive))) {
                newState.realmIdentity.dispose();
                stateRef.get().setName(name, exclusive);
            }
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.getSecurityDomain().getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            String name;
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            Principal evidencePrincipal = evidence.getPrincipal();
            MechanismRealmConfiguration mechanismRealmConfiguration = this.getMechanismRealmConfiguration();
            if (evidencePrincipal != null && (name = this.getSecurityDomain().getPrincipalDecoder().getName(evidencePrincipal)) != null) {
                NameAssignedState newState = ServerAuthenticationContext.this.assignName(this.getSourceIdentity(), this.mechanismConfiguration, mechanismRealmConfiguration, name, evidencePrincipal, evidence);
                if (!newState.verifyEvidence(evidence)) {
                    newState.realmIdentity.dispose();
                    return false;
                }
                if (!stateRef.compareAndSet(this, newState)) {
                    newState.realmIdentity.dispose();
                    stateRef.get().setName(name);
                    return stateRef.get().verifyEvidence(evidence);
                }
                return true;
            }
            SecurityDomain domain = this.getSecurityDomain();
            Collection<RealmInfo> realmInfos = domain.getRealmInfos();
            RealmIdentity realmIdentity = null;
            RealmInfo realmInfo = null;
            IdentityLocator locator = IdentityLocator.fromEvidence(evidence);
            for (RealmInfo info : realmInfos) {
                realmIdentity = info.getSecurityRealm().getRealmIdentity(locator);
                if (realmIdentity.exists()) {
                    realmInfo = info;
                    break;
                }
                realmIdentity.dispose();
            }
            if (realmInfo == null) {
                return false;
            }
            assert (realmIdentity != null && realmIdentity.exists());
            Principal resolvedPrincipal = realmIdentity.getRealmIdentityPrincipal();
            if (resolvedPrincipal == null) {
                realmIdentity.dispose();
                return false;
            }
            if (!realmIdentity.verifyEvidence(evidence)) {
                realmIdentity.dispose();
                return false;
            }
            NameAssignedState newState = new NameAssignedState(this.getSourceIdentity(), realmInfo, realmIdentity, resolvedPrincipal, this.mechanismConfiguration, mechanismRealmConfiguration);
            if (!stateRef.compareAndSet(this, newState)) {
                realmIdentity.dispose();
                return stateRef.get().verifyEvidence(evidence);
            }
            return true;
        }

        @Override
        void setPrincipal(Principal principal) throws RealmUnavailableException {
            NameAssignedState newState;
            Assert.checkNotNullParam((String)"principal", (Object)principal);
            String name = this.getSecurityDomain().getPrincipalDecoder().getName(principal);
            if (name == null) {
                throw ElytronMessages.log.unrecognizedPrincipalType(principal);
            }
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            if (!stateRef.compareAndSet(this, newState = ServerAuthenticationContext.this.assignName(this.capturedIdentity, this.mechanismConfiguration, this.getMechanismRealmConfiguration(), name, principal, null))) {
                newState.realmIdentity.dispose();
                stateRef.get().setName(name);
            }
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            return this.mechanismConfiguration;
        }
    }

    abstract class ActiveState
    extends State {
        ActiveState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean authorize(String authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            AtomicReference<State> stateRef = ServerAuthenticationContext.this.getStateRef();
            SecurityIdentity sourceIdentity = this.getSourceIdentity();
            NameAssignedState nameAssignedState = ServerAuthenticationContext.this.assignName(sourceIdentity, this.getMechanismConfiguration(), this.getMechanismRealmConfiguration(), authorizationId, null, null);
            RealmIdentity realmIdentity = nameAssignedState.getRealmIdentity();
            boolean ok = false;
            try {
                if (!realmIdentity.exists()) {
                    boolean bl = false;
                    return bl;
                }
                if (authorizeRunAs && !sourceIdentity.implies(new RunAsPrincipalPermission(nameAssignedState.getAuthenticationPrincipal().getName()))) {
                    boolean bl = false;
                    return bl;
                }
                AuthorizedAuthenticationState newState = nameAssignedState.doAuthorization(false);
                if (newState == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!stateRef.compareAndSet(this, newState)) {
                    boolean bl = stateRef.get().authorize(authorizationId, authorizeRunAs);
                    return bl;
                }
                ok = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (!ok) {
                    realmIdentity.dispose();
                }
            }
        }

        @Override
        void setMechanismRealmName(String realmName) {
            MechanismRealmConfiguration currentConfiguration = this.getMechanismRealmConfiguration();
            MechanismConfiguration mechanismConfiguration = this.getMechanismConfiguration();
            if (mechanismConfiguration.getMechanismRealmNames().isEmpty()) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            MechanismRealmConfiguration configuration = mechanismConfiguration.getMechanismRealmConfiguration(realmName);
            if (configuration == null) {
                throw ElytronMessages.log.invalidMechRealmSelection(realmName);
            }
            if (currentConfiguration != configuration) {
                throw ElytronMessages.log.mechRealmAlreadySelected();
            }
        }

        @Override
        void setMechanismInformation(MechanismInformation mechanismInformation) {
            throw ElytronMessages.log.tooLateToSetMechanismInformation();
        }

        abstract SecurityIdentity getSourceIdentity();
    }

    final class InactiveState
    extends State {
        private final SecurityIdentity capturedIdentity;
        private final MechanismConfigurationSelector mechansimConfigurationSelector;
        private final MechanismInformation mechanismInformation;

        public InactiveState(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechansimConfigurationSelector) {
            this(capturedIdentity, mechansimConfigurationSelector, MechanismInformation.DEFAULT);
        }

        public InactiveState(SecurityIdentity capturedIdentity, MechanismConfigurationSelector mechansimConfigurationSelector, MechanismInformation mechanismInformation) {
            this.capturedIdentity = capturedIdentity;
            this.mechansimConfigurationSelector = mechansimConfigurationSelector;
            this.mechanismInformation = (MechanismInformation)Assert.checkNotNullParam((String)"mechanismInformation", (Object)mechanismInformation);
        }

        @Override
        void setMechanismInformation(MechanismInformation mechanismInformation) {
            InactiveState inactiveState = new InactiveState(this.capturedIdentity, this.mechansimConfigurationSelector, mechanismInformation);
            InitialState nextState = inactiveState.selectMechanismConfiguration();
            if (!ServerAuthenticationContext.this.stateRef.compareAndSet(this, nextState)) {
                ((State)ServerAuthenticationContext.this.stateRef.get()).setMechanismInformation(mechanismInformation);
            }
        }

        @Override
        SecurityDomain getSecurityDomain() {
            return this.capturedIdentity.getSecurityDomain();
        }

        @Override
        boolean authorize(String authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorize(authorizationId, authorizeRunAs);
        }

        @Override
        void setMechanismRealmName(String name) {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).setMechanismRealmName(name);
        }

        @Override
        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).getMechanismRealmConfiguration();
        }

        @Override
        void fail() {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).fail();
        }

        @Override
        boolean authorizeAnonymous(boolean requireLoginPermission) {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorizeAnonymous(requireLoginPermission);
        }

        @Override
        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).authorize(requireLoginPermission);
        }

        @Override
        boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).importIdentity(identity);
        }

        @Override
        void setName(String name) throws RealmUnavailableException {
            this.setName(name, false);
        }

        @Override
        void setName(String name, boolean exclusive) throws RealmUnavailableException {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).setName(name, exclusive);
        }

        @Override
        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.getSecurityDomain().getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        @Override
        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).verifyEvidence(evidence);
        }

        @Override
        void setPrincipal(Principal principal) throws RealmUnavailableException {
            this.transition();
            ((State)ServerAuthenticationContext.this.stateRef.get()).setPrincipal(principal);
        }

        @Override
        MechanismConfiguration getMechanismConfiguration() {
            this.transition();
            return ((State)ServerAuthenticationContext.this.stateRef.get()).getMechanismConfiguration();
        }

        private void transition() {
            InitialState initialState = this.selectMechanismConfiguration();
            ServerAuthenticationContext.this.stateRef.compareAndSet(this, initialState);
        }

        private InitialState selectMechanismConfiguration() {
            MechanismConfiguration mechanismConfiguration = this.mechansimConfigurationSelector.selectConfiguration(this.mechanismInformation);
            if (mechanismConfiguration == null) {
                throw ElytronMessages.log.unableToSelectMechanismConfiguration(this.mechanismInformation.getMechanismType(), this.mechanismInformation.getMechanismName(), this.mechanismInformation.getHostName(), this.mechanismInformation.getProtocol());
            }
            return new InitialState(this.capturedIdentity, mechanismConfiguration);
        }
    }

    static abstract class State {
        State() {
        }

        MechanismConfiguration getMechanismConfiguration() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        MechanismRealmConfiguration getMechanismRealmConfiguration() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SecurityIdentity getAuthorizedIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        Principal getAuthenticationPrincipal() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean isSameName(String name) {
            return false;
        }

        boolean isSamePrincipal(Principal principal) {
            return false;
        }

        SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean importIdentity(SecurityIdentity identity) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        RealmIdentity getRealmIdentity() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        SecurityDomain getSecurityDomain() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorizeAnonymous(boolean requireLoginPermission) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setMechanismInformation(MechanismInformation mechanismInformation) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setName(String name) throws RealmUnavailableException {
            this.setName(name, false);
        }

        void setName(String name, boolean exclusive) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setPrincipal(Principal principal) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorize(boolean requireLoginPermission) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean authorize(String authorizationId, boolean authorizeRunAs) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void setMechanismRealmName(String name) {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void updateCredential(Credential credential) throws RealmUnavailableException {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void succeed() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        void fail() {
            throw ElytronMessages.log.noAuthenticationInProgress();
        }

        boolean isDone() {
            return false;
        }
    }
}

