/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.wildfly.common.Assert;

class DelegatingLdapContext
implements LdapContext {
    final DirContext delegating;
    final CloseHandler closeHandler;
    final ReconnectHandler reconnectHandler;

    DelegatingLdapContext(DirContext delegating, CloseHandler closeHandler, ReconnectHandler reconnectHandler) throws NamingException {
        this.delegating = delegating;
        this.closeHandler = closeHandler;
        this.reconnectHandler = reconnectHandler;
    }

    private DelegatingLdapContext(DirContext delegating, ReconnectHandler reconnectHandler) throws NamingException {
        this.delegating = delegating;
        this.closeHandler = null;
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public void close() throws NamingException {
        if (this.closeHandler == null) {
            this.delegating.close();
        } else {
            this.closeHandler.handle(this.delegating);
        }
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        return ((LdapContext)this.delegating).extendedOperation(request);
    }

    @Override
    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        LdapContext newContext = ((LdapContext)this.delegating).newInstance(requestControls);
        return new DelegatingLdapContext(newContext, this.reconnectHandler);
    }

    @Override
    public void reconnect(Control[] controls) throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        this.reconnectHandler.handle((LdapContext)this.delegating, controls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        return ((LdapContext)this.delegating).getConnectControls();
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        ((LdapContext)this.delegating).setRequestControls(requestControls);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        return ((LdapContext)this.delegating).getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        if (!(this.delegating instanceof LdapContext)) {
            throw Assert.unsupported();
        }
        return ((LdapContext)this.delegating).getResponseControls();
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.delegating.bind(name, obj, attrs);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.delegating.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.delegating.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.delegating.getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.delegating.getAttributes(name, attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.delegating.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.delegating.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.delegating.modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.delegating.modifyAttributes(name, mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.delegating.bind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.delegating.rebind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.delegating.rebind(name, obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.delegating.createSubcontext(name, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.delegating.createSubcontext(name, attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.delegating.getSchema(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.delegating.getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.delegating.getSchemaClassDefinition(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.delegating.getSchemaClassDefinition(name);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.delegating.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.delegating.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.delegating.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.delegating.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.delegating.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.delegating.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.delegating.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.delegating.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.delegating.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.delegating.lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.delegating.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.delegating.bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.delegating.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.delegating.rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.delegating.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.delegating.unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.delegating.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.delegating.rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.delegating.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.delegating.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.delegating.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.delegating.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.delegating.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.delegating.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.delegating.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.delegating.createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.delegating.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.delegating.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.delegating.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.delegating.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.delegating.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.delegating.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.delegating.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.delegating.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.delegating.getEnvironment();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.delegating.getNameInNamespace();
    }

    static interface ReconnectHandler {
        public void handle(LdapContext var1, Control[] var2) throws NamingException;
    }

    static interface CloseHandler {
        public void handle(DirContext var1) throws NamingException;
    }
}

