/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.ssl.ProtocolSelector;

class ProtocolSelectorAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final ProtocolSelector protocolSelector;

    ProtocolSelectorAuthenticationConfiguration(AuthenticationConfiguration parent, ProtocolSelector protocolSelector) {
        super(parent);
        this.protocolSelector = protocolSelector;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new ProtocolSelectorAuthenticationConfiguration(newParent, this.protocolSelector);
    }

    @Override
    ProtocolSelector getProtocolSelector() {
        return this.protocolSelector;
    }

    @Override
    void configureSslEngine(SSLEngine sslEngine) {
        super.configureSslEngine(sslEngine);
        sslEngine.setEnabledProtocols(this.protocolSelector.evaluate(sslEngine.getSupportedProtocols()));
    }

    @Override
    void configureSslSocket(SSLSocket sslSocket) {
        super.configureSslSocket(sslSocket);
        sslSocket.setEnabledProtocols(this.protocolSelector.evaluate(sslSocket.getSupportedProtocols()));
    }
}

