/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.auth.server.CredentialDecoder;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.X509CertificateChainCredential;

public final class X509CertificateCredentialDecoder
implements CredentialDecoder {
    private static final X509CertificateCredentialDecoder INSTANCE = new X509CertificateCredentialDecoder();

    private X509CertificateCredentialDecoder() {
    }

    @Override
    public X500Principal getPrincipalFromCredential(Credential credential) {
        X509Certificate[] chain;
        if (credential instanceof X509CertificateChainCredential && (chain = ((X509CertificateChainCredential)credential).getCertificateChain()).length > 0) {
            return chain[0].getSubjectX500Principal();
        }
        return null;
    }

    public static X509CertificateCredentialDecoder getInstance() {
        return INSTANCE;
    }
}

