/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.x500.X500PrincipalUtil;

public final class X500AttributePrincipalDecoder
implements PrincipalDecoder {
    private final String oid;
    private final String joiner;
    private final int maximumSegments;

    public X500AttributePrincipalDecoder(String oid) {
        this(oid, ".", Integer.MAX_VALUE);
    }

    public X500AttributePrincipalDecoder(String oid, int maximumSegments) {
        this(oid, ".", maximumSegments);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner) {
        this(oid, joiner, Integer.MAX_VALUE);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner, int maximumSegments) {
        this.oid = oid;
        this.joiner = joiner;
        this.maximumSegments = maximumSegments;
    }

    @Override
    public String getName(Principal principal) {
        X500Principal x500Principal = X500PrincipalUtil.asX500Principal(principal);
        if (x500Principal == null) {
            return null;
        }
        String[] values = X500PrincipalUtil.getAttributeValues(x500Principal, this.oid);
        if (values.length == 0) {
            return null;
        }
        return Arrays.stream(values).limit(this.maximumSegments).collect(Collectors.joining(this.joiner));
    }
}

