/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLContextSpi;
import org.wildfly.security.ssl.ConfiguredSSLEngine;
import org.wildfly.security.ssl.ConfiguredSSLSocketFactory;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLContextSpi
extends AbstractDelegatingSSLContextSpi {
    private final SSLConfigurator sslConfigurator;

    ConfiguredSSLContextSpi(SSLContext delegate, SSLConfigurator sslConfigurator) {
        super(delegate);
        this.sslConfigurator = sslConfigurator;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new ConfiguredSSLSocketFactory(super.engineGetSocketFactory(), this.getDelegate(), this.sslConfigurator);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return super.engineGetServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine sslEngine = super.engineCreateSSLEngine();
        SSLConfigurator sslConfigurator = this.sslConfigurator;
        sslConfigurator.configure(this.getDelegate(), sslEngine);
        return new ConfiguredSSLEngine(sslEngine, this.getDelegate(), sslConfigurator);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        SSLEngine sslEngine = super.engineCreateSSLEngine(host, port);
        SSLConfigurator sslConfigurator = this.sslConfigurator;
        sslConfigurator.configure(this.getDelegate(), sslEngine);
        return new ConfiguredSSLEngine(sslEngine, this.getDelegate(), sslConfigurator);
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        SSLContext delegate = this.getDelegate();
        return this.sslConfigurator.getDefaultSSLParameters(delegate, delegate.getDefaultSSLParameters());
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLContext delegate = this.getDelegate();
        return this.sslConfigurator.getSupportedSSLParameters(delegate, delegate.getSupportedSSLParameters());
    }
}

