/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class CredentialSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final Credential credential;
    private final String algorithm;

    public CredentialSaslServerFactory(SaslServerFactory delegate, Credential credential, String algorithm) {
        super(delegate);
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        this.credential = credential;
        this.algorithm = algorithm;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                CredentialCallback credentialCallback;
                Callback callback = iterator.next();
                if (!(callback instanceof CredentialCallback) || !(credentialCallback = (CredentialCallback)callback).isCredentialSupported(this.credential.getClass(), this.algorithm)) continue;
                credentialCallback.setCredential(this.credential);
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }
}

