/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.AuthenticationContextSaslClient;

public final class AuthenticationContextSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final AuthenticationContext context;

    public AuthenticationContextSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    public AuthenticationContextSaslClientFactory(SaslClientFactory delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient delegate = super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        if (delegate == null) {
            return null;
        }
        return new AuthenticationContextSaslClient(delegate, this.context);
    }
}

