/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.password.Password;

public final class PasswordCredential
implements AlgorithmCredential {
    private final Password password;

    public PasswordCredential(Password password) {
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.password = password;
    }

    public Password getPassword() {
        return this.password;
    }

    public <P extends Password> P getPassword(Class<P> type) {
        return (P)(type.isInstance(this.password) ? (Password)type.cast(this.password) : null);
    }

    @Override
    public String getAlgorithm() {
        return this.password.getAlgorithm();
    }
}

