/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.SecurityIdentityHandler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaccDelegatingPolicy
extends Policy {
    public static final PrivilegedAction<Policy> GET_POLICY_ACTION = () -> Policy.getPolicy();
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";
    private final Policy delegate;
    private final Set<Class<? extends Permission>> supportedPermissionTypes = new HashSet<Class<? extends Permission>>();

    public JaccDelegatingPolicy() {
        this(WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(GET_POLICY_ACTION) : Policy.getPolicy());
        this.supportedPermissionTypes.add(WebResourcePermission.class);
        this.supportedPermissionTypes.add(WebRoleRefPermission.class);
        this.supportedPermissionTypes.add(WebUserDataPermission.class);
        this.supportedPermissionTypes.add(EJBMethodPermission.class);
        this.supportedPermissionTypes.add(EJBRoleRefPermission.class);
    }

    public JaccDelegatingPolicy(Policy delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        try {
            if (this.isJaccPermission(permission)) {
                ElytronPolicyConfiguration policyConfiguration = (ElytronPolicyConfiguration)ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
                if (this.impliesExcludedPermission(permission, policyConfiguration)) {
                    return false;
                }
                if (this.impliesUncheckedPermission(permission, policyConfiguration)) {
                    return true;
                }
                if (this.impliesRolePermission(domain, permission, policyConfiguration)) {
                    return true;
                }
            }
            if (this.impliesIdentityPermission(permission)) {
                return true;
            }
        }
        catch (Exception e) {
            ElytronMessages.log.authzFailedToCheckPermission(domain, permission, e);
        }
        return this.delegate.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissions = this.getPermissions(super.getPermissions(domain));
        this.addPermissions(permissions, this.delegate.getPermissions(domain));
        return permissions;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (codeSource == null) {
            return Policy.UNSUPPORTED_EMPTY_COLLECTION;
        }
        PermissionCollection permissions = this.getPermissions(super.getPermissions(codeSource));
        this.addPermissions(permissions, this.delegate.getPermissions(codeSource));
        return permissions;
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    private boolean impliesIdentityPermission(Permission permission) {
        PermissionCollection permissions;
        SecurityIdentity actualIdentity = this.getCurrentSecurityIdentity();
        return actualIdentity != null && (permissions = actualIdentity.getPermissions()).implies(permission);
    }

    private SecurityIdentity getCurrentSecurityIdentity() {
        try {
            return (SecurityIdentity)PolicyContext.getContext((String)SecurityIdentityHandler.KEY);
        }
        catch (Exception cause) {
            ElytronMessages.log.authzCouldNotObtainSecurityIdentity(cause);
            return null;
        }
    }

    private void extractRolesFromCurrentIdentity(Set<String> roles) throws PolicyContextException, ClassNotFoundException {
        Set<String> identityRoles;
        SecurityIdentity identity = this.getCurrentSecurityIdentity();
        if (identity != null && (identityRoles = identity.getRoles()) != null) {
            for (String roleName : identityRoles) {
                roles.add(roleName);
            }
        }
    }

    private void extractRolesFromProtectionDomain(ProtectionDomain domain, Set<String> roles) {
        Principal[] domainPrincipals = domain.getPrincipals();
        if (domainPrincipals != null) {
            for (Principal principal : domainPrincipals) {
                roles.add(principal.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissions(PermissionCollection staticPermissions) {
        Permissions permissions = new Permissions();
        this.addPermissions(permissions, staticPermissions);
        try {
            Map<String, Permissions> rolePermissions;
            ElytronPolicyConfiguration elytronPolicyConfiguration = (ElytronPolicyConfiguration)ElytronPolicyConfigurationFactory.getCurrentPolicyConfiguration();
            Permissions uncheckedPermissions = elytronPolicyConfiguration.getUncheckedPermissions();
            this.addPermissions(permissions, uncheckedPermissions);
            Map<String, Permissions> map = rolePermissions = elytronPolicyConfiguration.getRolePermissions();
            synchronized (map) {
                rolePermissions.values().forEach(actualPermission -> this.addPermissions(permissions, (PermissionCollection)actualPermission));
            }
            SecurityIdentity securityIdentity = this.getCurrentSecurityIdentity();
            if (securityIdentity != null) {
                this.addPermissions(permissions, securityIdentity.getPermissions());
            }
        }
        catch (Exception e) {
            ElytronMessages.log.authzFailedGetDynamicPermissions(e);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesRolePermission(ProtectionDomain domain, Permission permission, ElytronPolicyConfiguration policyConfiguration) throws PolicyContextException, ClassNotFoundException {
        Map<String, Permissions> rolePermissions;
        HashSet<String> roles = new HashSet<String>();
        this.extractRolesFromProtectionDomain(domain, roles);
        this.extractRolesFromCurrentIdentity(roles);
        roles.add(ANY_AUTHENTICATED_USER_ROLE);
        Map<String, Permissions> map = rolePermissions = policyConfiguration.getRolePermissions();
        synchronized (map) {
            for (String roleName : roles) {
                Permissions permissions = rolePermissions.get(roleName);
                if (permissions == null || !permissions.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesUncheckedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        Permissions uncheckedPermissions;
        Permissions permissions = uncheckedPermissions = policyConfiguration.getUncheckedPermissions();
        synchronized (permissions) {
            return uncheckedPermissions.implies(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean impliesExcludedPermission(Permission permission, ElytronPolicyConfiguration policyConfiguration) {
        Permissions excludedPermissions;
        Permissions permissions = excludedPermissions = policyConfiguration.getExcludedPermissions();
        synchronized (permissions) {
            return excludedPermissions.implies(permission);
        }
    }

    private boolean isJaccPermission(Permission permission) {
        return this.supportedPermissionTypes.contains(permission.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPermissions(PermissionCollection newPermissions, PermissionCollection toAdd) {
        if (toAdd == null) {
            return;
        }
        PermissionCollection permissionCollection = toAdd;
        synchronized (permissionCollection) {
            Enumeration<Permission> enumeration = toAdd.elements();
            while (enumeration.hasMoreElements()) {
                newPermissions.add(enumeration.nextElement());
            }
        }
    }
}

