/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.permission.ElytronPermission;

public final class SecurityDomain {
    static final ElytronPermission CREATE_SECURITY_DOMAIN = new ElytronPermission("createSecurityDomain");
    private final Map<String, RealmInfo> realmMap;
    private final String defaultRealmName;
    private final NameRewriter preRealmRewriter;
    private final RealmMapper realmMapper;
    private final NameRewriter postRealmRewriter;
    private final ThreadLocal<SecurityIdentity> currentSecurityIdentity;
    private final RoleMapper roleMapper;
    private final PrincipalDecoder principalDecoder;
    private final SecurityIdentity anonymousIdentity;
    private final PermissionMapper permissionMapper;
    private final Map<String, RoleMapper> categoryRoleMappers;

    SecurityDomain(Builder builder, HashMap<String, RealmInfo> realmMap) {
        Map<String, RoleMapper> copiedRoleMappers;
        this.realmMap = realmMap;
        this.defaultRealmName = builder.defaultRealmName;
        this.preRealmRewriter = builder.preRealmRewriter;
        this.realmMapper = builder.realmMapper;
        this.roleMapper = builder.roleMapper;
        this.permissionMapper = builder.permissionMapper;
        this.postRealmRewriter = builder.postRealmRewriter;
        this.principalDecoder = builder.principalDecoder;
        Map originalRoleMappers = builder.categoryRoleMappers;
        if (originalRoleMappers.isEmpty()) {
            copiedRoleMappers = Collections.emptyMap();
        } else if (originalRoleMappers.size() == 1) {
            Map.Entry entry = originalRoleMappers.entrySet().iterator().next();
            copiedRoleMappers = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            copiedRoleMappers = new HashMap(originalRoleMappers);
        }
        this.categoryRoleMappers = copiedRoleMappers;
        RealmInfo realmInfo = new RealmInfo();
        this.anonymousIdentity = new SecurityIdentity(this, AnonymousPrincipal.getInstance(), realmInfo, AuthorizationIdentity.EMPTY, copiedRoleMappers);
        this.currentSecurityIdentity = ThreadLocal.withInitial(() -> this.anonymousIdentity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServerAuthenticationContext createNewAuthenticationContext() {
        return new ServerAuthenticationContext(this, MechanismConfiguration.EMPTY);
    }

    public ServerAuthenticationContext createNewAuthenticationContext(MechanismConfiguration mechanismConfiguration) {
        return new ServerAuthenticationContext(this, mechanismConfiguration);
    }

    public RealmIdentity mapName(String name) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        name = this.preRealmRewriter.rewriteName(name);
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        String realmName = this.mapRealmName(name);
        SecurityRealm securityRealm = this.getRealm(realmName);
        assert (securityRealm != null);
        if ((name = this.postRealmRewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return securityRealm.createRealmIdentity(name);
    }

    public RealmIdentity mapPrincipal(Principal principal) throws RealmUnavailableException, IllegalArgumentException {
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        String name = this.principalDecoder.getName(principal);
        if (name == null) {
            throw ElytronMessages.log.unrecognizedPrincipalType(principal);
        }
        return this.mapName(name);
    }

    SecurityRealm getRealm(String realmName) {
        return this.getRealmInfo(realmName).getSecurityRealm();
    }

    RealmInfo getRealmInfo(String realmName) {
        RealmInfo realmInfo = this.realmMap.get(realmName);
        if (realmInfo == null) {
            realmInfo = this.realmMap.get(this.defaultRealmName);
        }
        return realmInfo;
    }

    public SupportLevel getCredentialAcquireSupport(String credentialName) {
        return this.getSupportLevel(r -> {
            try {
                return r.getCredentialAcquireSupport(credentialName);
            }
            catch (RealmUnavailableException e) {
                return null;
            }
        });
    }

    public SupportLevel getEvidenceVerifySupport(String credentialName) {
        return this.getSupportLevel(r -> {
            try {
                return r.getEvidenceVerifySupport(credentialName);
            }
            catch (RealmUnavailableException e) {
                return null;
            }
        });
    }

    private SupportLevel getSupportLevel(Function<SecurityRealm, SupportLevel> getSupportLevel) {
        SupportLevel max = null;
        SupportLevel min = null;
        for (RealmInfo realmInfo : this.realmMap.values()) {
            SecurityRealm realm = realmInfo.getSecurityRealm();
            SupportLevel support = getSupportLevel.apply(realm);
            if (support == null) continue;
            if (min == null || max == null) {
                min = max = support;
                continue;
            }
            if (support.compareTo(min) < 0) {
                min = support;
            }
            if (support.compareTo(max) <= 0) continue;
            max = support;
        }
        if (min == null || max == null) {
            return SupportLevel.UNSUPPORTED;
        }
        return this.minMax(min, max);
    }

    private SupportLevel minMax(SupportLevel min, SupportLevel max) {
        if (min == max) {
            return min;
        }
        if (max == SupportLevel.UNSUPPORTED) {
            return SupportLevel.UNSUPPORTED;
        }
        if (min == SupportLevel.SUPPORTED) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    public SecurityIdentity getCurrentSecurityIdentity() {
        SecurityIdentity identity = this.currentSecurityIdentity.get();
        return identity == null ? this.anonymousIdentity : identity;
    }

    public SecurityIdentity getAnonymousSecurityIdentity() {
        return this.anonymousIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityIdentity getAndSetCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        try {
            SecurityIdentity oldIdentity = this.currentSecurityIdentity.get();
            SecurityIdentity securityIdentity = oldIdentity == null ? this.anonymousIdentity : oldIdentity;
            return securityIdentity;
        }
        finally {
            if (newIdentity == this.anonymousIdentity) {
                this.currentSecurityIdentity.remove();
            } else {
                this.currentSecurityIdentity.set(newIdentity);
            }
        }
    }

    void setCurrentSecurityIdentity(SecurityIdentity newIdentity) {
        if (newIdentity == this.anonymousIdentity) {
            this.currentSecurityIdentity.remove();
        } else {
            this.currentSecurityIdentity.set(newIdentity);
        }
    }

    Set<String> mapRoles(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        AuthorizationIdentity identity = securityIdentity.getAuthorizationIdentity();
        Attributes attributes = identity.getAttributes();
        RealmInfo realmInfo = securityIdentity.getRealmInfo();
        RoleDecoder roleDecoder = realmInfo.getRoleDecoder();
        Set<String> mappedRoles = roleDecoder.decodeRoles(attributes);
        RoleMapper realmRoleMapper = realmInfo.getRoleMapper();
        mappedRoles = realmRoleMapper.mapRoles(mappedRoles);
        return this.roleMapper.mapRoles(mappedRoles);
    }

    PermissionCollection mapPermissions(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        Principal principal = securityIdentity.getPrincipal();
        Set<String> roles = securityIdentity.getRoles();
        return this.permissionMapper.mapPermissions(principal, roles);
    }

    NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    String mapRealmName(String name) {
        String realm = this.realmMapper.getRealmMapping(name);
        return realm != null ? realm : this.defaultRealmName;
    }

    NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    RoleMapper getRoleMapper() {
        return this.roleMapper;
    }

    PrincipalDecoder getPrincipalDecoder() {
        return this.principalDecoder;
    }

    Map<String, RoleMapper> getCategoryRoleMappers() {
        return this.categoryRoleMappers;
    }

    public static class RealmBuilder {
        private final String name;
        private final SecurityRealm realm;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private NameRewriter nameRewriter = NameRewriter.IDENTITY_REWRITER;
        private RoleDecoder roleDecoder = RoleDecoder.DEFAULT;

        RealmBuilder(String name, SecurityRealm realm) {
            this.name = name;
            this.realm = realm;
        }

        public String getName() {
            return this.name;
        }

        public SecurityRealm getRealm() {
            return this.realm;
        }

        public RoleMapper getRoleMapper() {
            return this.roleMapper;
        }

        public void setRoleMapper(RoleMapper roleMapper) {
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.roleMapper = roleMapper;
        }

        public NameRewriter getNameRewriter() {
            return this.nameRewriter;
        }

        public void setNameRewriter(NameRewriter nameRewriter) {
            Assert.checkNotNullParam((String)"nameRewriter", (Object)nameRewriter);
            this.nameRewriter = nameRewriter;
        }

        public RoleDecoder getRoleDecoder() {
            return this.roleDecoder;
        }

        public void setRoleDecoder(RoleDecoder roleDecoder) {
            this.roleDecoder = roleDecoder;
        }
    }

    public static final class Builder {
        private boolean built = false;
        private final HashMap<String, RealmBuilder> realms = new HashMap();
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private String defaultRealmName;
        private RealmMapper realmMapper = RealmMapper.DEFAULT_REALM_MAPPER;
        private RoleMapper roleMapper = RoleMapper.IDENTITY_ROLE_MAPPER;
        private PermissionMapper permissionMapper = PermissionMapper.EMPTY_PERMISSION_MAPPER;
        private PrincipalDecoder principalDecoder = PrincipalDecoder.DEFAULT;
        private Map<String, RoleMapper> categoryRoleMappers = Collections.emptyMap();

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter rewriter) {
            Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
            this.assertNotBuilt();
            this.preRealmRewriter = rewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter rewriter) {
            Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
            this.assertNotBuilt();
            this.postRealmRewriter = rewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            Assert.checkNotNullParam((String)"realmMapper", (Object)realmMapper);
            this.assertNotBuilt();
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder setRoleMapper(RoleMapper roleMapper) {
            Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
            this.assertNotBuilt();
            this.roleMapper = roleMapper;
            return this;
        }

        public Builder setPermissionMapper(PermissionMapper permissionMapper) {
            Assert.checkNotNullParam((String)"permissionMapper", (Object)permissionMapper);
            this.assertNotBuilt();
            this.permissionMapper = permissionMapper;
            return this;
        }

        public Builder setPrincipalDecoder(PrincipalDecoder principalDecoder) {
            Assert.checkNotNullParam((String)"principalDecoder", (Object)principalDecoder);
            this.assertNotBuilt();
            this.principalDecoder = principalDecoder;
            return this;
        }

        public RealmBuilder addRealm(String name, SecurityRealm realm) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            Assert.checkNotNullParam((String)"realm", (Object)realm);
            this.assertNotBuilt();
            RealmBuilder realmBuilder = new RealmBuilder(name, realm);
            this.realms.put(name, realmBuilder);
            return realmBuilder;
        }

        public String getDefaultRealmName() {
            return this.defaultRealmName;
        }

        public Builder setDefaultRealmName(String defaultRealmName) {
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            this.assertNotBuilt();
            this.defaultRealmName = defaultRealmName;
            return this;
        }

        public Map<String, RoleMapper> getCategoryRoleMappers() {
            return this.categoryRoleMappers;
        }

        public void setCategoryRoleMappers(Map<String, RoleMapper> categoryRoleMappers) {
            Assert.checkNotNullParam((String)"categoryRoleMappers", categoryRoleMappers);
            this.categoryRoleMappers = categoryRoleMappers;
        }

        public SecurityDomain build() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(CREATE_SECURITY_DOMAIN);
            }
            String defaultRealmName = this.defaultRealmName;
            Assert.checkNotNullParam((String)"defaultRealmName", (Object)defaultRealmName);
            HashMap<String, RealmInfo> realmMap = new HashMap<String, RealmInfo>(this.realms.size());
            for (RealmBuilder realmBuilder : this.realms.values()) {
                realmMap.put(realmBuilder.getName(), new RealmInfo(realmBuilder));
            }
            if (!realmMap.containsKey(defaultRealmName)) {
                throw ElytronMessages.log.realmMapDoesNotContainDefault(defaultRealmName);
            }
            this.assertNotBuilt();
            this.built = true;
            return new SecurityDomain(this, realmMap);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

