/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.List;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.NameRewriter;

public final class MechanismRealmConfiguration {
    private final String realmName;
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    private final Supplier<List<String>> credentialNameSupplier;
    public static final MechanismRealmConfiguration NO_REALM = new MechanismRealmConfiguration("none", NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, null);

    MechanismRealmConfiguration(String realmName, NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter, Supplier<List<String>> credentialNameSupplier) {
        this.realmName = realmName;
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.credentialNameSupplier = credentialNameSupplier;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public Supplier<List<String>> getCredentialNameSupplier() {
        return this.credentialNameSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String realmName;
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter finalRewriter = NameRewriter.IDENTITY_REWRITER;
        private Supplier<List<String>> credentialNameSupplier;

        Builder() {
        }

        public void setRealmName(String realmName) {
            this.realmName = realmName;
        }

        public void setPreRealmRewriter(NameRewriter preRealmRewriter) {
            this.preRealmRewriter = preRealmRewriter;
        }

        public void setPostRealmRewriter(NameRewriter postRealmRewriter) {
            this.postRealmRewriter = postRealmRewriter;
        }

        public void setFinalRewriter(NameRewriter finalRewriter) {
            this.finalRewriter = finalRewriter;
        }

        public void setCredentialNameSupplier(Supplier<List<String>> credentialNameSupplier) {
            this.credentialNameSupplier = credentialNameSupplier;
        }

        public MechanismRealmConfiguration build() {
            Assert.checkNotNullParam((String)"realmName", (Object)this.realmName);
            return new MechanismRealmConfiguration(this.realmName, this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.credentialNameSupplier);
        }
    }
}

