/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.NameRewriter;

public final class MechanismConfiguration {
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    private final Supplier<List<String>> credentialNameSupplier;
    private final Map<String, MechanismRealmConfiguration> mechanismRealms;
    public static final MechanismConfiguration EMPTY = new MechanismConfiguration(NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, () -> Collections.singletonList("clear-password"), Collections.emptyList());

    MechanismConfiguration(NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter, Supplier<List<String>> credentialNameSupplier, Collection<MechanismRealmConfiguration> mechanismRealms) {
        Assert.checkNotNullParam((String)"preRealmRewriter", (Object)preRealmRewriter);
        Assert.checkNotNullParam((String)"postRealmRewriter", (Object)postRealmRewriter);
        Assert.checkNotNullParam((String)"finalRewriter", (Object)finalRewriter);
        Assert.checkNotNullParam((String)"credentialNameSupplier", credentialNameSupplier);
        Assert.checkNotNullParam((String)"mechanismRealms", mechanismRealms);
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.credentialNameSupplier = credentialNameSupplier;
        Iterator<MechanismRealmConfiguration> iterator = mechanismRealms.iterator();
        if (!iterator.hasNext()) {
            this.mechanismRealms = Collections.emptyMap();
        } else {
            MechanismRealmConfiguration item = iterator.next();
            if (!iterator.hasNext()) {
                this.mechanismRealms = Collections.singletonMap(item.getRealmName(), item);
            } else {
                LinkedHashMap<String, MechanismRealmConfiguration> map = new LinkedHashMap<String, MechanismRealmConfiguration>(mechanismRealms.size());
                map.put(item.getRealmName(), item);
                do {
                    item = iterator.next();
                    map.put(item.getRealmName(), item);
                } while (iterator.hasNext());
                this.mechanismRealms = Collections.unmodifiableMap(map);
            }
        }
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public Supplier<List<String>> getCredentialNameSupplier() {
        return this.credentialNameSupplier;
    }

    public Collection<String> getMechanismRealmNames() {
        return this.mechanismRealms.keySet();
    }

    public MechanismRealmConfiguration getMechanismRealmConfiguration(String realmName) {
        return this.mechanismRealms.get(realmName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter finalRewriter = NameRewriter.IDENTITY_REWRITER;
        private Supplier<List<String>> credentialNameSupplier = () -> Collections.singletonList("clear-password");
        private List<MechanismRealmConfiguration> mechanismRealms;

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter preRealmRewriter) {
            Assert.checkNotNullParam((String)"preRealmRewriter", (Object)preRealmRewriter);
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter postRealmRewriter) {
            Assert.checkNotNullParam((String)"postRealmRewriter", (Object)postRealmRewriter);
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(NameRewriter finalRewriter) {
            Assert.checkNotNullParam((String)"finalRewriter", (Object)finalRewriter);
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder setCredentialNameSupplier(Supplier<List<String>> credentialNameSupplier) {
            Assert.checkNotNullParam((String)"credentialNameSupplier", credentialNameSupplier);
            this.credentialNameSupplier = credentialNameSupplier;
            return this;
        }

        public Builder addMechanismRealm(MechanismRealmConfiguration configuration) {
            Assert.checkNotNullParam((String)"configuration", (Object)configuration);
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            if (mechanismRealms == null) {
                mechanismRealms = this.mechanismRealms = new ArrayList<MechanismRealmConfiguration>();
            }
            mechanismRealms.add(configuration);
            return this;
        }

        public MechanismConfiguration build() {
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            return new MechanismConfiguration(this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.credentialNameSupplier, mechanismRealms == null ? Collections.emptyList() : mechanismRealms);
        }
    }
}

