/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class HttpAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<HttpServerAuthenticationMechanism, RuntimeException> {
    private final HttpServerAuthenticationMechanismFactory mechanismFactory;

    HttpAuthenticationFactory(SecurityDomain securityDomain, Map<String, MechanismConfiguration> mechanismConfigurations, HttpServerAuthenticationMechanismFactory mechanismFactory) {
        super(securityDomain, mechanismConfigurations);
        this.mechanismFactory = mechanismFactory;
    }

    @Override
    HttpServerAuthenticationMechanism doCreate(String name, CallbackHandler callbackHandler) {
        return this.mechanismFactory.createAuthenticationMechanism(name, Collections.emptyMap(), callbackHandler);
    }

    @Override
    Collection<String> getAllSupportedMechNames() {
        return Arrays.asList(this.mechanismFactory.getMechanismNames(Collections.emptyMap()));
    }

    public HttpServerAuthenticationMechanismFactory getMechanismFactory() {
        return this.mechanismFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<HttpServerAuthenticationMechanism, RuntimeException> {
        private HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory = null;

        Builder() {
        }

        @Override
        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        @Override
        public Builder addMechanism(String mechanismName, MechanismConfiguration mechanismConfiguration) {
            super.addMechanism(mechanismName, mechanismConfiguration);
            return this;
        }

        public Builder setHttpServerAuthenticationMechanismFactory(HttpServerAuthenticationMechanismFactory httpServerAuthenticationMechanismFactory) {
            Assert.checkNotNullParam((String)"httpServerAuthenticationMechanismFactory", (Object)httpServerAuthenticationMechanismFactory);
            this.httpServerAuthenticationMechanismFactory = httpServerAuthenticationMechanismFactory;
            return this;
        }

        public HttpAuthenticationFactory build() {
            return new HttpAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurations(), this.httpServerAuthenticationMechanismFactory);
        }
    }
}

