/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.MechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;

abstract class AbstractMechanismAuthenticationFactory<M, E extends Exception>
implements MechanismAuthenticationFactory<M, E> {
    private final SecurityDomain securityDomain;
    private final Map<String, MechanismConfiguration> mechanismConfigurations;

    AbstractMechanismAuthenticationFactory(SecurityDomain securityDomain, Map<String, MechanismConfiguration> mechanismConfigurations) {
        this.securityDomain = securityDomain;
        this.mechanismConfigurations = mechanismConfigurations;
    }

    @Override
    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public M createMechanism(String name) throws E {
        MechanismConfiguration configuration = this.mechanismConfigurations.get(name);
        if (configuration == null) {
            configuration = MechanismConfiguration.EMPTY;
        }
        return this.doCreate(name, new ServerAuthenticationContext(this.securityDomain, configuration).createCallbackHandler());
    }

    abstract M doCreate(String var1, CallbackHandler var2) throws E;

    @Override
    public Collection<String> getMechanismNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (String mechName : this.getAllSupportedMechNames()) {
            MechanismConfiguration mechConfig = this.mechanismConfigurations.get(mechName);
            if (mechConfig == null) continue;
            Supplier<List<String>> supplier = mechConfig.getCredentialNameSupplier();
            LinkedHashSet credentials = new LinkedHashSet();
            if (supplier != null) {
                credentials.addAll(supplier.get());
            }
            for (String mechRealmName : mechConfig.getMechanismRealmNames()) {
                MechanismRealmConfiguration mechRealm = mechConfig.getMechanismRealmConfiguration(mechRealmName);
                Supplier<List<String>> supplier1 = mechRealm.getCredentialNameSupplier();
                if (supplier1 == null) continue;
                credentials.addAll(supplier1.get());
            }
            boolean supported = false;
            for (String credential : credentials) {
                if (!this.securityDomain.getEvidenceVerifySupport(credential).mayBeSupported() && !this.securityDomain.getCredentialAcquireSupport(credential).mayBeSupported()) continue;
                supported = true;
                break;
            }
            if (!supported) continue;
            names.add(mechName);
        }
        return names;
    }

    abstract Collection<String> getAllSupportedMechNames();

    static abstract class Builder<M, E extends Exception>
    implements MechanismAuthenticationFactory.Builder<M, E> {
        private SecurityDomain securityDomain;
        private Map<String, MechanismConfiguration> mechanismConfigurations = new LinkedHashMap<String, MechanismConfiguration>();

        Builder() {
        }

        @Override
        public Builder<M, E> setSecurityDomain(SecurityDomain securityDomain) {
            Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
            this.securityDomain = securityDomain;
            return this;
        }

        @Override
        public Builder<M, E> addMechanism(String mechanismName, MechanismConfiguration mechanismConfiguration) {
            Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
            Assert.checkNotNullParam((String)"mechanismConfiguration", (Object)mechanismConfiguration);
            this.mechanismConfigurations.put(mechanismName, mechanismConfiguration);
            return this;
        }

        SecurityDomain getSecurityDomain() {
            return this.securityDomain;
        }

        Map<String, MechanismConfiguration> getMechanismConfigurations() {
            return this.mechanismConfigurations;
        }
    }
}

