/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.LdapSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;

public class LdapSecurityRealmBuilder {
    private boolean built = false;
    private DirContextFactory dirContextFactory;
    private NameRewriter nameRewriter = NameRewriter.IDENTITY_REWRITER;
    private LdapSecurityRealm.PrincipalMapping principalMapping;

    private LdapSecurityRealmBuilder() {
    }

    public static LdapSecurityRealmBuilder builder() {
        return new LdapSecurityRealmBuilder();
    }

    public LdapSecurityRealmBuilder setDirContextFactory(DirContextFactory dirContextFactory) {
        this.assertNotBuilt();
        this.dirContextFactory = dirContextFactory;
        return this;
    }

    public LdapSecurityRealmBuilder setNameRewriter(NameRewriter nameRewriter) {
        Assert.checkNotNullParam((String)"nameRewriter", (Object)nameRewriter);
        this.assertNotBuilt();
        this.nameRewriter = nameRewriter;
        return this;
    }

    public LdapSecurityRealmBuilder setPrincipalMapping(LdapSecurityRealm.PrincipalMapping principalMapping) {
        this.assertNotBuilt();
        this.principalMapping = principalMapping;
        return this;
    }

    public LdapSecurityRealm build() {
        this.assertNotBuilt();
        if (this.dirContextFactory == null) {
            throw ElytronMessages.log.noDirContextFactorySet();
        }
        if (this.principalMapping == null) {
            throw ElytronMessages.log.noPrincipalMappingDefinition();
        }
        this.built = true;
        return new LdapSecurityRealm(this.dirContextFactory, this.nameRewriter, this.principalMapping);
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw ElytronMessages.log.builderAlreadyBuilt();
        }
    }

    public static class PrincipalMappingBuilder {
        private String searchDn = null;
        private boolean searchRecursive = false;
        private String nameAttribute;
        private String passwordAttribute = "userPassword";
        private String otpAlgorithmAttribute = null;
        private String otpHashAttribute = null;
        private String otpSeedAttribute = null;
        private String otpSequenceAttribute = null;
        private int searchTimeLimit = 10000;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public static PrincipalMappingBuilder builder() {
            return new PrincipalMappingBuilder();
        }

        public PrincipalMappingBuilder setSearchDn(String searchDn) {
            this.searchDn = searchDn;
            return this;
        }

        public PrincipalMappingBuilder searchRecursive() {
            this.searchRecursive = true;
            return this;
        }

        public PrincipalMappingBuilder setSearchTimeLimit(int limit) {
            this.searchTimeLimit = limit;
            return this;
        }

        public PrincipalMappingBuilder setRdnIdentifier(String nameAttribute) {
            this.nameAttribute = nameAttribute;
            return this;
        }

        public PrincipalMappingBuilder setPasswordAttribute(String passwordAttribute) {
            this.passwordAttribute = passwordAttribute;
            return this;
        }

        public PrincipalMappingBuilder setOtpAttributes(String otpAlgorithmAttribute, String otpHashAttribute, String otpSeedAttribute, String otpSequenceAttribute) {
            this.otpAlgorithmAttribute = otpAlgorithmAttribute;
            this.otpHashAttribute = otpHashAttribute;
            this.otpSeedAttribute = otpSeedAttribute;
            this.otpSequenceAttribute = otpSequenceAttribute;
            return this;
        }

        public PrincipalMappingBuilder map(Attribute ... attributes) {
            this.attributes.addAll(Arrays.asList(attributes));
            return this;
        }

        public LdapSecurityRealm.PrincipalMapping build() {
            return new LdapSecurityRealm.PrincipalMapping(this.searchDn, this.searchRecursive, this.searchTimeLimit, this.nameAttribute, this.passwordAttribute, this.otpAlgorithmAttribute, this.otpHashAttribute, this.otpSeedAttribute, this.otpSequenceAttribute, this.attributes);
        }

        public static class Attribute {
            private final String ldapName;
            private final String searchDn;
            private final String filter;
            private String name;
            private String rdn;

            public static Attribute from(String ldapName) {
                Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
                return new Attribute(ldapName);
            }

            public static Attribute fromFilter(String searchDn, String filter, String ldapName) {
                Assert.checkNotNullParam((String)"searchDn", (Object)searchDn);
                Assert.checkNotNullParam((String)"filter", (Object)filter);
                Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
                return new Attribute(searchDn, filter, ldapName);
            }

            public static Attribute fromFilter(String filter, String ldapName) {
                Assert.checkNotNullParam((String)"filter", (Object)filter);
                Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
                return new Attribute(null, filter, ldapName);
            }

            Attribute(String ldapName) {
                this(null, null, ldapName);
            }

            Attribute(String searchDn, String filter, String ldapName) {
                Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
                this.searchDn = searchDn;
                this.filter = filter;
                this.ldapName = ldapName.toUpperCase();
            }

            public Attribute asRdn(String rdn) {
                Assert.checkNotNullParam((String)"rdn", (Object)rdn);
                this.rdn = rdn;
                return this;
            }

            public Attribute to(String name) {
                Assert.checkNotNullParam((String)"to", (Object)name);
                this.name = name;
                return this;
            }

            String getLdapName() {
                return this.ldapName;
            }

            String getName() {
                if (this.name == null) {
                    return this.ldapName;
                }
                return this.name;
            }

            String getSearchDn() {
                return this.searchDn;
            }

            String getFilter() {
                return this.filter;
            }

            String getRdn() {
                return this.rdn;
            }
        }
    }
}

