/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final NameRewriter rewriter;
    private volatile Map<String, SimpleRealmEntry> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter) {
        Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
        this.rewriter = rewriter;
    }

    public SimpleMapBackedSecurityRealm() {
        this(NameRewriter.IDENTITY_REWRITER);
    }

    public void setPasswordMap(Map<String, SimpleRealmEntry> map) {
        Assert.checkNotNullParam((String)"map", map);
        this.map = map;
    }

    public void setPasswordMap(String name, String credentialName, Password password, Attributes attributes) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        Assert.checkNotNullParam((String)"password", (Object)password);
        Assert.checkNotNullParam((String)"attributes", (Object)attributes);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonMap(credentialName, password), attributes));
    }

    public void setPasswordMap(String name, String credentialName, Password password) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonMap(credentialName, password)));
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) {
        if ((name = this.rewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new SimpleMapRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(String credentialName) {
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final String name;

        SimpleMapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            return entry.getPassword(credentialName) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        @Override
        public Credential getCredential(String credentialName) {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return null;
            }
            Password password = entry.getPassword(credentialName);
            return new PasswordCredential(password);
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            return entry == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(entry.getAttributes());
        }

        @Override
        public boolean verifyEvidence(String credentialName, Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            try {
                SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
                if (entry == null) {
                    return false;
                }
                Password password = entry.getPassword(credentialName);
                return password != null && evidence instanceof PasswordGuessEvidence && PasswordFactory.getInstance(password.getAlgorithm()).verify(password, ((PasswordGuessEvidence)evidence).getGuess());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RealmUnavailableException(e);
            }
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return SimpleMapBackedSecurityRealm.this.map.containsKey(this.name);
        }
    }
}

