/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm authorizationRealm;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.createRealmIdentity(name);
        try {
            RealmIdentity authorizationIdentity = this.authorizationRealm.createRealmIdentity(name);
            try {
                Identity identity = new Identity(authenticationIdentity, authorizationIdentity);
                ok = true;
                Identity identity2 = identity;
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                return identity2;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                throw throwable;
            }
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialAcquireSupport(credentialName);
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(String credentialName) throws RealmUnavailableException {
        return this.authenticationRealm.getEvidenceVerifySupport(credentialName);
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity authorizationIdentity;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity authorizationIdentity) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentity = authorizationIdentity;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialAcquireSupport(credentialName);
        }

        @Override
        public Credential getCredential(String credentialName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialName);
        }

        @Override
        public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType, Set<String> supportedAlgorithms) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialName, credentialType, supportedAlgorithms);
        }

        @Override
        public Credential getCredential(List<String> credentialNames, Map<Class<? extends Credential>, Set<String>> supportedTypesWithAlgorithms) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialNames, supportedTypesWithAlgorithms);
        }

        @Override
        public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialName, credentialType);
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(String credentialName) throws RealmUnavailableException {
            return this.authenticationIdentity.getEvidenceVerifySupport(credentialName);
        }

        @Override
        public boolean verifyEvidence(String credentialName, Evidence credential) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyEvidence(credentialName, credential);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.authorizationIdentity.exists() ? this.authorizationIdentity.getAuthorizationIdentity() : AuthorizationIdentity.EMPTY;
        }

        @Override
        public void dispose() {
            this.authenticationIdentity.dispose();
            this.authorizationIdentity.dispose();
        }
    }
}

