/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.credential.Credential;

public final class CredentialCallback
implements ExtendedCallback,
Serializable {
    private static final long serialVersionUID = 4756568346009259703L;
    private final Map<Class<? extends Credential>, Set<String>> supportedTypes;
    private Credential credential;

    private CredentialCallback(Map<Class<? extends Credential>, Set<String>> supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public boolean isCredentialSupported(Class<? extends Credential> credentialType, String algorithm) {
        Class<?>[] interfaces;
        Set<String> set = this.supportedTypes.get(credentialType);
        if (set != null) {
            return algorithm == null || set.isEmpty() || set.contains(algorithm);
        }
        Class<? extends Credential> superclass = credentialType.getSuperclass();
        if (Credential.class.isAssignableFrom(superclass) && this.isCredentialSupported(superclass.asSubclass(Credential.class), algorithm)) {
            return true;
        }
        for (Class<?> clazz : interfaces = credentialType.getInterfaces()) {
            if (!Credential.class.isAssignableFrom(superclass) || !this.isCredentialSupported(clazz.asSubclass(Credential.class), algorithm)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends Credential>> getSupportedTypes() {
        return Collections.unmodifiableSet(this.supportedTypes.keySet());
    }

    public Set<String> getSupportedAlgorithms(Class<? extends Credential> type) {
        return this.supportedTypes.get(type);
    }

    public Map<Class<? extends Credential>, Set<String>> getSupportedTypesWithAlgorithms() {
        return Collections.unmodifiableMap(this.supportedTypes);
    }

    @Override
    public boolean isOptional() {
        return this.credential != null;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Class<? extends Credential>, Set<String>> supportedTypes = new HashMap<Class<? extends Credential>, Set<String>>();
        private boolean built = false;

        Builder() {
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("CredentialCallback has already been built.");
            }
        }

        public Builder addSupportedCredentialType(Class<? extends Credential> credentialType) {
            this.assertNotBuilt();
            if (this.supportedTypes.containsKey(credentialType)) {
                throw new IllegalStateException("Credential type already added.");
            }
            this.supportedTypes.put(credentialType, Collections.emptySet());
            return this;
        }

        public Builder addSupportedCredentialType(Class<? extends Credential> credentialType, String ... supportedAlgorithms) {
            this.assertNotBuilt();
            if (this.supportedTypes.containsKey(credentialType)) {
                throw new IllegalStateException("Credential type already added.");
            }
            this.supportedTypes.put(credentialType, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(supportedAlgorithms))));
            return this;
        }

        public CredentialCallback build() {
            this.assertNotBuilt();
            this.built = true;
            return new CredentialCallback(this.supportedTypes);
        }
    }
}

