/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.text.Normalizer;
import org.wildfly.security.password.Password;

abstract class AbstractPasswordImpl
implements Password {
    private static final long serialVersionUID = -7527865607883174548L;

    AbstractPasswordImpl() {
    }

    abstract <S extends KeySpec> S getKeySpec(Class<S> var1) throws InvalidKeySpecException;

    abstract boolean verify(char[] var1) throws InvalidKeyException;

    abstract <T extends KeySpec> boolean convertibleTo(Class<T> var1);

    Password translate(AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException();
    }

    static byte[] getNormalizedPasswordBytes(char[] characters) {
        return Normalizer.normalize(new String(characters), Normalizer.Form.NFKC).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }
}

