/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.VerifyPeerTrustedCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetTrustManagerAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509TrustManager> trustManagerFactory;

    SetTrustManagerAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509TrustManager> trustManagerFactory) {
        super(parent);
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetTrustManagerAuthenticationConfiguration(newParent, this.trustManagerFactory);
    }

    @Override
    SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof VerifyPeerTrustedCallback) {
            X509TrustManager trustManager = null;
            try {
                trustManager = this.trustManagerFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToCreateTrustManager(e);
            }
            VerifyPeerTrustedCallback verifyPeerTrustedCallback = (VerifyPeerTrustedCallback)callback;
            X509Certificate[] certificateChain = verifyPeerTrustedCallback.getCertificateChain();
            String authType = verifyPeerTrustedCallback.getAuthType();
            boolean verified = true;
            try {
                trustManager.checkServerTrusted(certificateChain, authType);
            }
            catch (CertificateException e) {
                verified = false;
            }
            verifyPeerTrustedCallback.setVerified(verified);
            return;
        }
        super.handleCallback(callbacks, index);
    }
}

