/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.concurrent.Callable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.auth.client.PeerIdentityContext;
import org.wildfly.security.auth.client.PeerIdentityHandle;
import org.wildfly.security.authz.Attributes;

public final class PeerIdentity {
    private final PeerIdentityContext context;
    private final Principal peerPrincipal;
    private final PeerIdentityHandle handle;

    PeerIdentity(PeerIdentityContext context, Principal peerPrincipal, PeerIdentityHandle handle) {
        this.context = context;
        this.peerPrincipal = peerPrincipal;
        this.handle = handle;
    }

    public void runAs(Runnable runnable) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            runnable.run();
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> callable) throws Exception {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        PeerIdentity old = this.context.getAndSetPeerIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            this.context.setPeerIdentity(old);
        }
    }

    public Principal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    public Set<String> getPeerRoles() {
        return this.handle.getPeerRoles();
    }

    public boolean hasPeerRole(String roleName) {
        return this.handle.hasPeerRole(roleName);
    }

    public Attributes getPeerAttributes() {
        return this.handle.getPeerAttributes();
    }

    public Attributes.Entry getPeerAttribute(String key) {
        return this.handle.getPeerAttribute(key);
    }

    PeerIdentityContext getContext() {
        return this.context;
    }
}

