/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.KeyTypeCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.auth.callback.VerifyPeerTrustedCallback;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.entity.GeneralName;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.x500.X509CertificateCredentialDecoder;

final class EntitySaslServer
extends AbstractSaslServer {
    private static final int ST_CHALLENGE = 1;
    private static final int ST_PROCESS_RESPONSE = 2;
    private final SecureRandom secureRandom;
    private final Signature signature;
    private final boolean mutual;
    private final String serverName;
    private String authorizationID;
    private byte[] randomB;

    EntitySaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, Map<String, ?> props, boolean mutual, Signature signature, SecureRandom secureRandom) {
        super(mechanismName, protocol, serverName, callbackHandler);
        this.signature = signature;
        this.secureRandom = secureRandom;
        this.mutual = mutual;
        this.serverName = serverName;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.saslAuthenticationNotComplete(this.getMechanismName());
        }
        return this.authorizationID;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] evaluateMessage(int state, byte[] response) throws SaslException {
        switch (state) {
            case 1: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.log.saslInitialChallengeMustBeEmpty(this.getMechanismName());
                }
                tokenBA1 = new ByteStringBuilder();
                encoder = new DEREncoder(tokenBA1);
                try {
                    encoder.startSequence();
                    this.randomB = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    if (this.serverName != null && !this.serverName.isEmpty()) {
                        encoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(encoder, new GeneralName.DNSName(this.serverName));
                    }
                    trustedAuthoritiesCallback = new TrustedAuthoritiesCallback();
                    this.handleCallbacks(new Callback[]{trustedAuthoritiesCallback});
                    trustedAuthorities = trustedAuthoritiesCallback.getTrustedAuthorities();
                    if (trustedAuthorities != null && !trustedAuthorities.isEmpty()) {
                        encoder.encodeImplicit(1);
                        EntityUtil.encodeTrustedAuthorities(encoder, trustedAuthorities);
                    }
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.saslUnableToCreateResponseTokenWithCause(this.getMechanismName(), e);
                }
                this.setNegotiationState(2);
                return tokenBA1.toArray();
            }
            case 2: {
                decoder = new DERDecoder(response);
                serverCertChain = null;
                serverCert = null;
                serverCertUrl = null;
                privateKey = null;
                entityB = null;
                authID = null;
                try {
                    decoder.startSequence();
                    randomA = decoder.decodeOctetString();
                    if (decoder.isNextType(128, 0, true)) {
                        decoder.decodeImplicit(0);
                        entityB = EntityUtil.decodeGeneralNames(decoder);
                    }
                    decoder.startExplicit(1);
                    clientCertChain = EntityUtil.decodeCertificateData(decoder);
                    decoder.endExplicit();
                    clientCert = clientCertChain[0];
                    verifyPeerTrustedCallback = new VerifyPeerTrustedCallback(clientCertChain, clientCert.getPublicKey().getAlgorithm());
                    this.handleCallbacks(new Callback[]{verifyPeerTrustedCallback});
                    if (!verifyPeerTrustedCallback.isVerified()) {
                        throw ElytronMessages.log.saslAuthenticationFailed(this.getMechanismName());
                    }
                    clientName = X509CertificateCredentialDecoder.getInstance().getPrincipalFromCredential(clientCert).getName("CANONICAL");
                    if (decoder.isNextType(128, 2, true)) {
                        decoder.decodeImplicit(2);
                        authID = EntityUtil.decodeGeneralNames(decoder);
                        this.authorizationID = EntityUtil.getDistinguishedNameFromGeneralNames(authID);
                    } else {
                        this.authorizationID = clientName;
                    }
                    decoder.startSequence();
                    decoder.skipElement();
                    clientSignature = decoder.decodeBitString();
                    decoder.endSequence();
                    tbsDataAB = new ByteStringBuilder();
                    tbsEncoder = new DEREncoder(tbsDataAB);
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(this.randomB);
                    if (entityB != null) {
                        tbsEncoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(tbsEncoder, entityB);
                    }
                    if (authID != null) {
                        tbsEncoder.encodeImplicit(1);
                        EntityUtil.encodeGeneralNames(tbsEncoder, authID);
                    }
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initVerify(clientCert);
                        this.signature.update(tbsDataAB.toArray());
                        if (!this.signature.verify(clientSignature)) {
                            this.setNegotiationState(-1);
                            throw ElytronMessages.log.saslAuthenticationFailed(this.getMechanismName());
                        }
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.log.saslUnableToVerifyClientSignature(this.getMechanismName(), e);
                    }
                    decoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.saslInvalidClientMessageWithCause(this.getMechanismName(), e);
                }
                if (entityB != null || this.mutual) {
                    keyTypeCallback = new KeyTypeCallback(Entity.keyType(this.signature.getAlgorithm()));
                    credentialCallback = new CredentialCallback(Collections.singletonMap(X509Certificate[].class, Collections.emptySet()));
                    privateKeyCallback = new CredentialCallback(Collections.singletonMap(PrivateKey.class, Collections.emptySet()));
                    this.handleCallbacks(new Callback[]{keyTypeCallback, credentialCallback, privateKeyCallback});
                    serverCertChain = (X509Certificate[])credentialCallback.getCredential();
                    if (serverCertChain != null && serverCertChain.length > 0) {
                        serverCert = serverCertChain[0];
                    } else {
                        credentialCallback = new CredentialCallback(Collections.singletonMap(String.class, Collections.emptySet()));
                        this.handleCallbacks(new Callback[]{keyTypeCallback, credentialCallback, privateKeyCallback});
                        serverCertUrl = (String)credentialCallback.getCredential();
                        if (serverCertUrl != null) {
                            try {
                                serverCert = EntityUtil.getCertificateFromUrl(serverCertUrl);
                            }
                            catch (IOException e) {
                                throw ElytronMessages.log.saslUnableToObtainServerCertificate(this.getMechanismName(), serverCertUrl, e);
                            }
                        } else {
                            throw ElytronMessages.log.saslCallbackHandlerNotProvidedServerCertificate(this.getMechanismName());
                        }
                    }
                    privateKey = (PrivateKey)privateKeyCallback.getCredential();
                }
                if (entityB != null && !EntityUtil.matchGeneralNames(entityB, serverCert)) {
                    throw ElytronMessages.log.saslServerIdentifierMismatch(this.getMechanismName());
                }
                authorizeCallback = new AuthorizeCallback(clientName, this.authorizationID);
                this.handleCallbacks(new Callback[]{authorizeCallback});
                if (!authorizeCallback.isAuthorized()) {
                    throw ElytronMessages.log.saslAuthorizationFailed(this.getMechanismName(), clientName, this.authorizationID);
                }
                if (!this.mutual) ** GOTO lbl160
                tokenBA2 = new ByteStringBuilder();
                encoder = new DEREncoder(tokenBA2);
                try {
                    encoder.startSequence();
                    randomC = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    clientSubjectAltNames = null;
                    try {
                        clientSubjectAltNames = clientCert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException e) {
                        if (!clientName.isEmpty()) ** GOTO lbl122
                        throw ElytronMessages.log.saslUnableToDetermineClientName(this.getMechanismName(), e);
                    }
lbl122:
                    // 2 sources

                    encoder.encodeImplicit(0);
                    EntityUtil.encodeGeneralNames(encoder, clientName, clientSubjectAltNames);
                    encoder.startExplicit(1);
                    if (serverCertChain != null && serverCertChain.length > 0) {
                        EntityUtil.encodeX509CertificateChain(encoder, serverCertChain);
                    } else if (serverCertUrl != null) {
                        encoder.encodeIA5String(serverCertUrl);
                    } else {
                        throw ElytronMessages.log.saslCallbackHandlerNotProvidedServerCertificate(this.getMechanismName());
                    }
                    encoder.endExplicit();
                    if (privateKey == null) {
                        throw ElytronMessages.log.saslCallbackHandlerNotProvidedPrivateKey(this.getMechanismName());
                    }
                    tbsDataBA = new ByteStringBuilder();
                    tbsEncoder = new DEREncoder(tbsDataBA);
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(this.randomB);
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(randomC);
                    EntityUtil.encodeGeneralNames(tbsEncoder, clientName, clientSubjectAltNames);
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initSign(privateKey);
                        this.signature.update(tbsDataBA.toArray());
                        signatureBytes = this.signature.sign();
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.log.saslUnableToCreateSignature(this.getMechanismName(), e);
                    }
                    encoder.startSequence();
                    EntityUtil.encodeAlgorithmIdentifier(encoder, this.signature.getAlgorithm());
                    encoder.encodeBitString(signatureBytes);
                    encoder.endSequence();
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.saslUnableToCreateResponseTokenWithCause(this.getMechanismName(), e);
                }
                this.negotiationComplete();
                return tokenBA2.toArray();
lbl160:
                // 1 sources

                this.negotiationComplete();
                return null;
            }
            case 0: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.log.saslClientSentExtraMessage(this.getMechanismName());
                }
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

