/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Set;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.sasl.util.FilterMechanismSaslServerFactory;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

public final class SecurityDomainSaslConfiguration {
    private final SecurityDomain securityDomain;
    private final SaslServerFactory saslServerFactory;

    public SecurityDomainSaslConfiguration(SecurityDomain securityDomain, SaslServerFactory saslServerFactory) {
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        Assert.checkNotNullParam((String)"saslServerFactory", (Object)saslServerFactory);
        this.securityDomain = securityDomain;
        this.saslServerFactory = new FilterMechanismSaslServerFactory(saslServerFactory, name -> {
            Set<Class<?>> credentialTypes = SaslMechanismInformation.getSupportedServerCredentialTypes(name);
            if (credentialTypes == null) {
                return true;
            }
            for (Class<?> credentialType : credentialTypes) {
                Set<String> algorithms = SaslMechanismInformation.getSupportedServerCredentialAlgorithms(name, credentialType);
                if (algorithms.isEmpty()) {
                    if (securityDomain.getCredentialSupport(credentialType, null).isNotSupported()) continue;
                    return true;
                }
                for (String algorithm : algorithms) {
                    if (securityDomain.getCredentialSupport(credentialType, algorithm).isNotSupported()) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public SaslServerFactory getSaslServerFactory() {
        return this.saslServerFactory;
    }
}

