/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

public final class FileSystemSecurityRealm
implements ModifiableSecurityRealm {
    static final String ELYTRON_1_0 = "urn:elytron:1.0";
    private final Path root;
    private final NameRewriter nameRewriter;
    private final int levels;

    public FileSystemSecurityRealm(Path root, NameRewriter nameRewriter, int levels) {
        this.root = root;
        this.nameRewriter = nameRewriter;
        this.levels = levels;
    }

    public FileSystemSecurityRealm(Path root, int levels) {
        this.root = root;
        this.levels = levels;
        this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
    }

    public FileSystemSecurityRealm(Path root) {
        this.root = root;
        this.levels = 2;
        this.nameRewriter = NameRewriter.IDENTITY_REWRITER;
    }

    private Path pathFor(String name) {
        assert (name.codePointCount(0, name.length()) > 0);
        int levels = this.levels;
        Path path = this.root;
        int idx = 0;
        for (int level = 0; level < levels; ++level) {
            int newIdx = name.offsetByCodePoints(idx, 1);
            path = path.resolve(name.substring(idx, newIdx));
            idx = newIdx;
            if (idx == name.length()) break;
        }
        return path.resolve(name + ".xml");
    }

    @Override
    public ModifiableRealmIdentity createRealmIdentity(String name) {
        if (name.isEmpty()) {
            throw ElytronMessages.log.invalidEmptyName();
        }
        String finalName = this.nameRewriter.rewriteName(name);
        if (finalName == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new Identity(finalName, this.pathFor(finalName));
    }

    @Override
    public Iterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        return this.subIterator(this.root, this.levels);
    }

    private Iterator<ModifiableRealmIdentity> subIterator(Path root, final int levels) {
        Iterator<Path> iterator;
        if (levels == 0) {
            Iterator<Path> iterator2;
            try {
                iterator2 = Files.newDirectoryStream(root, "*.xml").iterator();
            }
            catch (IOException e) {
                return Collections.emptyIterator();
            }
            return new Iterator<ModifiableRealmIdentity>(){

                @Override
                public boolean hasNext() {
                    return iterator2.hasNext();
                }

                @Override
                public ModifiableRealmIdentity next() {
                    Path path = (Path)iterator2.next();
                    String fileName = path.getFileName().toString();
                    return FileSystemSecurityRealm.this.createRealmIdentity(fileName.substring(0, fileName.length() - 4));
                }
            };
        }
        try {
            iterator = Files.newDirectoryStream(root, entry -> {
                String fileName = entry.getFileName().toString();
                return fileName.length() == 1 && !fileName.equals(".") && Files.isDirectory(entry, new LinkOption[0]);
            }).iterator();
        }
        catch (IOException e) {
            return Collections.emptyIterator();
        }
        return new Iterator<ModifiableRealmIdentity>(){
            private Iterator<ModifiableRealmIdentity> subIterator;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.subIterator == null) {
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        Path path = (Path)iterator.next();
                        this.subIterator = FileSystemSecurityRealm.this.subIterator(path, levels - 1);
                        continue;
                    }
                    if (this.subIterator.hasNext()) {
                        return true;
                    }
                    this.subIterator = null;
                }
            }

            @Override
            public ModifiableRealmIdentity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.subIterator.next();
            }
        };
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
        return CredentialSupport.UNKNOWN;
    }

    static class AutoCloseableXMLStreamWriterHolder
    implements AutoCloseable {
        private final XMLStreamWriter xmlStreamWriter;

        AutoCloseableXMLStreamWriterHolder(XMLStreamWriter xmlStreamWriter) {
            this.xmlStreamWriter = xmlStreamWriter;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamWriter.close();
        }

        public XMLStreamWriter getXmlStreamWriter() {
            return this.xmlStreamWriter;
        }
    }

    static class AutoCloseableXMLStreamReaderHolder
    implements AutoCloseable {
        private final XMLStreamReader xmlStreamReader;

        AutoCloseableXMLStreamReaderHolder(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        @Override
        public void close() throws XMLStreamException {
            this.xmlStreamReader.close();
        }

        public XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }
    }

    final class LoadedIdentity {
        private final String name;
        private final List<Object> credentials;
        private final Attributes attributes;

        LoadedIdentity(String name, List<Object> credentials, Attributes attributes) {
            this.name = name;
            this.credentials = credentials;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        List<Object> getCredentials() {
            return this.credentials;
        }
    }

    class Identity
    implements ModifiableRealmIdentity {
        private static final String BASE64_FORMAT = "base64";
        private static final String MCF_FORMAT = "crypt";
        private final String name;
        private final Path path;

        Identity(String name, Path path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
            List<Object> credentials = this.loadCredentials();
            for (Object credential : credentials) {
                if (!credentialType.isInstance(credential)) continue;
                return CredentialSupport.FULLY_SUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            List<Object> credentials = this.loadCredentials();
            for (Object credential : credentials) {
                if (!credentialType.isInstance(credential)) continue;
                return credentialType.cast(credential);
            }
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            ClearPassword clearPassword = null;
            if (credential instanceof char[]) {
                try {
                    ClearPasswordSpec keySpec = new ClearPasswordSpec((char[])credential);
                    PasswordFactory instance = PasswordFactory.getInstance("clear");
                    clearPassword = (ClearPassword)instance.generatePassword(keySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw ElytronMessages.log.invalidCredentialTypeSpecified();
                }
            } else if (credential instanceof ClearPassword) {
                clearPassword = (ClearPassword)credential;
            }
            if (clearPassword != null) {
                List<Object> credentials = this.loadCredentials();
                for (Object ours : credentials) {
                    if (!(ours instanceof Password)) continue;
                    try {
                        Password password = (Password)ours;
                        String algorithm = password.getAlgorithm();
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                        return passwordFactory.verify(password, clearPassword.getPassword());
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    }
                }
            }
            return false;
        }

        private List<Object> loadCredentials() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            return loadedIdentity == null ? Collections.emptyList() : loadedIdentity.getCredentials();
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return Files.exists(this.path, new LinkOption[0]);
        }

        @Override
        public void delete() throws RealmUnavailableException {
            try {
                Files.delete(this.path);
            }
            catch (NoSuchFileException e) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.getName());
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmDeleteFailed(this.getName(), e);
            }
        }

        private String tempSuffix() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            char[] array = new char[12];
            for (int i = 0; i < array.length; ++i) {
                int idx = random.nextInt(36);
                array[i] = idx < 26 ? (char)(65 + idx) : (char)(48 + idx - 26);
            }
            return new String(array);
        }

        private Path tempPath() {
            Path parent = this.path.getParent();
            File file = parent.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            return parent.resolve(this.path.getFileName().toString() + '.' + this.tempSuffix());
        }

        @Override
        public void create() throws RealmUnavailableException {
            Path tempPath;
            while (true) {
                tempPath = this.tempPath();
                XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tempPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.DSYNC));){
                    try (AutoCloseableXMLStreamWriterHolder holder = new AutoCloseableXMLStreamWriterHolder(xmlOutputFactory.createXMLStreamWriter(outputStream));){
                        XMLStreamWriter streamWriter = holder.getXmlStreamWriter();
                        streamWriter.writeStartDocument();
                        streamWriter.writeCharacters("\n");
                        streamWriter.writeStartElement("", "identity", FileSystemSecurityRealm.ELYTRON_1_0);
                        streamWriter.writeDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
                        streamWriter.setDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
                        streamWriter.writeEndElement();
                        streamWriter.writeEndDocument();
                    }
                    catch (XMLStreamException e) {
                        throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.getName(), e);
                    }
                }
                catch (FileAlreadyExistsException ignored) {
                    continue;
                }
                catch (IOException e) {
                    throw ElytronMessages.log.fileSystemRealmFailedToOpen(tempPath, this.getName(), e);
                }
                break;
            }
            try {
                Files.createLink(this.path, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                try {
                    Files.delete(tempPath);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw ElytronMessages.log.fileSystemRealmAlreadyExists(this.getName(), e);
            }
            catch (IOException e) {
                throw ElytronMessages.log.fileSystemRealmFailedToWrite(tempPath, this.getName(), e);
            }
            try {
                Files.delete(tempPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void setCredentials(List<Object> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentials", credentials);
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.getName(), credentials, loadedIdentity.getAttributes());
            this.replaceIdentity(newIdentity);
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"attributes", (Object)attributes);
            LoadedIdentity loadedIdentity = this.loadIdentity(false, true);
            if (loadedIdentity == null) {
                throw ElytronMessages.log.fileSystemRealmNotFound(this.name);
            }
            LoadedIdentity newIdentity = new LoadedIdentity(this.getName(), loadedIdentity.getCredentials(), attributes);
            this.replaceIdentity(newIdentity);
        }

        /*
         * Exception decompiling
         */
        private void replaceIdentity(LoadedIdentity newIdentity) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [38[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void writeIdentity(XMLStreamWriter streamWriter, LoadedIdentity newIdentity) throws XMLStreamException, InvalidKeySpecException, NoSuchAlgorithmException, CertificateEncodingException {
            Iterator<Attributes.Entry> entryIter;
            streamWriter.writeStartDocument();
            streamWriter.writeCharacters("\n");
            streamWriter.writeStartElement("", "identity", FileSystemSecurityRealm.ELYTRON_1_0);
            streamWriter.writeDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
            streamWriter.setDefaultNamespace(FileSystemSecurityRealm.ELYTRON_1_0);
            Iterator<Object> credIter = newIdentity.getCredentials().iterator();
            if (credIter.hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "credentials");
                do {
                    streamWriter.writeCharacters("\n        ");
                    Object credential = credIter.next();
                    if (credential instanceof OneTimePassword) {
                        OneTimePassword otp = (OneTimePassword)credential;
                        otp.getHash();
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "otp");
                        streamWriter.writeAttribute("algorithm", otp.getAlgorithm());
                        streamWriter.writeAttribute("hash", ByteIterator.ofBytes(otp.getHash()).base64Encode().drainToString());
                        streamWriter.writeAttribute("seed", ByteIterator.ofBytes(otp.getSeed()).base64Encode().drainToString());
                        streamWriter.writeAttribute("sequence", Integer.toString(otp.getSequenceNumber()));
                        streamWriter.writeEndElement();
                        continue;
                    }
                    if (credential instanceof Password) {
                        String passwordString;
                        String format;
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "password");
                        Password password = (Password)credential;
                        String algorithm = password.getAlgorithm();
                        byte[] encoded = BasicPasswordSpecEncoding.encode(password);
                        if (encoded != null) {
                            format = BASE64_FORMAT;
                            passwordString = ByteIterator.ofBytes(encoded).base64Encode().drainToString();
                        } else {
                            format = MCF_FORMAT;
                            passwordString = ModularCrypt.encodeAsString(password);
                        }
                        streamWriter.writeAttribute("algorithm", algorithm);
                        streamWriter.writeAttribute("format", format);
                        streamWriter.writeCharacters(passwordString.toString());
                        streamWriter.writeEndElement();
                        continue;
                    }
                    if (credential instanceof PublicKey) {
                        PublicKey publicKey = (PublicKey)credential;
                        String algorithm = publicKey.getAlgorithm();
                        String format = publicKey.getFormat();
                        byte[] encoded = publicKey.getEncoded();
                        CodePointIterator iterator = ByteIterator.ofBytes(encoded).base64Encode();
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "public-key");
                        streamWriter.writeAttribute("algorithm", algorithm);
                        streamWriter.writeAttribute("format", format);
                        while (iterator.hasNext()) {
                            streamWriter.writeCharacters("\n            ");
                            streamWriter.writeCharacters(iterator.limitedTo(64).drainToString());
                        }
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeEndElement();
                        continue;
                    }
                    if (!(credential instanceof X509Certificate)) continue;
                    X509Certificate certificate = (X509Certificate)credential;
                    byte[] encoded = certificate.getEncoded();
                    CodePointIterator iterator = ByteIterator.ofBytes(encoded).base64Encode();
                    streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "certificate");
                    streamWriter.writeAttribute("algorithm", "X.509");
                    while (iterator.hasNext()) {
                        streamWriter.writeCharacters("\n            ");
                        streamWriter.writeCharacters(iterator.limitedTo(64).drainToString());
                    }
                    streamWriter.writeCharacters("\n        ");
                    streamWriter.writeEndElement();
                } while (credIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            if ((entryIter = newIdentity.getAttributes().entries().iterator()).hasNext()) {
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "attributes");
                do {
                    Attributes.Entry entry = entryIter.next();
                    for (String value : entry) {
                        streamWriter.writeCharacters("\n        ");
                        streamWriter.writeStartElement(FileSystemSecurityRealm.ELYTRON_1_0, "attribute");
                        streamWriter.writeAttribute("name", entry.getKey());
                        streamWriter.writeAttribute("value", value);
                        streamWriter.writeEndElement();
                    }
                } while (entryIter.hasNext());
                streamWriter.writeCharacters("\n    ");
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndDocument();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            LoadedIdentity loadedIdentity = this.loadIdentity(true, false);
            return loadedIdentity == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(loadedIdentity.getAttributes());
        }

        /*
         * Exception decompiling
         */
        private LoadedIdentity loadIdentity(boolean skipCredentials, boolean skipAttributes) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private LoadedIdentity parseIdentity(XMLStreamReader streamReader, boolean skipCredentials, boolean skipRoles) throws RealmUnavailableException, XMLStreamException {
            int tag = streamReader.nextTag();
            if (tag != 1 || !FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI()) || !"identity".equals(streamReader.getLocalName())) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            return this.parseIdentityContents(streamReader, skipCredentials, skipRoles);
        }

        private LoadedIdentity parseIdentityContents(XMLStreamReader streamReader, boolean skipCredentials, boolean skipRoles) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            List<Object> credentials = Collections.emptyList();
            Attributes attributes = Attributes.EMPTY;
            boolean gotCredentials = false;
            boolean gotRoles = false;
            while (!streamReader.isEndElement()) {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if (!gotCredentials && "credentials".equals(streamReader.getLocalName())) {
                    gotCredentials = true;
                    if (skipCredentials) {
                        this.consumeContent(streamReader);
                    } else {
                        credentials = this.parseCredentials(streamReader);
                    }
                } else if (!gotRoles && "attributes".equals(streamReader.getLocalName())) {
                    gotRoles = true;
                    if (skipRoles) {
                        this.consumeContent(streamReader);
                    } else {
                        attributes = this.parseAttributes(streamReader);
                    }
                }
                streamReader.nextTag();
            }
            return new LoadedIdentity(this.name, credentials, attributes);
        }

        private List<Object> parseCredentials(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (streamReader.nextTag() == 2) {
                return Collections.emptyList();
            }
            ArrayList<Object> credentials = new ArrayList<Object>();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if ("password".equals(streamReader.getLocalName())) {
                    credentials.add(this.parsePassword(streamReader));
                    continue;
                }
                if ("private-key".equals(streamReader.getLocalName())) {
                    credentials.add(this.parsePrivateKey(streamReader));
                    continue;
                }
                if ("certificate".equals(streamReader.getLocalName())) {
                    credentials.add(this.parseCertificate(streamReader));
                    continue;
                }
                if ("otp".equals(streamReader.getLocalName())) {
                    credentials.add(this.parseOtp(streamReader));
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            } while (streamReader.nextTag() != 2);
            return credentials;
        }

        private <C> C parseCredential(XMLStreamReader streamReader, CredentialParseFunction<C> function) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            String algorithm = null;
            String format = null;
            for (int i = 0; i < attributeCount; ++i) {
                if (streamReader.getAttributeNamespace(i) != null) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("format".equals(localName)) {
                    format = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            String text = streamReader.getElementText().trim();
            return function.parseCredential(algorithm, format, text);
        }

        private X509Certificate parseCertificate(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    algorithm = "X.509";
                }
                if (format == null) {
                    format = "X.509";
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(algorithm);
                    return (X509Certificate)certificateFactory.generateCertificate(CodePointIterator.ofString(text).base64Decode().asInputStream());
                }
                catch (ClassCastException | CertificateException e) {
                    throw ElytronMessages.log.fileSystemRealmCertificateReadError(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
            });
        }

        private PrivateKey parsePrivateKey(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                if (algorithm == null) {
                    throw ElytronMessages.log.fileSystemRealmMissingAttribute("algorithm", this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                try {
                    if (format != null && !format.equals("X.509")) {
                        throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                    }
                    X509EncodedKeySpec keySpec = new X509EncodedKeySpec(CodePointIterator.ofString(text).base64Decode().drain());
                    return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.fileSystemRealmUnsupportedKeyAlgorithm(format, this.path, streamReader.getLocation().getLineNumber(), this.getName(), e);
                }
            });
        }

        private Password parsePassword(XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            return this.parseCredential(streamReader, (algorithm, format, text) -> {
                try {
                    if (BASE64_FORMAT.equals(format)) {
                        byte[] passwordBytes = CodePointIterator.ofChars(text.toCharArray()).base64Decode().drain();
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                        PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode(passwordBytes);
                        if (passwordSpec != null) {
                            return passwordFactory.generatePassword(passwordSpec);
                        }
                        throw ElytronMessages.log.fileSystemRealmInvalidPasswordAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                    }
                    if (MCF_FORMAT.equals(format)) {
                        return ModularCrypt.decode(text);
                    }
                    throw ElytronMessages.log.fileSystemRealmInvalidPasswordFormat(format, this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
            });
        }

        private Password parseOtp(XMLStreamReader streamReader) throws XMLStreamException, RealmUnavailableException {
            String algorithm = null;
            byte[] hash = null;
            byte[] seed = null;
            int sequenceNumber = 0;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                if (streamReader.getAttributeNamespace(i) != null) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                String localName = streamReader.getAttributeLocalName(i);
                if ("algorithm".equals(localName)) {
                    algorithm = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("hash".equals(localName)) {
                    hash = CodePointIterator.ofString(streamReader.getAttributeValue(i)).base64Decode().drain();
                    continue;
                }
                if ("seed".equals(localName)) {
                    seed = CodePointIterator.ofString(streamReader.getAttributeValue(i)).base64Decode().drain();
                    continue;
                }
                if ("sequence".equals(localName)) {
                    sequenceNumber = Integer.parseInt(streamReader.getAttributeValue(i));
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            try {
                PasswordFactory passwordFactory = PasswordFactory.getInstance(algorithm);
                return passwordFactory.generatePassword(new OneTimePasswordSpec(hash, seed, sequenceNumber));
            }
            catch (InvalidKeySpecException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpDefinition(this.path, streamReader.getLocation().getLineNumber(), this.getName(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.fileSystemRealmInvalidOtpAlgorithm(algorithm, this.path, streamReader.getLocation().getLineNumber(), this.getName(), e);
            }
        }

        private Attributes parseAttributes(XMLStreamReader streamReader) throws RealmUnavailableException, XMLStreamException {
            int attributeCount = streamReader.getAttributeCount();
            if (attributeCount > 0) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            int tag = streamReader.nextTag();
            if (tag == 2) {
                return Attributes.EMPTY;
            }
            MapAttributes attributes = new MapAttributes();
            do {
                if (!FileSystemSecurityRealm.ELYTRON_1_0.equals(streamReader.getNamespaceURI())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if (!"attribute".equals(streamReader.getLocalName())) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                this.parseAttribute(streamReader, attributes);
            } while (streamReader.nextTag() == 1);
            return attributes;
        }

        private void parseAttribute(XMLStreamReader streamReader, Attributes attributes) throws XMLStreamException, RealmUnavailableException {
            String name = null;
            String value = null;
            int attributeCount = streamReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                if (streamReader.getAttributeNamespace(i) != null) {
                    throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
                }
                if ("name".equals(streamReader.getAttributeLocalName(i))) {
                    name = streamReader.getAttributeValue(i);
                    continue;
                }
                if ("value".equals(streamReader.getAttributeLocalName(i))) {
                    value = streamReader.getAttributeValue(i);
                    continue;
                }
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (name == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("name", this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            if (value == null) {
                throw ElytronMessages.log.fileSystemRealmMissingAttribute("value", this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
            attributes.addLast(name, value);
            if (streamReader.nextTag() != 2) {
                throw ElytronMessages.log.fileSystemRealmInvalidContent(this.path, streamReader.getLocation().getLineNumber(), this.getName());
            }
        }

        private void consumeContent(XMLStreamReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        this.consumeContent(reader);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
    }

    @FunctionalInterface
    static interface CredentialParseFunction<C> {
        public C parseCredential(String var1, String var2, String var3) throws RealmUnavailableException, XMLStreamException;
    }
}

