/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class SaslPredicates {
    private static final Set<String> MD5_MECHS = new HashSet<String>(Arrays.asList("CRAM-MD5", "DIGEST-MD5"));
    private static final Set<String> SHA_MECHS = new HashSet<String>(Arrays.asList("DIGEST-SHA", "SCRAM-SHA-1", "SCRAM-SHA-1-PLUS"));
    private static final Set<String> SHA_256_MECHS = new HashSet<String>(Arrays.asList("DIGEST-SHA-256", "SCRAM-SHA-256", "SCRAM-SHA-256-PLUS"));
    private static final Set<String> SHA_384_MECHS = new HashSet<String>(Arrays.asList("DIGEST-SHA-384", "SCRAM-SHA-384", "SCRAM-SHA-384-PLUS"));
    private static final Set<String> SHA_512_MECHS = new HashSet<String>(Arrays.asList("DIGEST-SHA-512", "SCRAM-SHA-512", "SCRAM-SHA-512-PLUS"));
    private static final Set<String> MUTUAL_MECHS = new HashSet<String>(Arrays.asList("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC"));
    private static final Set<String> RECOMMENDED_MECHS = new HashSet<String>(Arrays.asList("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-U-RSA-SHA1-ENC", "ANONYMOUS", "EAP-AES128", "EAP-AES128-PLUS", "EXTERNAL", "OAUTH10A", "OAUTHBEARER", "OPENID20", "OTP", "SAML20", "SECURID"));
    public static final Predicate<String> HASH_MD5 = MD5_MECHS::contains;
    public static final Predicate<String> HASH_SHA = SHA_MECHS::contains;
    public static final Predicate<String> HASH_SHA_256 = SHA_256_MECHS::contains;
    public static final Predicate<String> HASH_SHA_384 = SHA_384_MECHS::contains;
    public static final Predicate<String> HASH_SHA_512 = SHA_512_MECHS::contains;
    public static final Predicate<String> GS2 = name -> name.startsWith("GS2-");
    public static final Predicate<String> SCRAM = name -> name.startsWith("SCRAM-");
    public static final Predicate<String> MUTUAL = ((Predicate<String>)MUTUAL_MECHS::contains).or(SCRAM).or(GS2);
    public static final Predicate<String> BINDING = name -> name.endsWith("-PLUS");
    public static final Predicate<String> RECOMMENDED = ((Predicate<String>)RECOMMENDED_MECHS::contains).or(GS2).or(SCRAM).and(HASH_MD5.negate());
}

