/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawDigestPassword;

public interface DigestPassword
extends OneWayPassword {
    public static final String ALGORITHM_DIGEST_MD5 = "digest-md5";
    public static final String ALGORITHM_DIGEST_SHA = "digest-sha";
    public static final String ALGORITHM_DIGEST_SHA_256 = "digest-sha-256";
    public static final String ALGORITHM_DIGEST_SHA_512 = "digest-sha-512";

    public String getUsername();

    public String getRealm();

    public byte[] getDigest();

    public static DigestPassword createRaw(String algorithm, String username, String realm, byte[] digest) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"username", (Object)username);
        Assert.checkNotNullParam((String)"realm", (Object)realm);
        Assert.checkNotNullParam((String)"digest", (Object)digest);
        return new RawDigestPassword(algorithm, username, realm, (byte[])digest.clone());
    }
}

