/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.nio.charset.StandardCharsets;
import java.security.spec.InvalidKeySpecException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.CodePointIterator;

class UserPasswordPasswordUtil {
    private UserPasswordPasswordUtil() {
    }

    public static Password parseUserPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword == null || userPassword.length == 0) {
            throw ElytronMessages.log.nullOrEmptyParameter("userPassword");
        }
        if (userPassword[0] != 123) {
            return UserPasswordPasswordUtil.createClearPassword(userPassword);
        }
        if (userPassword[1] == 109 && userPassword[2] == 100 && userPassword[3] == 53 && userPassword[4] == 125) {
            return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-md5", 5, userPassword);
        }
        if (userPassword[1] == 115 && userPassword[2] == 104 && userPassword[3] == 97) {
            if (userPassword[4] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-1", 5, userPassword);
            }
            if (userPassword[4] == 50 && userPassword[5] == 53 && userPassword[6] == 54 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-256", 8, userPassword);
            }
            if (userPassword[4] == 51 && userPassword[5] == 56 && userPassword[6] == 52 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-384", 8, userPassword);
            }
            if (userPassword[4] == 53 && userPassword[5] == 49 && userPassword[6] == 50 && userPassword[7] == 125) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-512", 8, userPassword);
            }
        } else {
            if (userPassword[1] == 115 && userPassword[2] == 109 && userPassword[3] == 100 && userPassword[4] == 53 && userPassword[5] == 125) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-md5", 6, userPassword);
            }
            if (userPassword[1] == 115 && userPassword[2] == 115 && userPassword[3] == 104 && userPassword[4] == 97) {
                if (userPassword[5] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-1", 6, userPassword);
                }
                if (userPassword[5] == 50 && userPassword[6] == 53 && userPassword[7] == 54 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-256", 9, userPassword);
                }
                if (userPassword[5] == 51 && userPassword[6] == 56 && userPassword[7] == 52 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-384", 9, userPassword);
                }
                if (userPassword[5] == 53 && userPassword[6] == 49 && userPassword[7] == 50 && userPassword[8] == 125) {
                    return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-512", 9, userPassword);
                }
            } else if (userPassword[1] == 99 && userPassword[2] == 114 && userPassword[3] == 121 && userPassword[4] == 112 && userPassword[5] == 116 && userPassword[6] == 125) {
                if (userPassword[7] == 95) {
                    return UserPasswordPasswordUtil.createBsdCryptBasedPassword(userPassword);
                }
                return UserPasswordPasswordUtil.createCryptBasedPassword(userPassword);
            }
        }
        for (int i = 1; i < userPassword.length - 1; ++i) {
            if (userPassword[i] != 125) continue;
            throw new InvalidKeySpecException();
        }
        return UserPasswordPasswordUtil.createClearPassword(userPassword);
    }

    private static Password createClearPassword(byte[] userPassword) {
        return ClearPassword.createRaw("clear", new String(userPassword, StandardCharsets.UTF_8).toCharArray());
    }

    private static Password createSimpleDigestPassword(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int length = userPassword.length - prefixSize;
        byte[] digest = CodePointIterator.ofUtf8Bytes(userPassword, prefixSize, length).base64Decode().drain();
        return SimpleDigestPassword.createRaw(algorithm, digest);
    }

    private static Password createSaltedSimpleDigestPassword(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int digestLength;
        int length = userPassword.length - prefixSize;
        byte[] decoded = CodePointIterator.ofUtf8Bytes(userPassword, prefixSize, length).base64Decode().drain();
        int saltLength = decoded.length - (digestLength = UserPasswordPasswordUtil.expectedDigestLengthBytes(algorithm));
        if (saltLength < 1) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        byte[] digest = new byte[digestLength];
        byte[] salt = new byte[saltLength];
        System.arraycopy(decoded, 0, digest, 0, digestLength);
        System.arraycopy(decoded, digestLength, salt, 0, saltLength);
        return SaltedSimpleDigestPassword.createRaw(algorithm, digest, salt);
    }

    private static Password createCryptBasedPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 20) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        int lo = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[7] & 0xFF);
        int hi = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        if (lo == -1 || hi == -1) {
            throw ElytronMessages.log.invalidSalt((char)lo, (char)hi);
        }
        short salt = (short)(lo | hi << 6);
        byte[] hash = CodePointIterator.ofUtf8Bytes(userPassword, 9, 11).base64Decode(Alphabet.Base64Alphabet.MOD_CRYPT, false).drain();
        return UnixDESCryptPassword.createRaw("crypt-des", salt, hash);
    }

    private static Password createBsdCryptBasedPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 27) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        int b0 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        int b1 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[9] & 0xFF);
        int b2 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[10] & 0xFF);
        int b3 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[11] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw ElytronMessages.log.invalidRounds((char)b0, (char)b1, (char)b2, (char)b3);
        }
        int iterationCount = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        b0 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[12] & 0xFF);
        b1 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[13] & 0xFF);
        b2 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[14] & 0xFF);
        b3 = Alphabet.Base64Alphabet.MOD_CRYPT.decode(userPassword[15] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw ElytronMessages.log.invalidSalt((char)b0, (char)b1, (char)b2, (char)b3);
        }
        int salt = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        byte[] hash = CodePointIterator.ofUtf8Bytes(userPassword, 16, 11).base64Decode(Alphabet.Base64Alphabet.MOD_CRYPT, false).drain();
        return BSDUnixDESCryptPassword.createRaw("bsd-crypt-des", hash, salt, iterationCount);
    }

    private static int expectedDigestLengthBytes(String algorithm) {
        switch (algorithm) {
            case "password-salt-digest-md5": {
                return 16;
            }
            case "password-salt-digest-sha-1": {
                return 20;
            }
            case "password-salt-digest-sha-256": {
                return 32;
            }
            case "password-salt-digest-sha-384": {
                return 48;
            }
            case "password-salt-digest-sha-512": {
                return 64;
            }
        }
        throw ElytronMessages.log.unrecognizedAlgorithm(algorithm);
    }
}

