/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security._private;

import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.callback.Callback;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServerFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.util.DecodeException;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages xmlLog = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.xml");

    @LogMessage
    @Message(id=1, value="WildFly Elytron version %s")
    public void logVersion(String var1);

    @Message(id=2, value="Parse error")
    public String parseError();

    @Message(id=3, value="Parameter %s is null")
    public IllegalArgumentException nullParameter(String var1);

    @Message(id=4, value="Parameter %s is null or empty")
    public IllegalArgumentException nullOrEmptyParameter(String var1);

    @Message(id=5, value="This builder has already been built")
    public IllegalStateException builderAlreadyBuilt();

    @Message(id=6, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @Message(id=7, value="Cannot instantiate self-referential factory")
    public IllegalStateException cannotInstantiateSelfReferentialFactory();

    @Message(id=8, value="Unexpected trailing garbage in X.500 principal")
    public IllegalArgumentException unexpectedTrailingGarbageInX500principal();

    @Message(id=1001, value="No module found for identifier \"%s\"")
    public ConfigXMLParseException noModuleFound(@Param XMLStreamReader var1, @Cause ModuleLoadException var2, ModuleIdentifier var3);

    @Message(id=1002, value="Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)")
    public ConfigXMLParseException xmlInvalidPortNumber(@Param XMLStreamReader var1, String var2, String var3, QName var4);

    @Message(id=1003, value="No authentication is in progress")
    public IllegalStateException noAuthenticationInProgress();

    @Message(id=1004, value="Authentication already complete on this context")
    public IllegalStateException alreadyComplete();

    @Message(id=1005, value="Authentication already initiated on this context")
    public IllegalStateException alreadyInitiated();

    @Message(id=1006, value="Realm map does not contain mapping for default realm '%s'")
    public IllegalArgumentException realmMapDoesntContainDefault(String var1);

    @Message(id=1007, value="No realm name found in properties file")
    public IOException noRealmFoundInProperties();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1008, value="JAAS authentication failed for principal %s")
    public void debugJAASAuthenticationFailure(Principal var1, @Cause Throwable var2);

    @Message(id=1009, value="Failed to create login context")
    public RealmUnavailableException failedToCreateLoginContext(@Cause Throwable var1);

    @Message(id=1010, value="Failed to instantiate custom CallbackHandler")
    public RealmUnavailableException failedToInstantiateCustomHandler(@Cause Throwable var1);

    @Message(id=1011, value="The Callback array cannot be null")
    public IllegalArgumentException invalidNullCallbackArray();

    @Message(id=1012, value="Credential cannot be converted to a password")
    public FastUnsupportedCallbackException failedToConvertCredentialToPassword(@Param Callback var1);

    @Message(id=1013, value="Unrecognized principal type for %s")
    public IllegalArgumentException unrecognizedPrincipalType(Principal var1);

    @Message(id=1014, value="Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToOpen(Path var1, String var2, @Cause IOException var3);

    @Message(id=1015, value="Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToRead(Path var1, String var2, @Cause Exception var3);

    @Message(id=1016, value="Invalid empty name given")
    public IllegalArgumentException invalidEmptyName();

    @Message(id=1017, value="Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidContent(Path var1, int var2, String var3);

    @Message(id=1018, value="Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmMissingAttribute(String var1, Path var2, int var3, String var4);

    @Message(id=1019, value="Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidPasswordFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1020, value="Filesystem-backed realm failed to rename \"%s\" to \"%s\"")
    public RealmUnavailableException fileSystemRealmRenameFailed(String var1, String var2, @Cause IOException var3);

    @Message(id=1021, value="Filesystem-backed realm failed to delete identity \"%s\"")
    public RealmUnavailableException fileSystemRealmDeleteFailed(String var1, @Cause IOException var2);

    @Message(id=1022, value="Filesystem-backed realm failed to find identity \"%s\"")
    public RealmUnavailableException fileSystemRealmNotFound(String var1);

    @Message(id=1023, value="Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToWrite(Path var1, String var2, @Cause Exception var3);

    @Message(id=1024, value="Filesystem-backed realm cannot create duplicate identity for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmAlreadyExists(String var1, @Cause Throwable var2);

    @Message(id=1025, value="Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmCertificateReadError(String var1, Path var2, int var3, String var4);

    @Message(id=1026, value="Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1027, value="Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(String var1, Path var2, int var3, String var4);

    @Message(id=1028, value="Invalid port number \"%d\"")
    public IllegalArgumentException invalidPortNumber(int var1);

    @Message(id=1029, value="Invalid host specification \"%s\"")
    public IllegalArgumentException invalidHostSpec(String var1);

    @Message(id=1030, value="Unable to read credential")
    public IOException unableToReadCredential(@Cause Exception var1);

    @Message(id=1031, value="Missing reference in extends")
    public IllegalArgumentException missingReferenceInExtends();

    @Message(id=1032, value="Invalid combination of obtainable and verifiable")
    public IllegalArgumentException invalidCombinationOfObtainableAndVerifiable();

    @Message(id=1033, value="User does not exist")
    public IllegalStateException userDoesNotExist();

    @Message(id=1034, value="Invalid credential type specified")
    public IllegalStateException invalidCredentialTypeSpecified();

    @Message(id=1035, value="Mechanism supplied multiple login names")
    public SaslException saslMechanismSuppliedMultipleLoginNames();

    @Message(id=1036, value="Unknown user name")
    public SaslException saslUnknownUserName();

    @Message(id=1037, value="No user identity loaded for credential verification")
    public SaslException saslNoUserIdentityLoadedForCredentialVerification();

    @Message(id=1038, value="Could get not RSA key from query")
    public RuntimeException couldNotGetRsaKeyFromQuery(@Cause Throwable var1);

    @Message(id=1039, value="Invalid algorithm \"%s\"")
    public RuntimeException invalidAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1040, value="Could not parse private key")
    public RuntimeException couldNotParsePrivateKey(@Cause Throwable var1);

    @Message(id=1041, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredential();

    @Message(id=1042, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredentialWithCause(@Cause Throwable var1);

    @Message(id=1043, value="Invalid password key specification for algorithm \"%s\"")
    public RuntimeException invalidPasswordKeySpecificationForAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1044, value="Salt is expected when creating \"%s\" passwords")
    public RuntimeException saltIsExpectedWhenCreatingPasswords(String var1);

    @Message(id=1045, value="Could not obtain PasswordFactory for algorithm \"%s\"")
    public RuntimeException couldNotObtainPasswordFactoryForAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1046, value="Unknown password type or algorithm \"%s\"")
    public InvalidKeyException unknownPasswordTypeOrAlgorithm(String var1);

    @Message(id=1047, value="Password-based credentials must be either a String, char[] or ClearPassword")
    public RuntimeException passwordBasedCredentialsMustBeStringCharsOrClearPassword();

    @Message(id=1048, value="Invalid password key for algorithm \"%s\"")
    public RuntimeException invalidPasswordKeyForAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1049, value="Could not open connection")
    public RuntimeException couldNotOpenConnection(@Cause Throwable var1);

    @Message(id=1050, value="Could not execute query \"%s\"")
    public RuntimeException couldNotExecuteQuery(String var1, @Cause Throwable var2);

    @Message(id=1051, value="Realm is unavailable")
    public RuntimeException realmIsUnavailable(@Cause Throwable var1);

    @Message(id=1052, value="Unexpected error when processing authentication query \"%s\"")
    public RuntimeException unexpectedErrorWhenProcessingAuthenticationQuery(String var1, @Cause Throwable var2);

    @Message(id=1053, value="Insufficient data to form a digest and a salt")
    public InvalidKeySpecException insufficientDataToFormDigestAndSalt();

    @Message(id=1054, value="Invalid salt \"%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2);

    @Message(id=1055, value="Invalid rounds \"%s%s%s%s\"")
    public IllegalArgumentException invalidRounds(char var1, char var2, char var3, char var4);

    @Message(id=1056, value="Invalid salt \"%s%s%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2, char var3, char var4);

    @Message(id=1057, value="No DirContextFactory set")
    public IllegalStateException noDirContextFactorySet();

    @Message(id=1058, value="No principal mapping definition")
    public IllegalStateException noPrincipalMappingDefinition();

    @Message(id=1060, value="Could not obtain principal")
    public RuntimeException couldNotObtainPrincipal();

    @Message(id=1061, value="Could not obtain principal")
    public RuntimeException couldNotObtainPrincipalWithCause(@Cause Throwable var1);

    @Message(id=1062, value="No provider URL has been set")
    public IllegalStateException noProviderUrlSet();

    @Message(id=1063, value="Security domain name \"%s\" is invalid")
    public IllegalArgumentException securityDomainNameIsInvalid(String var1);

    @Message(id=1064, value="Invalid name")
    public IllegalArgumentException invalidName();

    @Message(id=1065, value="Pattern requires a capture group")
    public IllegalArgumentException patternRequiresCaptureGroup();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1066, value="Invalid string count for mechanism database entry \"%s\"")
    public void warnInvalidStringCountForMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1067, value="Invalid key exchange \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidKeyExchangeForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1068, value="Invalid authentication \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAuthenticationForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1069, value="Invalid encryption \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidEncryptionForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1070, value="Invalid digest \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidDigestForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1071, value="Invalid protocol \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidProtocolForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1072, value="Invalid level \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidLevelForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1073, value="Invalid strength bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidStrengthBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1074, value="Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1075, value="Invalid duplicate mechanism database entry \"%s\"")
    public void warnInvalidDuplicateMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1076, value="Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")")
    public void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1077, value="Invalid alias \"%s\" for missing mechanism database entry \"%s\"")
    public void warnInvalidAliasForMissingMechanismDatabaseEntry(String var1, String var2);

    @Message(id=5149, value="Ldap-backed realm failed to obtain identity from server")
    public RuntimeException ldapRealmFailedObtainIdentityFromServer(@Cause Throwable var1);

    @Message(id=8029, value="Ldap-backed realm failed to obtain attributes for entry [%s]")
    public RuntimeException ldapRealmFailedObtainAttributes(String var1, @Cause Throwable var2);

    @Message(id=8030, value="Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].")
    public RuntimeException ldapRealmInvalidRdnForAttribute(String var1, String var2, String var3);

    @Message(id=2001, value="Invalid key store entry password for alias \"%s\"")
    public UnrecoverableKeyException invalidKeyStoreEntryPassword(String var1);

    @Message(id=2002, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public KeyStoreException invalidKeyStoreEntryType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=2003, value="Key store key for alias \"%s\" cannot be protected")
    public KeyStoreException keyCannotBeProtected(String var1);

    @Message(id=2004, value="Key store failed to translate password for alias \"%s\"")
    public IOException keyStoreFailedToTranslate(String var1, @Cause Throwable var2);

    @Message(id=2005, value="Key store failed to identify a suitable algorithm for alias \"%s\"")
    public NoSuchAlgorithmException noAlgorithmForPassword(String var1);

    @Message(id=2006, value="Unexpected whitespace in password file")
    public IOException unexpectedWhitespaceInPasswordFile();

    @Message(id=2007, value="Unexpected end of file")
    public EOFException unexpectedEof();

    @Message(id=2008, value="A reversible load is not possible until the KeyStore has first been initialized")
    public IllegalStateException reversibleLoadNotPossible();

    @Message(id=2009, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=2010, value="Invalid password type for alias %s (expected %s, got %s)")
    public KeyStoreException invalidPasswordType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=2011, value="The password entry must contain a non null realm name")
    public KeyStoreException invalidNullRealmInPasswordEntry();

    @Message(id=2012, value="The password entry realm for alias %s must match the properties-based keystore realm. (expected %s, got %s)")
    public KeyStoreException invalidRealmNameInPasswordEntry(String var1, String var2, String var3);

    @Message(id=2013, value="Invalid algorithm found in password entry for alias %s (expected %s, got %s)")
    public KeyStoreException invalidAlgorithmInPasswordEntry(String var1, String var2, String var3);

    @Message(id=2014, value="Unknown key store specified")
    public IllegalArgumentException unknownKeyStoreSpecified();

    @Message(id=2015, value="Failed to load keystore data")
    public KeyStoreException failedToLoadKeyStoreData(@Cause Throwable var1);

    @Message(id=2016, value="Secret keys not supported")
    public KeyStoreException secretKeysNotSupported();

    @Message(id=2017, value="Direct key storage not supported")
    public KeyStoreException directKeyStorageNotSupported();

    @Message(id=2018, value="Only password storage is supported")
    public KeyStoreException onlyPasswordStorageIsSupported();

    @Message(id=3001, value="Unexpected padding")
    public DecodeException unexpectedPadding();

    @Message(id=3002, value="Expected padding")
    public DecodeException expectedPadding();

    @Message(id=3003, value="Incomplete decode")
    public DecodeException incompleteDecode();

    @Message(id=3004, value="Expected %d padding characters")
    public DecodeException expectedPaddingCharacters(int var1);

    @Message(id=3005, value="Invalid base 32 character")
    public DecodeException invalidBase32Character();

    @Message(id=3006, value="Expected an even number of hex characters")
    public DecodeException expectedEvenNumberOfHexCharacters();

    @Message(id=3007, value="Invalid hex character")
    public DecodeException invalidHexCharacter();

    @Message(id=3008, value="Expected two padding characters")
    public DecodeException expectedTwoPaddingCharacters();

    @Message(id=3009, value="Invalid base 64 character")
    public DecodeException invalidBase64Character();

    @Message(id=4001, value="No algorithm found matching TLS/SSL protocol selection criteria")
    public NoSuchAlgorithmException noAlgorithmForSslProtocol();

    @Message(id=4002, value="Empty certificate chain is not trusted")
    public CertificateException emptyChainNotTrusted();

    @Message(id=4003, value="Certificate not trusted due to realm failure for principal %s")
    public CertificateException notTrustedRealmProblem(@Cause RealmUnavailableException var1, Principal var2);

    @Message(id=4004, value="Credential validation failed; certificate is not trusted for principal %s")
    public CertificateException notTrusted(Principal var1);

    @Message(id=4005, value="No default trust manager available")
    public NoSuchAlgorithmException noDefaultTrustManager();

    @Message(id=4006, value="No host for SSL connection")
    public SSLHandshakeException noHostForSslConnection();

    @Message(id=4007, value="SSL channel is closed")
    public SSLException sslClosed();

    @Message(id=4008, value="Initial SSL/TLS data is not a handshake record")
    public SSLHandshakeException notHandshakeRecord();

    @Message(id=4009, value="Initial SSL/TLS handshake record is invalid")
    public SSLHandshakeException invalidHandshakeRecord();

    @Message(id=4010, value="Initial SSL/TLS handshake spans multiple records")
    public SSLHandshakeException multiRecordSSLHandshake();

    @Message(id=4011, value="Expected \"client hello\" record")
    public SSLHandshakeException expectedClientHello();

    @Message(id=4012, value="Unsupported SSL/TLS record")
    public SSLHandshakeException unsupportedSslRecord();

    @Message(id=4013, value="Invalid SNI extension")
    public SSLProtocolException invalidSniExt();

    @Message(id=4014, value="Not enough data in record to fill declared item size")
    public SSLProtocolException notEnoughData();

    @Message(id=4015, value="Empty host name in SNI record data")
    public SSLProtocolException emptyHostNameSni();

    @Message(id=4016, value="Duplicated SNI server name of type %d")
    public SSLProtocolException duplicatedSniServerName(int var1);

    @Message(id=4017, value="Unknown authentication name \"%s\"")
    public IllegalArgumentException unknownAuthenticationName(String var1);

    @Message(id=4018, value="Unknown encryption name \"%s\"")
    public IllegalArgumentException unknownEncryptionName(String var1);

    @Message(id=4019, value="Unknown key exchange name \"%s\"")
    public IllegalArgumentException unknownKeyExchangeName(String var1);

    @Message(id=4020, value="Mechanism \"%s\" not supported by transformation mapper")
    public IllegalArgumentException mechanismNotSupported(String var1);

    @Message(id=4021, value="Invalid index %d")
    public IndexOutOfBoundsException invalidIndex(int var1);

    @Message(id=4022, value="Invalid socket address type for URI")
    public IllegalArgumentException invalidSocketAddressTypeForUri();

    @Message(id=4023, value="Too large")
    public IllegalStateException tooLarge();

    @Message(id=5001, value="[%s] SASL exchange received a message after authentication was already complete")
    public SaslException saslMessageAfterComplete(String var1);

    @Message(id=5002, value="[%s] SASL user name contains an invalid or disallowed character")
    public SaslException saslUserNameContainsInvalidCharacter(String var1);

    @Message(id=5003, value="[%s] SASL user name could not be decoded from encoding \"%s\"")
    public SaslException saslUserNameDecodeFailed(String var1, String var2);

    @Message(id=5004, value="[%s] SASL authorization failed")
    public SaslException saslAuthorizationFailed(String var1, @Cause Throwable var2);

    @Message(id=5005, value="[%s] SASL authentication is not yet complete")
    public IllegalStateException saslAuthenticationNotComplete(String var1);

    @Message(id=5006, value="[%s] SASL mechanism not support security layer (wrapping/unwrapping)")
    public SaslException saslNoSecurityLayer(String var1);

    @Message(id=5007, value="[%s] Invalid SASL negotiation message received")
    public SaslException saslInvalidMessageReceived(String var1);

    @Message(id=5008, value="[%s] No SASL login name was given")
    public SaslException saslNoLoginNameGiven(String var1);

    @Message(id=5009, value="[%s] No SASL password was given")
    public SaslException saslNoPasswordGiven(String var1);

    @Message(id=5010, value="[%s] SASL authentication failed due to one or more malformed fields")
    public SaslException saslMalformedFields(String var1, @Cause IllegalArgumentException var2);

    @Message(id=5011, value="[%s] SASL message is too long")
    public SaslException saslMessageTooLong(String var1);

    @Message(id=5012, value="[%s] SASL server-side authentication failed")
    public SaslException saslServerSideAuthenticationFailed(String var1, @Cause Exception var2);

    @Message(id=5013, value="[%s] SASL password not verified")
    public SaslException saslPasswordNotVerified(String var1);

    @Message(id=5014, value="[%s] SASL authorization failed: \"%s\" is not authorized to act on behalf of \"%s\"")
    public SaslException saslAuthorizationFailed(String var1, String var2, String var3);

    @Message(id=5015, value="Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedChar(int var1, int var2, String var3);

    @Message(id=5016, value="Unrecognized token \"%s\" in mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnknownToken(String var1, String var2);

    @Message(id=5017, value="Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenNotAllowed(String var1, int var2, String var3);

    @Message(id=5018, value="Expected token \"%s\" at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenExpected(String var1, int var2, String var3);

    @Message(id=5019, value="[%s] Proxied SASL authentication failed")
    public SaslException saslProxyAuthenticationFailed(String var1);

    @Message(id=5020, value="No SASL client mechanism \"%s\" is available with the current configuration from %s")
    public SaslException saslNoClientMechanism(String var1, SaslClientFactory var2);

    @Message(id=5021, value="No SASL server mechanism \"%s\" is available with the current configuration from %s")
    public SaslException saslNoServerMechanism(String var1, SaslServerFactory var2);

    @Message(id=5022, value="[%s] Initial challenge must be empty")
    public SaslException saslInitialChallengeMustBeEmpty(String var1);

    @Message(id=5023, value="[%s] Unable to set channel binding")
    public SaslException saslUnableToSetChannelBinding(String var1, @Cause Exception var2);

    @Message(id=5024, value="Failed to determine channel binding status")
    public SaslException saslFailedToDetermineChannelBindingStatus(@Cause Exception var1);

    @Message(id=5025, value="[%s] Mutual authentication not enabled")
    public SaslException saslMutualAuthenticationNotEnabled(String var1);

    @Message(id=5026, value="[%s] Unable to map SASL mechanism name to a GSS-API OID")
    public SaslException saslMechanismToOidMappingFailed(String var1, @Cause Exception var2);

    @Message(id=5027, value="[%s] Unable to dispose of GSSContext")
    public SaslException saslUnableToDisposeGssContext(String var1, @Cause Exception var2);

    @Message(id=5028, value="[%s] Unable to create name for acceptor")
    public SaslException saslUnableToCreateNameForAcceptor(String var1, @Cause Exception var2);

    @Message(id=5029, value="[%s] Unable to create GSSContext")
    public SaslException saslUnableToCreateGssContext(String var1, @Cause Exception var2);

    @Message(id=5030, value="[%s] Unable to set GSSContext request flags")
    public SaslException saslUnableToSetGssContextRequestFlags(String var1, @Cause Exception var2);

    @Message(id=5031, value="[%s] Unable to accept SASL client message")
    public SaslException saslUnableToAcceptClientMessage(String var1, @Cause Exception var2);

    @Message(id=5032, value="[%s] GSS-API mechanism mismatch between SASL client and server")
    public SaslException saslGssApiMechanismMismatch(String var1);

    @Message(id=5033, value="[%s] Channel binding not supported for this SASL mechanism")
    public SaslException saslChannelBindingNotSupported(String var1);

    @Message(id=5034, value="[%s] Channel binding type mismatch between SASL client and server")
    public SaslException saslChannelBindingTypeMismatch(String var1);

    @Message(id=5035, value="[%s] Channel binding not provided by client")
    public SaslException saslChannelBindingNotProvided(String var1);

    @Message(id=5036, value="[%s] Unable to determine peer name")
    public SaslException saslUnableToDeterminePeerName(String var1, @Cause Exception var2);

    @Message(id=5037, value="[%s] SASL client refuses to initiate authentication")
    public SaslException saslClientRefusesToInitiateAuthentication(String var1);

    @Message(id=5038, value="[%s] Nonces do not match")
    public SaslException saslNoncesDoNotMatch(String var1);

    @Message(id=5039, value="[%s] Server nonce is too short")
    public SaslException saslServerNonceIsTooShort(String var1);

    @Message(id=5040, value="[%s] Iteration count %d is below the minimum of %d")
    public SaslException saslIterationCountIsTooLow(String var1, int var2, int var3);

    @Message(id=5041, value="[%s] Iteration count %d is above the maximum of %d")
    public SaslException saslIterationCountIsTooHigh(String var1, int var2, int var3);

    @Message(id=5042, value="[%s] Extensions unsupported")
    public SaslException saslExtensionsUnsupported(String var1);

    @Message(id=5043, value="[%s] Invalid server message")
    public SaslException saslInvalidServerMessage(String var1);

    @Message(id=5044, value="[%s] Invalid server message")
    public SaslException saslInvalidServerMessageWithCause(String var1, @Cause Throwable var2);

    @Message(id=5045, value="[%s] Invalid client message")
    public SaslException saslInvalidClientMessage(String var1);

    @Message(id=5046, value="[%s] Invalid client message")
    public SaslException saslInvalidClientMessageWithCause(String var1, @Cause Throwable var2);

    @Message(id=5047, value="[%s] Server rejected authentication: %s")
    public SaslException saslServerRejectedAuthentication(String var1, String var2);

    @Message(id=5048, value="[%s] Server rejected authentication")
    public SaslException saslServerRejectedAuthentication(String var1);

    @Message(id=5049, value="[%s] Server authenticity cannot be verified")
    public SaslException saslServerAuthenticityCannotBeVerified(String var1);

    @Message(id=5050, value="[%s] Callback handler does not support user name")
    public SaslException saslCallbackHandlerDoesNotSupportUserName(String var1, @Cause Throwable var2);

    @Message(id=5051, value="[%s] Callback handler does not support credential acquisition")
    public SaslException saslCallbackHandlerDoesNotSupportCredentialAcquisition(String var1, @Cause Throwable var2);

    @Message(id=5052, value="[%s] Callback handler does not support authorization")
    public SaslException saslAuthorizationUnsupported(String var1, @Cause Throwable var2);

    @Message(id=5053, value="[%s] Callback handler failed for unknown reason")
    public SaslException saslCallbackHandlerFailedForUnknownReason(String var1, @Cause Throwable var2);

    @Message(id=5054, value="[%s] Salt must be specified")
    public SaslException saslSaltMustBeSpecified(String var1);

    @Message(id=5055, value="[%s] Authentication rejected (invalid proof)")
    public SaslException saslAuthenticationRejectedInvalidProof(String var1);

    @Message(id=5056, value="[%s] Client sent extra message")
    public SaslException saslClientSentExtraMessage(String var1);

    @Message(id=5057, value="[%s] Server sent extra message")
    public SaslException saslServerSentExtraMessage(String var1);

    @Message(id=5058, value="[%s] Authentication failed")
    public SaslException saslAuthenticationFailed(String var1);

    @Message(id=5059, value="[%s] Invalid MAC initialization key")
    public SaslException saslInvalidMacInitializationKey(String var1);

    @Message(id=5060, value="Empty number")
    public NumberFormatException emptyNumber();

    @Message(id=5061, value="Invalid numeric character")
    public NumberFormatException invalidNumericCharacter();

    @Message(id=5062, value="Too big number")
    public NumberFormatException tooBigNumber();

    @Message(id=5063, value="[%s] Cannot get clear password from two way password")
    public SaslException saslCannotGetTwoWayPasswordChars(String var1, @Cause Throwable var2);

    @Message(id=5064, value="[%s] Hashing algorithm not supported")
    public SaslException saslMacAlgorithmNotSupported(String var1, @Cause Throwable var2);

    @Message(id=5065, value="[%s] keyword cannot be empty")
    public SaslException saslKeywordCannotBeEmpty(String var1);

    @Message(id=5066, value="[%s] No value found for keyword: %s")
    public SaslException saslNoValueFoundForKeyword(String var1, String var2);

    @Message(id=5067, value="[%s] '=' expected after keyword: %s")
    public SaslException saslKeywordNotFolowedByEqual(String var1, String var2);

    @Message(id=5068, value="[%s] Unmatched quote found for value: %s")
    public SaslException saslUnmatchedQuoteFoundForValue(String var1, String var2);

    @Message(id=5069, value="[%s] Expecting comma or linear whitespace after quoted string: %s")
    public SaslException saslExpectingCommaOrLinearWhitespaceAfterQuoted(String var1, String var2);

    @Message(id=5070, value="[%s] MessageType must equal to %d, but it is %d")
    public SaslException saslMessageTypeMustEqual(String var1, int var2, int var3);

    @Message(id=5071, value="[%s] Bad sequence number while unwrapping: expected %d, but %d received")
    public SaslException saslBadSequenceNumberWhileUnwrapping(String var1, int var2, int var3);

    @Message(id=5072, value="[%s] Problem during crypt")
    public SaslException saslProblemDuringCrypt(String var1, @Cause Throwable var2);

    @Message(id=5073, value="[%s] Problem during decrypt")
    public SaslException saslProblemDuringDecrypt(String var1, @Cause Throwable var2);

    @Message(id=5074, value="[%s] Unknown cipher \"%s\"")
    public SaslException saslUnknownCipher(String var1, String var2);

    @Message(id=5075, value="[%s] Cipher \"%s\" unsupported by ")
    public SaslException saslUnsupportedCipher(String var1, String var2);

    @Message(id=5076, value="[%s] Problem getting required cipher. Check your transformation mapper settings.")
    public SaslException saslProblemGettingRequiredCipher(String var1, @Cause Throwable var2);

    @Message(id=5077, value="[%s] No common protection layer between client and server")
    public SaslException saslNoCommonProtectionLayer(String var1);

    @Message(id=5078, value="[%s] No common cipher between client and server")
    public SaslException saslNoCommonCipher(String var1);

    @Message(id=5079, value="[%s] No ciphers offered by server")
    public SaslException saslNoCiphersOfferedByServer(String var1);

    @Message(id=5080, value="[%s] Callback handler not provided user name")
    public SaslException saslNotProvidedUserName(String var1);

    @Message(id=5081, value="[%s] Callback handler not provided pre-digested password")
    public SaslException saslNotProvidedPreDigested(String var1);

    @Message(id=5082, value="[%s] Callback handler not provided clear password")
    public SaslException saslNotProvidedClearPassword(String var1);

    @Message(id=5083, value="[%s] Missing \"%s\" directive")
    public SaslException saslMissingDirective(String var1, String var2);

    @Message(id=5084, value="[%s] nonce-count must equal to %d, but it is %d")
    public SaslException saslNonceCountMustEqual(String var1, int var2, int var3);

    @Message(id=5085, value="[%s] Server is set to not support %s charset")
    public SaslException saslUnsupportedCharset(String var1, String var2);

    @Message(id=5086, value="[%s] Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)")
    public SaslException saslUnknownCharset(String var1);

    @Message(id=5087, value="[%s] Client selected realm not offered by server (%s)")
    public SaslException saslUnallowedClientRealm(String var1, String var2);

    @Message(id=5088, value="[%s] Mismatched digest-uri \"%s\" Expected: \"%s\"")
    public SaslException saslMismatchedWrongDigestUri(String var1, String var2, String var3);

    @Message(id=5089, value="[%s] Unexpected qop value: \"%s\"")
    public SaslException saslUnexpectedQop(String var1, String var2);

    @Message(id=5090, value="[%s] Wrapping is not configured")
    public IllegalStateException wrappingNotConfigured(String var1);

    @Message(id=5091, value="[%s] Authentication name string is too long")
    public SaslException saslAuthenticationNameTooLong(String var1);

    @Message(id=5092, value="[%s] Authentication name is empty")
    public SaslException saslAuthenticationNameIsEmpty(String var1);

    @Message(id=5093, value="[%s] Authorization for anonymous access is denied")
    public SaslException saslAnonymousAuthorizationDenied(String var1);

    @Message(id=5094, value="Required padded length (%d) is less than length of conversion result (%d)")
    public IllegalArgumentException requiredNegativePadding(int var1, int var2);

    @Message(id=5095, value="Invalid key provided for Digest HMAC computing")
    public SaslException saslInvalidKeyForDigestHMAC();

    @Message(id=5096, value="Unable to read certificate from URL \"%s\"")
    public IOException asnUnableToReadCertificateFromUrl(String var1, @Cause Throwable var2);

    @Message(id=5097, value="Unable to determine subject name from X.509 certificate")
    public IllegalStateException unableToDetermineSubjectName(@Cause Throwable var1);

    @Message(id=5098, value="[%s] Unable to verify client signature")
    public SaslException saslUnableToVerifyClientSignature(String var1, @Cause Throwable var2);

    @Message(id=5099, value="[%s] Unable to verify server signature")
    public SaslException saslUnableToVerifyServerSignature(String var1, @Cause Throwable var2);

    @Message(id=5100, value="[%s] Unable to obtain other side certificate from URL \"%s\"")
    public SaslException saslUnableToObtainServerCertificate(String var1, String var2, @Cause Throwable var3);

    @Message(id=5101, value="[%s] Callback handler not provided URL of server certificate")
    public SaslException saslCallbackHandlerNotProvidedServerCertificate(String var1);

    @Message(id=5102, value="[%s] Callback handler not provided URL of client certificate")
    public SaslException saslCallbackHandlerNotProvidedClientCertificate(String var1);

    @Message(id=5103, value="[%s] Server identifier mismatch")
    public SaslException saslServerIdentifierMismatch(String var1);

    @Message(id=5104, value="[%s] Client identifier mismatch")
    public SaslException saslClientIdentifierMismatch(String var1);

    @Message(id=5105, value="[%s] Unable to determine client name")
    public SaslException saslUnableToDetermineClientName(String var1, @Cause Throwable var2);

    @Message(id=5106, value="[%s] Callback handler not provided private key")
    public SaslException saslCallbackHandlerNotProvidedPrivateKey(String var1);

    @Message(id=5107, value="[%s] Unable to create signature")
    public SaslException saslUnableToCreateSignature(String var1, @Cause Throwable var2);

    @Message(id=5108, value="[%s] Unable to create response token")
    public SaslException saslUnableToCreateResponseToken(String var1, @Cause Throwable var2);

    @Message(id=5109, value="[%s] Unable to create response token")
    public SaslException saslUnableToCreateResponseTokenWithCause(String var1, @Cause Throwable var2);

    @Message(id=5110, value="Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)")
    public IllegalArgumentException invalidValueForTrustedAuthorityType();

    @Message(id=5111, value="Invalid value for a general name type; expected a value between 0 and 8 (inclusive)")
    public IllegalArgumentException invalidValueForGeneralNameType();

    @Message(id=5112, value="Getting SASL mechanisms supported by GSS-API failed")
    public SaslException saslGettingSupportedMechanismsFailed(@Cause Throwable var1);

    @Message(id=5113, value="Unable to initialize OID of Kerberos V5")
    public RuntimeException unableToInitialiseOid(@Cause Throwable var1);

    @Message(id=5114, value="[%s] Receive buffer requested '%d' is greater than supported maximum '%d'")
    public SaslException saslReceiveBufferIsGreaterThanMaximum(String var1, int var2, int var3);

    @Message(id=5115, value="[%s] Unable to wrap message")
    public SaslException saslUnableToWrapMessage(String var1, @Cause Throwable var2);

    @Message(id=5116, value="[%s] Unable to unwrap message")
    public SaslException saslUnableToUnwrapMessage(String var1, @Cause Throwable var2);

    @Message(id=5117, value="[%s] Unable to unwrap security layer negotiation message")
    public SaslException saslUnableToUnwrapSecurityLayerNegotiationMessage(String var1, @Cause Throwable var2);

    @Message(id=5118, value="[%s] Invalid message of length %d on unwrapping")
    public SaslException saslInvalidMessageOnUnwrapping(String var1, int var2);

    @Message(id=5119, value="[%s] Negotiated mechanism was not Kerberos V5")
    public SaslException saslNegotiatedMechanismWasNotKerberosV5(String var1);

    @Message(id=5120, value="[%s] Insufficient levels of protection available for supported security layers")
    public SaslException saslInsufficientQopsAvailable(String var1);

    @Message(id=5121, value="[%s] Unable to generate security layer challenge")
    public SaslException saslUnableToGenerateChallenge(String var1, @Cause Throwable var2);

    @Message(id=5122, value="[%s] Client selected a security layer that was not offered by server")
    public SaslException saslSelectedUnofferedQop(String var1);

    @Message(id=5123, value="[%s] No security layer selected but message length received")
    public SaslException saslNoSecurityLayerButLengthReceived(String var1);

    @Message(id=5124, value="[%s] Unable to get maximum size of message before wrap")
    public SaslException saslUnableToGetMaximumSizeOfMessage(String var1, @Cause Throwable var2);

    @Message(id=5125, value="[%s] Unable to handle response from server")
    public SaslException saslUnableToHandleResponseFromServer(String var1, @Cause Throwable var2);

    @Message(id=5126, value="[%s] Bad length of message for negotiating security layer")
    public SaslException saslBadLengthOfMessageForNegotiatingSecurityLayer(String var1);

    @Message(id=5127, value="[%s] No security layer supported by server but maximum message size received: \"%d\"")
    public SaslException saslReceivedMaxMessageSizeWhenNoSecurityLayer(String var1, int var2);

    @Message(id=5128, value="[%s] Failed to read challenge file")
    public SaslException saslFailedToReadChallengeFile(String var1, @Cause Throwable var2);

    @Message(id=5129, value="[%s] Failed to create challenge file")
    public SaslException saslFailedToCreateChallengeFile(String var1, @Cause Throwable var2);

    @Message(id=5130, value="Invalid non-ASCII space \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiSpace(int var1);

    @Message(id=5131, value="Invalid ASCII control \"0x%X\"")
    public IllegalArgumentException invalidAsciiControl(int var1);

    @Message(id=5132, value="Invalid non-ASCII control \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiControl(int var1);

    @Message(id=5133, value="Invalid private use character \"0x%X\"")
    public IllegalArgumentException invalidPrivateUseCharacter(int var1);

    @Message(id=5134, value="Invalid non-character code point \"0x%X\"")
    public IllegalArgumentException invalidNonCharacterCodePoint(int var1);

    @Message(id=5135, value="Invalid surrogate code point \"0x%X\"")
    public IllegalArgumentException invalidSurrogateCodePoint(int var1);

    @Message(id=5136, value="Invalid plain text code point \"0x%X\"")
    public IllegalArgumentException invalidPlainTextCodePoint(int var1);

    @Message(id=5137, value="Invalid non-canonical code point \"0x%X\"")
    public IllegalArgumentException invalidNonCanonicalCodePoint(int var1);

    @Message(id=5138, value="Invalid control character \"0x%X\"")
    public IllegalArgumentException invalidControlCharacter(int var1);

    @Message(id=5139, value="Invalid tagging character \"0x%X\"")
    public IllegalArgumentException invalidTaggingCharacter(int var1);

    @Message(id=5140, value="Unassigned code point \"0x%X\"")
    public IllegalArgumentException unassignedCodePoint(int var1);

    @Message(id=5141, value="Invalid surrogate pair (high at end of string) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairHightAtEnd(char var1);

    @Message(id=5142, value="Invalid surrogate pair (second is not low) \"0x%X 0x%X\"")
    public IllegalArgumentException invalidSurrogatePairSecondIsNotLow(char var1, char var2);

    @Message(id=5143, value="Invalid surrogate pair (low without high) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairLowWithoutHigh(char var1);

    @Message(id=5144, value="Invalid code point \"0x%X\"")
    public IllegalArgumentException invalidCodePoint(int var1);

    @Message(id=5145, value="Disallowed R/AL directionality character in L string")
    public IllegalArgumentException disallowedRalDirectionalityInL();

    @Message(id=5146, value="Disallowed L directionality character in R/AL string")
    public IllegalArgumentException disallowedLDirectionalityInRal();

    @Message(id=5147, value="Missing trailing R/AL directionality character")
    public IllegalArgumentException missingTrailingRal();

    @Message(id=5148, value="Invalid escape sequence")
    public IllegalArgumentException invalidEscapeSequence();

    @Message(id=7001, value="Unrecognized encoding algorithm")
    public ASN1Exception asnUnrecognisedAlgorithm();

    @Message(id=7002, value="Invalid general name type")
    public ASN1Exception asnInvalidGeneralNameType();

    @Message(id=7003, value="Invalid trusted authority type")
    public ASN1Exception asnInvalidTrustedAuthorityType();

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();

    @Message(id=7005, value="Unable to read X.509 certificate data")
    public ASN1Exception asnUnableToReadCertificateData(@Cause Throwable var1);

    @Message(id=7006, value="Invalid general name for URI type")
    public ASN1Exception asnInvalidGeneralNameForUriType(@Cause Throwable var1);

    @Message(id=7007, value="Invalid general name for IP address type")
    public ASN1Exception asnInvalidGeneralNameForIpAddressType();

    @Message(id=7008, value="IP address general name cannot be resolved")
    public ASN1Exception asnIpAddressGeneralNameCannotBeResolved(@Cause Throwable var1);

    @Message(id=7009, value="No sequence to end")
    public IllegalStateException noSequenceToEnd();

    @Message(id=7010, value="No set to end")
    public IllegalStateException noSetToEnd();

    @Message(id=7011, value="No explicitly tagged element to end")
    public IllegalStateException noExplicitlyTaggedElementToEnd();

    @Message(id=7012, value="Unexpected end of input")
    public ASN1Exception asnUnexpectedEndOfInput();

    @Message(id=7013, value="Invalid number of unused bits")
    public ASN1Exception asnInvalidNumberOfUnusedBits();

    @Message(id=7014, value="Non-zero length encountered for null type tag")
    public ASN1Exception asnNonZeroLengthForNullTypeTag();

    @Message(id=7015, value="Invalid high-tag-number form")
    public ASN1Exception asnInvalidHighTagNumberForm();

    @Message(id=7016, value="Length encoding exceeds 4 bytes")
    public ASN1Exception asnLengthEncodingExceeds4bytes();

    @Message(id=7017, value="Invalid OID character")
    public ASN1Exception asnInvalidOidCharacter();

    @Message(id=7018, value="OID must have at least 2 components")
    public ASN1Exception asnOidMustHaveAtLeast2Components();

    @Message(id=7019, value="Invalid value for first OID component; expected 0, 1, or 2")
    public ASN1Exception asnInvalidValueForFirstOidComponent();

    @Message(id=7020, value="Invalid value for second OID component; expected a value between 0 and 39 (inclusive)")
    public ASN1Exception asnInvalidValueForSecondOidComponent();

    @Message(id=7021, value="Invalid length")
    public ASN1Exception asnInvalidLength();

    @Message(id=7022, value="Unknown tag type: %d")
    public ASN1Exception asnUnknownTagType(int var1);

    @Message(id=7023, value="Unexpected character byte for printable string")
    public ASN1Exception asnUnexpectedCharacterByteForPrintableString();

    @Message(id=8001, value="Unrecognized key spec algorithm")
    public InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm();

    @Message(id=8002, value="Password spec cannot be rendered as a string")
    public InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString();

    @Message(id=8003, value="Unknown crypt string algorithm")
    public InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm();

    @Message(id=8004, value="Invalid character encountered")
    public InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered();

    @Message(id=8005, value="No iteration count terminator given")
    public InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven();

    @Message(id=8006, value="Unexpected end of input string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString();

    @Message(id=8007, value="No salt terminator given")
    public InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven();

    @Message(id=8008, value="Invalid hash length")
    public IllegalArgumentException invalidHashLength();

    @Message(id=8009, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString();

    @Message(id=8010, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(@Cause Throwable var1);

    @Message(id=8011, value="Invalid minor version")
    public InvalidKeySpecException invalidKeySpecInvalidMinorVersion();

    @Message(id=8012, value="Invalid cost: must be a two digit integer")
    public InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger();

    @Message(id=8013, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8014, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8015, value="Cannot verify password")
    public InvalidKeyException invalidKeyCannotVerifyPassword(@Cause Throwable var1);

    @Message(id=8016, value="DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8017, value="DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8018, value="Salt must be %d bytes (%d bits)")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int var1, int var2);

    @Message(id=8019, value="Unsupported parameter spec")
    public InvalidParameterSpecException invalidParameterSpecUnsupportedParameterSpec();

    @Message(id=8020, value="Invalid number of rounds. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int var1, int var2);

    @Message(id=8021, value="Invalid salt. Must be a %d byte array")
    public IllegalArgumentException invalidSaltMustBeByteArray(int var1);

    @Message(id=8022, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8023, value="Salt must be %d bytes")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int var1);

    @Message(id=8024, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8025, value="Expected to get a \"%s\" as spec, got \"%s\"")
    public InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String var1, String var2);

    @Message(id=8026, value="Unknown algorithm or incompatible PasswordSpec")
    public InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec();

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();

    @Message(id=8028, value="Invalid algorithm \"%s\"")
    public NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String var1);
}

