/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class FilterMechanismSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final boolean include;
    private final Set<String> mechanisms;

    public FilterMechanismSaslClientFactory(SaslClientFactory delegate, boolean include, String ... mechanisms) {
        super(delegate);
        if (mechanisms == null) {
            throw new IllegalArgumentException("mechanisms is null");
        }
        this.include = include;
        HashSet<String> set = new HashSet<String>(mechanisms.length);
        Collections.addAll(set, mechanisms);
        this.mechanisms = set;
    }

    public FilterMechanismSaslClientFactory(SaslClientFactory delegate, boolean include, Collection<String> mechanisms) {
        super(delegate);
        if (mechanisms == null) {
            throw new IllegalArgumentException("mechanisms is null");
        }
        this.include = include;
        this.mechanisms = new HashSet<String>(mechanisms);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if (this.mechanisms.contains(mechanism) == this.include) continue;
            ArrayList<String> list = new ArrayList<String>(mechanisms.length - 1);
            for (String m2 : mechanisms) {
                if (this.mechanisms.contains(mechanism) != this.include) continue;
                list.add(m2);
            }
            if (list.size() == 0) {
                return null;
            }
            return this.delegate.createSaslClient(list.toArray(new String[list.size()]), authorizationId, protocol, serverName, props, cbh);
        }
        return this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names = this.delegate.getMechanismNames(props);
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            if (this.mechanisms.contains(name) != this.include) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }
}

