/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.wildfly.security.sasl.gssapi.AbstractGssapiMechanism;

public class GssapiServer
extends AbstractGssapiMechanism
implements SaslServer {
    private static final Logger log = Logger.getLogger(GssapiServer.class);
    private static final int ACCEPTOR_STATE = 1;
    private static final int SECURITY_LAYER_ADVERTISER = 2;
    private static final int SECURITY_LAYER_RECEIVER = 3;
    private String authroizationId;
    private byte offeredSecurityLayer;

    GssapiServer(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        super("GSSAPI", protocol, serverName, props, callbackHandler, log);
        GSSManager manager = GSSManager.getInstance();
        String localName = protocol + "@" + serverName;
        log.tracef("Our name '%s'", (Object)localName);
        GSSContext gssContext = null;
        try {
            GSSName ourName = manager.createName(localName, GSSName.NT_HOSTBASED_SERVICE, KERBEROS_V5);
            GSSCredential ourCredential = manager.createCredential(ourName, Integer.MAX_VALUE, KERBEROS_V5, 2);
            gssContext = manager.createContext(ourCredential);
        }
        catch (GSSException e) {
            throw new SaslException("Unable to create GSSContext", e);
        }
        this.gssContext = gssContext;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        this.assertComplete();
        return this.authroizationId;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                assert (!this.gssContext.isEstablished());
                try {
                    byte[] response = this.gssContext.acceptSecContext(message, 0, message.length);
                    if (this.gssContext.isEstablished()) {
                        Oid actualMech = this.gssContext.getMech();
                        log.tracef("Negotiated mechanism %s", (Object)actualMech);
                        if (!KERBEROS_V5.equals(actualMech)) {
                            throw new SaslException("Negotiated mechanism was not Kerberos V5");
                        }
                        this.setNegotiationState(2);
                        if (response == null || response.length == 0) {
                            log.trace((Object)"No response so triggering next state immediately.");
                            return this.evaluateMessage(null);
                        }
                    } else {
                        log.trace((Object)"GSSContext not established, expecting subsequent exchange.");
                    }
                    return response;
                }
                catch (GSSException e) {
                    throw new SaslException("Unable to accept message from client.", e);
                }
            }
            case 2: {
                if (message != null && message.length > 0) {
                    throw new SaslException("Only expecting an empty message, received a full message.");
                }
                byte[] response = new byte[4];
                byte supportedSecurityLayers = 0;
                boolean offeringSecurityLayer = false;
                block19: for (AbstractGssapiMechanism.QOP current : this.orderedQops) {
                    switch (current) {
                        case AUTH_INT: {
                            if (this.gssContext.getIntegState()) {
                                supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                                offeringSecurityLayer = true;
                                log.trace((Object)"Offering AUTH_INT");
                                continue block19;
                            }
                            log.trace((Object)"No integrity protection so unable to offer AUTH_INT");
                            continue block19;
                        }
                        case AUTH_CONF: {
                            if (this.gssContext.getConfState()) {
                                supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                                offeringSecurityLayer = true;
                                log.trace((Object)"Offering AUTH_CONF");
                                continue block19;
                            }
                            log.trace((Object)"No confidentiality available so unable to offer AUTH_CONF");
                            continue block19;
                        }
                        default: {
                            supportedSecurityLayers = (byte)(supportedSecurityLayers | current.getValue());
                        }
                    }
                }
                if (supportedSecurityLayers == 0) {
                    throw new SaslException("Insufficient levels of protection available for supported security layers.");
                }
                response[0] = supportedSecurityLayers;
                try {
                    byte[] length;
                    if (offeringSecurityLayer) {
                        log.tracef("Our max buffer size %d", (Object)this.configuredMaxReceiveBuffer);
                        length = this.intToNetworkOrderBytes(this.configuredMaxReceiveBuffer);
                    } else {
                        log.trace((Object)"Not offering a security layer so zero length.");
                        length = new byte[]{0, 0, 0};
                    }
                    System.arraycopy(length, 0, response, 1, 3);
                    MessageProp msgProp = new MessageProp(0, false);
                    response = this.gssContext.wrap(response, 0, 4, msgProp);
                }
                catch (GSSException e) {
                    throw new SaslException("Unable to generate security layer challenge.", e);
                }
                log.trace((Object)"Transitioning to receive chosen security layer from client");
                this.offeredSecurityLayer = supportedSecurityLayers;
                this.setNegotiationState(3);
                return response;
            }
            case 3: {
                String authenticationId;
                byte[] unwrapped;
                MessageProp msgProp = new MessageProp(0, false);
                try {
                    unwrapped = this.gssContext.unwrap(message, 0, message.length, msgProp);
                }
                catch (GSSException e) {
                    throw new SaslException("Unable to unwrap security layer response.", e);
                }
                if (unwrapped.length < 4) {
                    throw new SaslException(String.format("Invalid message of length %d on unwrapping.", unwrapped.length));
                }
                if ((this.offeredSecurityLayer & unwrapped[0]) == 0) {
                    throw new SaslException("Client selected a security layer that was not offered.");
                }
                AbstractGssapiMechanism.QOP selectedQop = AbstractGssapiMechanism.QOP.mapFromValue(unwrapped[0]);
                assert (selectedQop != null);
                this.maxBuffer = this.networkOrderBytesToInt(unwrapped, 1, 3);
                log.tracef("Client selected security layer %s, with maxBuffer of %d", (Object)selectedQop, (Object)this.maxBuffer);
                if (!this.relaxComplianceChecks && selectedQop == AbstractGssapiMechanism.QOP.AUTH && this.maxBuffer != 0) {
                    throw new SaslException("No security layer selected but message length received.");
                }
                try {
                    this.maxBuffer = this.gssContext.getWrapSizeLimit(0, selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF, this.maxBuffer);
                }
                catch (GSSException e) {
                    throw new SaslException("Unable to get maximum size of message before wrap.", e);
                }
                this.selectedQop = selectedQop;
                try {
                    authenticationId = this.gssContext.getSrcName().toString();
                }
                catch (GSSException e) {
                    throw new SaslException("Unable to determine name of peer.", e);
                }
                String authorizationId = unwrapped.length > 4 ? new String(unwrapped, 4, unwrapped.length - 4, StandardCharsets.UTF_8) : authenticationId;
                log.tracef("Authentication ID=%s,  Authorization ID=%s", (Object)authenticationId, (Object)authorizationId);
                AuthorizeCallback cb = new AuthorizeCallback(authenticationId, authorizationId);
                this.handleCallbacks(cb);
                if (!cb.isAuthorized()) {
                    throw new SaslException(String.format("User %s is not authorized to act as %s", authenticationId, authorizationId));
                }
                this.authroizationId = authorizationId;
                if (selectedQop != AbstractGssapiMechanism.QOP.AUTH) {
                    log.trace((Object)"Setting message wrapper.");
                    this.setWrapper(new AbstractGssapiMechanism.GssapiWrapper(this, selectedQop == AbstractGssapiMechanism.QOP.AUTH_CONF));
                }
                log.trace((Object)"Negotiation complete.");
                this.negotiationComplete();
                return null;
            }
        }
        throw new SaslException("Invalid state");
    }
}

