/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.spi;

import org.wildfly.security.auth.spi.SupportLevel;

public enum CredentialSupport {
    UNSUPPORTED(SupportLevel.UNSUPPORTED, SupportLevel.UNSUPPORTED),
    POSSIBLY_VERIFIABLE(SupportLevel.UNSUPPORTED, SupportLevel.POSSIBLY_SUPPORTED),
    VERIFIABLE_ONLY(SupportLevel.UNSUPPORTED, SupportLevel.SUPPORTED),
    UNKNOWN(SupportLevel.POSSIBLY_SUPPORTED, SupportLevel.POSSIBLY_SUPPORTED),
    VERIFIABLE_MAYBE_OBTAINABLE(SupportLevel.POSSIBLY_SUPPORTED, SupportLevel.SUPPORTED),
    FULLY_SUPPORTED(SupportLevel.SUPPORTED, SupportLevel.SUPPORTED);

    private final SupportLevel obtainable;
    private final SupportLevel verifiable;

    private CredentialSupport(SupportLevel obtainable, SupportLevel verifiable) {
        this.obtainable = obtainable;
        this.verifiable = verifiable;
    }

    public SupportLevel obtainableSupportLevel() {
        return this.obtainable;
    }

    public SupportLevel verificationSupportLevel() {
        return this.verifiable;
    }

    public boolean isDefinitelyObtainable() {
        return this.obtainable.isDefinitelySupported();
    }

    public boolean isDefinitelyVerifiable() {
        return this.verifiable.isDefinitelySupported();
    }

    public boolean mayBeObtainable() {
        return this.obtainable.mayBeSupported();
    }

    public boolean mayBeVerifiable() {
        return this.verifiable.mayBeSupported();
    }

    public boolean isNotObtainable() {
        return this.obtainable.isNotSupported();
    }

    public boolean isNotVerifiable() {
        return this.verifiable.isNotSupported();
    }

    public boolean isNotSupported() {
        return this.isNotObtainable() && this.isNotVerifiable();
    }

    public static CredentialSupport getCredentialSupport(SupportLevel obtainable, SupportLevel verifiable) {
        for (CredentialSupport current : CredentialSupport.values()) {
            if (!current.obtainable.equals((Object)obtainable) || !current.verifiable.equals((Object)verifiable)) continue;
            return current;
        }
        throw new IllegalArgumentException("Invalid combination of obtainable and verifiable.");
    }
}

