/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.spi.AuthenticatedRealmIdentity;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.auth.spi.SecurityRealm;
import org.wildfly.security.keystore.EnablingPasswordEntry;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final KeyStore keyStore;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public RealmIdentity createRealmIdentity(Principal principal) {
        if (!(principal instanceof NamePrincipal)) {
            throw ElytronMessages.log.invalidPrincipalType(NamePrincipal.class, principal == null ? null : principal.getClass());
        }
        return new KeyStoreRealmIdentity(principal);
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) {
        return credentialType.isAssignableFrom(SecretKey.class) || credentialType.isAssignableFrom(Password.class) || credentialType.isAssignableFrom(X500PrivateCredential.class) ? CredentialSupport.UNKNOWN : CredentialSupport.UNSUPPORTED;
    }

    private KeyStore.Entry getEntry(Principal principal) {
        try {
            return this.keyStore.getEntry(principal.getName(), null);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnrecoverableEntryException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final Principal principal;

        private KeyStoreRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.principal);
            if (entry == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isInstance(password)) {
                    return CredentialSupport.FULLY_SUPPORTED;
                }
                return CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof EnablingPasswordEntry) {
                EnablingPasswordEntry pwdEntry = (EnablingPasswordEntry)entry;
                if (credentialType.isInstance(pwdEntry.getPassword()) && pwdEntry.isEnabled()) {
                    return CredentialSupport.FULLY_SUPPORTED;
                }
                return CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                return credentialType.isInstance(privateKey) || credentialType.isInstance(certificate) || certificate instanceof X509Certificate && X500PrivateCredential.class.isAssignableFrom(credentialType) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                return credentialType.isInstance(((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate()) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                return credentialType.isInstance(((KeyStore.SecretKeyEntry)entry).getSecretKey()) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) {
            SecretKey secretKey;
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.principal);
            if (entry == null) {
                return null;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isInstance(password)) {
                    return credentialType.cast(password);
                }
            } else if (entry instanceof EnablingPasswordEntry) {
                EnablingPasswordEntry pwdEntry = (EnablingPasswordEntry)entry;
                Password password = pwdEntry.getPassword();
                if (credentialType.isInstance(password) && pwdEntry.isEnabled()) {
                    return credentialType.cast(password);
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                if (credentialType.isInstance(privateKey)) {
                    return credentialType.cast(privateKey);
                }
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
                if (credentialType.isAssignableFrom(X500PrivateCredential.class) && certificate instanceof X509Certificate) {
                    return credentialType.cast(new X500PrivateCredential((X509Certificate)certificate, privateKey, this.principal.getName()));
                }
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                if (credentialType.isInstance(certificate)) {
                    return credentialType.cast(certificate);
                }
            } else if (entry instanceof KeyStore.SecretKeyEntry && credentialType.isInstance(secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey())) {
                return credentialType.cast(secretKey);
            }
            return null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public AuthenticatedRealmIdentity getAuthenticatedRealmIdentity() {
            return new AuthenticatedRealmIdentity(){

                @Override
                public Principal getPrincipal() {
                    return KeyStoreRealmIdentity.this.principal;
                }

                @Override
                public void dispose() {
                }
            };
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.principal);
            if (entry == null) {
                return false;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credential instanceof char[]) {
                    try {
                        return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, (char[])credential);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
            if (entry instanceof EnablingPasswordEntry) {
                EnablingPasswordEntry pwdEntry = (EnablingPasswordEntry)entry;
                Password password = pwdEntry.getPassword();
                if (pwdEntry.isEnabled() && credential instanceof char[]) {
                    try {
                        return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, (char[])credential);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
            return false;
        }
    }
}

