/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.util.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String generalInvalidName = "ELY00009: Invalid name \"%s\"";
    private static final String iterationCountNotSpecified = "ELY03025: Iteration count not specified for password based encryption";
    private static final String saltNotSpecified = "ELY03026: Salt not specified for password based encryption";
    private static final String initialKeyNotSpecified = "ELY03027: Initial key not specified for password based encryption";
    private static final String securityProviderDoesnExist = "ELY03028: Security provider \"%s\" doesn't exist";
    private static final String noSuchKeyAlgorithm = "ELY03029: No such key algorithm \"%s\"";
    private static final String closed = "ELY03030: I/O operation failed: closed";
    private static final String wrongBase64InPBCompatibleMode = "ELY03032: Base64 string created with unsupported PicketBox version \"%s\"";
    private static final String mechanismNotSupported = "ELY04020: Mechanism \"%s\" not supported by transformation mapper";
    private static final String failedToEncode = "ELY08030: Failed to encode parameter specification";
    private static final String failedToDecode = "ELY08031: Failed to decode parameter specification";
    private static final String invalidParameterSpec = "ELY08032: Invalid parameter specification type (expected %s, got %s)";
    private static final String invalidFormat = "ELY08033: Invalid format given (expected %s, got %s)";
    private static final String algorithmParametersNotInitialized = "ELY08034: Algorithm parameters instance not initialized";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String generalInvalidName$str() {
        return generalInvalidName;
    }

    @Override
    public final IllegalArgumentException generalInvalidName(String str) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.generalInvalidName$str(), str));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String iterationCountNotSpecified$str() {
        return iterationCountNotSpecified;
    }

    @Override
    public final IllegalArgumentException iterationCountNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.iterationCountNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String saltNotSpecified$str() {
        return saltNotSpecified;
    }

    @Override
    public final IllegalArgumentException saltNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.saltNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String initialKeyNotSpecified$str() {
        return initialKeyNotSpecified;
    }

    @Override
    public final IllegalArgumentException initialKeyNotSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.initialKeyNotSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityProviderDoesnExist$str() {
        return securityProviderDoesnExist;
    }

    @Override
    public final IllegalArgumentException securityProviderDoesnExist(String providerName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.securityProviderDoesnExist$str(), providerName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchKeyAlgorithm$str() {
        return noSuchKeyAlgorithm;
    }

    @Override
    public final IllegalArgumentException noSuchKeyAlgorithm(String algorithmName, GeneralSecurityException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchKeyAlgorithm$str(), algorithmName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closed$str() {
        return closed;
    }

    @Override
    public final IOException closed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.closed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrongBase64InPBCompatibleMode$str() {
        return wrongBase64InPBCompatibleMode;
    }

    @Override
    public final IllegalArgumentException wrongBase64InPBCompatibleMode(String base64) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongBase64InPBCompatibleMode$str(), base64));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechanismNotSupported$str() {
        return mechanismNotSupported;
    }

    @Override
    public final IllegalArgumentException mechanismNotSupported(String mechanism) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechanismNotSupported$str(), mechanism));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToEncode$str() {
        return failedToEncode;
    }

    @Override
    public final InvalidParameterSpecException failedToEncode(Throwable cause) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.failedToEncode$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToDecode$str() {
        return failedToDecode;
    }

    @Override
    public final IOException failedToDecode(Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.failedToDecode$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpec$str() {
        return invalidParameterSpec;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpec(Class<?> expected, Class<?> actual) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpec$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFormat$str() {
        return invalidFormat;
    }

    @Override
    public final IOException invalidFormat(String expected, String actual) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidFormat$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String algorithmParametersNotInitialized$str() {
        return algorithmParametersNotInitialized;
    }

    @Override
    public final IllegalStateException algorithmParametersNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.algorithmParametersNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

