/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.security.GeneralSecurityException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;
import org.wildfly.security.util.PasswordUtil;

class MaskCommand
extends Command {
    public static final String MASK_COMMAND = "mask";
    static final String SALT_PARAM = "salt";
    static final String ITERATION_PARAM = "iteration";
    static final String SECRET_PARAM = "secret";
    static final String HELP_PARAM = "help";
    static final String DEBUG_PARAM = "debug";
    private final int defaultIterationCount = 10000;
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;

    MaskCommand() {
        Option salt = new Option("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdMaskSaltDesc());
        Option iteration = new Option("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdMaskIterationCountDesc());
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        Option x = new Option("x", SECRET_PARAM, true, ElytronToolMessages.msg.cmdMaskSecretDesc());
        Option d = new Option("d", DEBUG_PARAM, false, ElytronToolMessages.msg.cmdLineDebug());
        x.setArgName("to encrypt");
        this.options = new Options();
        this.options.addOption(x);
        this.options.addOption(h);
        this.options.addOption(salt);
        this.options.addOption(iteration);
        this.options.addOption(d);
    }

    @Override
    public void execute(String[] args) throws Exception {
        String secret;
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption(DEBUG_PARAM));
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        this.printDuplicatesWarning(this.cmdLine);
        String salt = this.cmdLine.getOptionValue(SALT_PARAM);
        if (salt == null) {
            salt = PasswordUtil.generateSecureRandomString((int)8);
            System.out.println(ElytronToolMessages.msg.invalidParameterGeneratedWillBeUsed(SALT_PARAM, salt));
        }
        String sIteration = this.cmdLine.getOptionValue(ITERATION_PARAM);
        int iterationCount = -1;
        if (sIteration != null && !sIteration.isEmpty()) {
            try {
                iterationCount = Integer.parseInt(sIteration);
                if (iterationCount < 1) {
                    System.out.println(ElytronToolMessages.msg.invalidParameterMustBeIntBetween(ITERATION_PARAM, 1, Integer.MAX_VALUE));
                }
            }
            catch (NumberFormatException e) {
                System.out.println(ElytronToolMessages.msg.invalidParameterMustBeIntBetween(ITERATION_PARAM, 1, Integer.MAX_VALUE));
            }
        }
        if (iterationCount < 1) {
            System.out.println(ElytronToolMessages.msg.invalidParameterDefaultWillBeUsed(ITERATION_PARAM, Integer.toString(10000)));
            iterationCount = 10000;
        }
        if ((secret = this.cmdLine.getOptionValue(SECRET_PARAM)) == null && (secret = this.prompt(false, ElytronToolMessages.msg.maskSecretPrompt(), true, ElytronToolMessages.msg.maskSecretPromptConfirm())) == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.secretNotSpecified();
        }
        String masked = MaskCommand.computeMasked(secret, salt, iterationCount);
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        System.out.println(masked);
    }

    static String computeMasked(String secret, String salt, int iteration) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).encryptMode().build();
        return "MASK-" + encryptUtil.encryptAndEncode(secret.toCharArray()) + ";" + salt + ";" + String.valueOf(iteration);
    }

    static char[] decryptMasked(String maskedPassword) throws GeneralSecurityException {
        int maskLength = "MASK-".length();
        if (maskedPassword == null || maskedPassword.length() <= maskLength) {
            throw ElytronToolMessages.msg.wrongMaskedPasswordFormat();
        }
        String[] parsed = maskedPassword.substring(maskLength).split(";");
        if (parsed.length != 3) {
            throw ElytronToolMessages.msg.wrongMaskedPasswordFormat();
        }
        String encoded = parsed[0];
        String salt = parsed[1];
        int iteration = Integer.parseInt(parsed[2]);
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).decryptMode().build();
        return encryptUtil.decodeAndDecrypt(encoded);
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp(this.getToolCommand(), MASK_COMMAND), ElytronToolMessages.msg.cmdMaskHelpHeader().concat(ElytronToolMessages.msg.cmdLineActionsHelpHeader()), this.options, "", true);
    }
}

