/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.credential._private.ElytronMessages;

public abstract class AliasFilter
implements Predicate<String> {
    protected final Predicate<String> previous;
    public static final AliasFilter ALL = new AliasFilter(null){

        @Override
        public boolean test(String t) {
            return true;
        }
    };
    public static final AliasFilter NONE = new AliasFilter(null){

        @Override
        public boolean test(String t) {
            return false;
        }
    };

    private AliasFilter(Predicate<String> previous) {
        this.previous = previous;
    }

    public AliasFilter add(final String alias) {
        return new AliasFilter(this){

            @Override
            public boolean test(String t) {
                if (alias.equals(t)) {
                    return true;
                }
                return this.previous.test(t);
            }
        };
    }

    public AliasFilter remove(final String alias) {
        return new AliasFilter(this){

            @Override
            public boolean test(String t) {
                if (alias.equals(t)) {
                    return false;
                }
                return this.previous.test(t);
            }
        };
    }

    @Override
    public abstract boolean test(String var1);

    public static AliasFilter fromString(String filterString) {
        CodePointIterator i = CodePointIterator.ofString(Assert.checkNotNullParam("filterString", filterString));
        if (i.hasNext()) {
            String firstWord = i.delimitedBy(44, 58).drainToString();
            if (i.hasNext()) {
                AliasFilter current;
                switch (i.next()) {
                    case 44: {
                        current = NONE.add(firstWord);
                        while (i.hasNext()) {
                            current = current.add(i.delimitedBy(44).drainToString());
                            if (!i.hasNext()) continue;
                            i.next();
                        }
                        break;
                    }
                    case 58: {
                        switch (firstWord) {
                            case "ALL": {
                                current = ALL;
                                break;
                            }
                            case "NONE": {
                                current = NONE;
                                break;
                            }
                            default: {
                                throw ElytronMessages.log.invalidFirstWord(firstWord);
                            }
                        }
                        while (i.hasNext()) {
                            Function<String, AliasFilter> function;
                            switch (i.next()) {
                                case 43: {
                                    function = current::add;
                                    break;
                                }
                                case 45: {
                                    function = current::remove;
                                    break;
                                }
                                default: {
                                    throw ElytronMessages.log.missingPlusMinusAt(i.getIndex());
                                }
                            }
                            if (!i.hasNext()) continue;
                            current = function.apply(i.delimitedBy(58).drainToString());
                            if (!i.hasNext()) continue;
                            i.next();
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return current;
            }
            switch (firstWord) {
                case "ALL": {
                    return ALL;
                }
                case "NONE": {
                    return NONE;
                }
            }
            return NONE.add(firstWord);
        }
        throw ElytronMessages.log.emptyFilter();
    }
}

