/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.permission.PermissionVerifierPermissionCollection;

@FunctionalInterface
public interface PermissionVerifier {
    public static final PermissionVerifier NONE = permission -> false;
    public static final PermissionVerifier ALL = permission -> true;

    public boolean implies(Permission var1);

    default public PermissionVerifier and(PermissionVerifier other) {
        Assert.checkNotNullParam("other", other);
        return permission -> this.implies(permission) && other.implies(permission);
    }

    default public PermissionVerifier or(PermissionVerifier other) {
        Assert.checkNotNullParam("other", other);
        return permission -> this.implies(permission) || other.implies(permission);
    }

    default public PermissionVerifier xor(PermissionVerifier other) {
        Assert.checkNotNullParam("other", other);
        return permission -> this.implies(permission) ^ other.implies(permission);
    }

    default public PermissionVerifier not() {
        return permission -> !this.implies(permission);
    }

    default public PermissionVerifier unless(PermissionVerifier other) {
        Assert.checkNotNullParam("other", other);
        return permission -> this.implies(permission) && !other.implies(permission);
    }

    default public void checkPermission(Permission permission) throws SecurityException {
        Assert.checkNotNullParam("permission", permission);
        if (!this.implies(permission)) {
            throw ElytronMessages.log.permissionCheckFailed(permission, this);
        }
    }

    public static PermissionVerifier from(Permission permission) {
        Assert.checkNotNullParam("permission", permission);
        return permission instanceof PermissionVerifier ? (PermissionVerifier)((Object)permission) : permission::implies;
    }

    public static PermissionVerifier from(PermissionCollection permissionCollection) {
        Assert.checkNotNullParam("permissionCollection", permissionCollection);
        return permissionCollection instanceof PermissionVerifier ? (PermissionVerifier)((Object)permissionCollection) : permissionCollection::implies;
    }

    public static PermissionVerifier from(ProtectionDomain protectionDomain) {
        Assert.checkNotNullParam("protectionDomain", protectionDomain);
        return protectionDomain instanceof PermissionVerifier ? (PermissionVerifier)((Object)protectionDomain) : protectionDomain::implies;
    }

    public static PermissionVerifier from(Policy policy, ProtectionDomain protectionDomain) {
        Assert.checkNotNullParam("policy", policy);
        Assert.checkNotNullParam("protectionDomain", protectionDomain);
        return permission -> policy.implies(protectionDomain, permission);
    }

    default public PermissionCollection toPermissionCollection() {
        if (this instanceof PermissionCollection) {
            return (PermissionCollection)((Object)this);
        }
        return new PermissionVerifierPermissionCollection(this);
    }
}

