/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.MechanismUtil;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.x500.X500;

public class ClientCertAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    ClientCertAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "CLIENT_CERT";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        SSLSession sslSession = request.getSSLSession();
        if (sslSession == null) {
            ElytronMessages.log.trace("CLIENT-CERT no SSL session");
            request.noAuthenticationInProgress();
            return;
        }
        if (this.attemptReAuthentication(request)) {
            ElytronMessages.log.trace("ClientCertAuthenticationMechanism: re-authentication succeed");
            return;
        }
        if (this.attemptAuthentication(request)) {
            return;
        }
        ElytronMessages.log.trace("ClientCertAuthenticationMechanism: both, re-authentication and authentication, failed");
        this.fail(request);
    }

    private boolean attemptAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        Object[] peerCertificates = request.getPeerCertificates();
        if (peerCertificates == null) {
            ElytronMessages.log.trace("CLIENT-CERT Peer Unverified");
            request.noAuthenticationInProgress();
            return true;
        }
        Object[] x509Certificates = X500.asX509CertificateArray(peerCertificates);
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence((X509Certificate[])x509Certificates);
        ElytronMessages.log.tracef("Using ClientCertAuthenticationMechanism to authenticate the following certificates: [%s]", x509Certificates);
        EvidenceVerifyCallback callback = new EvidenceVerifyCallback(evidence);
        try {
            MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, callback);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("CLIENT_CERT", e).toHttpAuthenticationException();
        }
        boolean verified = callback.isVerified();
        ElytronMessages.log.tracef("X509PeerCertificateChainEvidence was verified by EvidenceVerifyCallback handler: %b", (Object)verified);
        if (verified) {
            CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback((Principal)evidence.getPrincipal(), this.createIdentityCache(request), true);
            try {
                MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, authorizeCallback);
            }
            catch (AuthenticationMechanismException e) {
                throw e.toHttpAuthenticationException();
            }
            catch (UnsupportedCallbackException e) {
                throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("CLIENT_CERT", e).toHttpAuthenticationException();
            }
            boolean authorized = authorizeCallback.isAuthorized();
            ElytronMessages.log.tracef("X509PeerCertificateChainEvidence was authorized by CachedIdentityAuthorizeCallback(%s) handler: %b", (Object)evidence.getPrincipal(), (Object)authorized);
            if (authorized && this.succeed(request)) {
                ElytronMessages.log.trace("ClientCertAuthenticationMechanism: authentication succeed");
                return true;
            }
        }
        return false;
    }

    private boolean succeed(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, AuthenticationCompleteCallback.SUCCEEDED);
            request.authenticationComplete();
            return true;
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            return false;
        }
    }

    private void fail(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, AuthenticationCompleteCallback.FAILED);
            request.authenticationFailed(ElytronMessages.log.authenticationFailed("CLIENT_CERT"));
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            // empty catch block
        }
    }

    private boolean attemptReAuthentication(HttpServerRequest request) throws HttpAuthenticationException {
        CachedIdentityAuthorizeCallback authorizeCallback = new CachedIdentityAuthorizeCallback(this.createIdentityCache(request), true);
        try {
            MechanismUtil.handleCallbacks("CLIENT_CERT", this.callbackHandler, authorizeCallback);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason("CLIENT_CERT", e).toHttpAuthenticationException();
        }
        boolean authorized = authorizeCallback.isAuthorized();
        ElytronMessages.log.tracef("Identity was authorized by CachedIdentityAuthorizeCallback handler: %b", (Object)authorized);
        if (authorized) {
            return this.succeed(request);
        }
        return false;
    }

    private Function<SecurityDomain, IdentityCache> createIdentityCache(HttpServerRequest request) {
        final SSLSession sslSession = request.getSSLSession();
        if (sslSession == null) {
            return null;
        }
        return securityDomain -> new IdentityCache((SecurityDomain)securityDomain){
            final Map identities;
            final /* synthetic */ SecurityDomain val$securityDomain;
            {
                this.val$securityDomain = securityDomain;
                this.identities = SSLUtils.computeIfAbsent(sslSession, "org.wildfly.elytron.identity-cache", key -> new ConcurrentHashMap());
            }

            @Override
            public void put(SecurityIdentity identity) {
                this.identities.putIfAbsent(this.val$securityDomain, new CachedIdentity(ClientCertAuthenticationMechanism.this.getMechanismName(), identity));
            }

            @Override
            public CachedIdentity get() {
                return (CachedIdentity)this.identities.get(this.val$securityDomain);
            }

            @Override
            public CachedIdentity remove() {
                return (CachedIdentity)this.identities.remove(this.val$securityDomain);
            }
        };
    }
}

