/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.CredentialStoreCommand;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.MaskCommand;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public class VaultCommand
extends Command {
    static final String defaultKeyStoreType = "JCEKS";
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;
    public static final String VAULT_COMMAND = "vault";
    public static final String STORE_LOCATION_PARAM = "location";
    public static final String PRINT_SUMMARY_PARAM = "summary";
    public static final String FAIL_IF_EXIST_PARAM = "fail-if-exist";
    public static String BULK_CONVERT_PARAM = "bulk-convert";
    public static final String KEYSTORE_PARAM = "keystore";
    public static final String KEYSTORE_PASSWORD_PARAM = "keystore-password";
    public static final String ENC_DIR_PARAM = "enc-dir";
    public static final String SALT_PARAM = "salt";
    public static final String ITERATION_PARAM = "iteration";
    public static final String ALIAS_PARAM = "alias";
    public static final String HELP_PARAM = "help";

    public VaultCommand() {
        this.options = new Options();
        Option o = new Option("k", KEYSTORE_PARAM, true, ElytronToolMessages.msg.cmdLineVaultKeyStoreURL());
        o.setArgName(KEYSTORE_PARAM);
        this.options.addOption(o);
        o = new Option("p", KEYSTORE_PASSWORD_PARAM, true, ElytronToolMessages.msg.cmdLineVaultKeyStorePassword());
        o.setArgName("pwd");
        this.options.addOption(o);
        o = new Option("e", ENC_DIR_PARAM, true, ElytronToolMessages.msg.cmdLineVaultEncryptionDirectory());
        o.setArgName("dir");
        this.options.addOption(o);
        o = new Option("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdVaultLineSalt());
        o.setArgName(SALT_PARAM);
        this.options.addOption(o);
        o = new Option("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdLineVaultIterationCount());
        this.options.addOption(o);
        o = new Option("v", ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineVaultKeyStoreAlias());
        this.options.addOption(o);
        o = new Option("l", STORE_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLineVaultCSLocationDesc());
        o.setArgName("loc");
        this.options.addOption(o);
        o = new Option("u", "properties", true, ElytronToolMessages.msg.cmdLineVaultCSParametersDesc());
        o.setValueSeparator(';');
        o.setOptionalArg(true);
        this.options.addOption(o);
        this.options.addOption("f", PRINT_SUMMARY_PARAM, false, ElytronToolMessages.msg.cmdLineVaultPrintSummary());
        Option b = new Option("b", BULK_CONVERT_PARAM, true, ElytronToolMessages.msg.cliCommandBulkVaultCredentialStoreConversion());
        b.setArgName("description file");
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        this.options.addOption(b);
        this.options.addOption(h);
    }

    @Override
    public void execute(String[] args) throws Exception {
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        boolean printSummary = this.cmdLine.hasOption(PRINT_SUMMARY_PARAM);
        String bulkConversionDescriptor = this.cmdLine.getOptionValue(BULK_CONVERT_PARAM);
        if (bulkConversionDescriptor != null && !bulkConversionDescriptor.isEmpty()) {
            this.checkInvalidOptions(KEYSTORE_PARAM, KEYSTORE_PASSWORD_PARAM, ENC_DIR_PARAM, SALT_PARAM, ITERATION_PARAM, ALIAS_PARAM, STORE_LOCATION_PARAM);
            List<Descriptor> descriptors = this.parseDescriptorFile(bulkConversionDescriptor);
            for (Descriptor d : descriptors) {
                try {
                    this.convert(d.keyStoreURL, d.vaultPassword, d.encryptionDirectory, d.salt, d.iterationCount, d.secretKeyAlias, d.outputFile, d.implProps);
                    System.out.println(ElytronToolMessages.msg.vaultConvertedToCS(d.encryptionDirectory, d.keyStoreURL, d.outputFile));
                }
                catch (Throwable e) {
                    throw ElytronToolMessages.msg.bulkConversionProblem(d.encryptionDirectory, d.keyStoreURL, e);
                }
            }
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            String keystoreURL = this.cmdLine.getOptionValue(KEYSTORE_PARAM, "vault.keystore");
            String keystorePassword = this.cmdLine.getOptionValue(KEYSTORE_PASSWORD_PARAM, "");
            String encryptionDirectory = this.cmdLine.getOptionValue(ENC_DIR_PARAM, VAULT_COMMAND);
            String salt = this.cmdLine.getOptionValue(SALT_PARAM, "12345678");
            int iterationCount = Integer.parseInt(this.cmdLine.getOptionValue(ITERATION_PARAM, "23"));
            String vaultSecretKeyAlias = this.cmdLine.getOptionValue(ALIAS_PARAM, VAULT_COMMAND);
            String location = this.cmdLine.getOptionValue(STORE_LOCATION_PARAM);
            if (location == null || location.isEmpty()) {
                location = this.convertedStoreName(encryptionDirectory);
            }
            Map<String, String> implProps = CredentialStoreCommand.parseCredentialStoreProperties(this.cmdLine.getOptionValue("properties"));
            this.convert(keystoreURL, keystorePassword, encryptionDirectory, salt, iterationCount, vaultSecretKeyAlias, location, implProps);
            System.out.println(ElytronToolMessages.msg.vaultConvertedToCS(encryptionDirectory, keystoreURL, location));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            if (printSummary) {
                String props;
                StringBuilder com = new StringBuilder();
                com.append(ElytronToolMessages.msg.conversionSuccessful());
                com.append(ElytronToolMessages.msg.cliCommandToNewCredentialStore());
                com.append("/subsystem=elytron/credential-store=cs:add(");
                com.append("relative-to=jboss.server.data.dir,");
                if (location != null) {
                    com.append("location=\"" + location + "\",");
                }
                if (!(props = CredentialStoreCommand.formatPropertiesForCli(implProps)).isEmpty()) {
                    com.append(props);
                    com.append(",");
                }
                com.append("credential-reference={");
                com.append("clear-text=\"");
                if (keystorePassword != null && !keystorePassword.startsWith("MASK-") && salt != null && iterationCount > -1) {
                    com.append(MaskCommand.computeMasked(keystorePassword, salt, iterationCount));
                } else if (keystorePassword != null) {
                    com.append(keystorePassword);
                }
                com.append("\"})");
                System.out.println(ElytronToolMessages.msg.vaultConversionSummary(com.toString()));
            }
        }
    }

    private void checkInvalidOptions(String ... invalidOptions) throws Exception {
        for (String opt : invalidOptions) {
            if (!this.cmdLine.hasOption(opt)) continue;
            throw ElytronToolMessages.msg.bulkConversionInvalidOption(opt);
        }
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp("wildfly-elytron-tool.jar", VAULT_COMMAND), ElytronToolMessages.msg.cmdVaultHelpHeader(), this.options, "", true);
    }

    private String convertedStoreName(String encryptionDirectory) {
        return encryptionDirectory + (encryptionDirectory.isEmpty() ? "" : File.separator) + "converted-vault.cr-store";
    }

    private void convert(String keyStoreURL, String vaultPassword, String encryptionDirectory, String salt, int iterationCount, String secretKeyAlias, String outputFile, Map<String, String> csAttributes) throws Exception {
        HashMap<String, String> vaultInitialOptions = new HashMap<String, String>();
        vaultInitialOptions.put(STORE_LOCATION_PARAM, encryptionDirectory);
        vaultInitialOptions.put("create", Boolean.FALSE.toString());
        CredentialStore vaultCredentialStore = CredentialStore.getInstance("VaultCredentialStore");
        vaultCredentialStore.initialize(vaultInitialOptions, this.getVaultCredentialStoreProtectionParameter(keyStoreURL, vaultPassword, salt, iterationCount, secretKeyAlias));
        HashMap<String, String> convertedOptions = new HashMap<String, String>();
        convertedOptions.put(STORE_LOCATION_PARAM, outputFile);
        convertedOptions.put("modifiable", Boolean.TRUE.toString());
        convertedOptions.put("create", Boolean.TRUE.toString());
        if (csAttributes != null) {
            convertedOptions.putAll(csAttributes);
        }
        convertedOptions.put("create", Boolean.TRUE.toString());
        convertedOptions.put("keyStoreType", defaultKeyStoreType);
        CredentialStore convertedCredentialStore = CredentialStore.getInstance(KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
        convertedCredentialStore.initialize(convertedOptions, this.getCredentialStoreProtectionParameter(vaultPassword, salt, iterationCount));
        for (String alias : vaultCredentialStore.getAliases()) {
            PasswordCredential credential = vaultCredentialStore.retrieve(alias, PasswordCredential.class);
            convertedCredentialStore.store(alias, credential);
        }
        convertedCredentialStore.flush();
    }

    private List<Descriptor> parseDescriptorFile(String descriptorFileLocation) throws IOException {
        try (BufferedReader descriptorFile = new BufferedReader(new FileReader(new File(descriptorFileLocation)));){
            String line;
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            int vaults = 0;
            int lineNumber = 0;
            Descriptor descriptor = new Descriptor();
            while ((line = descriptorFile.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int colon = line.indexOf(58);
                if (colon == -1) {
                    throw ElytronToolMessages.msg.descriptorParseMissingColon(descriptorFileLocation, Integer.toString(lineNumber));
                }
                String attribute = line.substring(0, colon).trim();
                String value = line.substring(colon + 1).trim();
                if (attribute.equals(KEYSTORE_PARAM)) {
                    if (vaults > 0) {
                        parsedDescriptors.add(descriptor);
                        descriptor = new Descriptor();
                    }
                    ++vaults;
                    descriptor.keyStoreURL = value;
                    continue;
                }
                if (attribute.equals(KEYSTORE_PASSWORD_PARAM)) {
                    descriptor.vaultPassword = value;
                    continue;
                }
                if (attribute.equals(ENC_DIR_PARAM)) {
                    descriptor.encryptionDirectory = value;
                    continue;
                }
                if (attribute.equals(SALT_PARAM)) {
                    descriptor.salt = value;
                    continue;
                }
                if (attribute.equals(ITERATION_PARAM)) {
                    descriptor.iterationCount = Integer.parseInt(value);
                    continue;
                }
                if (attribute.equals(ALIAS_PARAM)) {
                    descriptor.secretKeyAlias = value;
                    continue;
                }
                if (attribute.equals(STORE_LOCATION_PARAM)) {
                    descriptor.outputFile = value;
                    continue;
                }
                if (attribute.equals("properties")) {
                    descriptor.implProps = CredentialStoreCommand.parseCredentialStoreProperties(value);
                    continue;
                }
                throw ElytronToolMessages.msg.unrecognizedDescriptorAttribute(Integer.toString(lineNumber));
            }
            if (descriptor.keyStoreURL != null) {
                parsedDescriptors.add(descriptor);
            }
            ArrayList<Descriptor> arrayList = parsedDescriptors;
            return arrayList;
        }
    }

    private CredentialStore.CredentialSourceProtectionParameter getCredentialStoreProtectionParameter(String vaultPassword, String salt, int iterationCount) throws GeneralSecurityException {
        char[] password = vaultPassword.startsWith("MASK-") ? this.decodeMaskedPassword(vaultPassword.substring("MASK-".length()), salt, iterationCount) : vaultPassword.toCharArray();
        return new CredentialStore.CredentialSourceProtectionParameter(IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", password))));
    }

    private CredentialStore.CredentialSourceProtectionParameter getVaultCredentialStoreProtectionParameter(String keyStoreURL, String vaultPassword, String salt, int iterationCount, String secretKeyAlias) throws GeneralSecurityException, IOException {
        char[] password = vaultPassword.startsWith("MASK-") ? this.decodeMaskedPassword(vaultPassword.substring("MASK-".length()), salt, iterationCount) : vaultPassword.toCharArray();
        KeyStore keyStore = KeyStore.getInstance(defaultKeyStoreType);
        try (FileInputStream in = new FileInputStream(new File(keyStoreURL));){
            keyStore.load(in, password);
        }
        final KeyStore.Entry entry = keyStore.getEntry(secretKeyAlias, new KeyStore.PasswordProtection(password));
        if (entry instanceof KeyStore.SecretKeyEntry) {
            return new CredentialStore.CredentialSourceProtectionParameter(new CredentialSource(){

                @Override
                public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                    return null;
                }

                @Override
                public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                    SecretKeyCredential credential = new SecretKeyCredential(((KeyStore.SecretKeyEntry)entry).getSecretKey());
                    return credential.castAs(credentialType, algorithmName, parameterSpec);
                }
            });
        }
        throw ElytronToolMessages.msg.cannotLocateAdminKey(secretKeyAlias);
    }

    private char[] decodeMaskedPassword(String password, String salt, int iterationCount) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil decryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iterationCount).decryptMode().build();
        return decryptUtil.decodeAndDecrypt(password);
    }

    private static final class Descriptor {
        String keyStoreURL;
        String vaultPassword;
        String encryptionDirectory;
        String salt;
        int iterationCount;
        String secretKeyAlias;
        Map<String, String> implProps;
        String outputFile;

        private Descriptor() {
        }
    }
}

