/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.wildfly.security.tool.ElytronToolMessages;

public abstract class Command {
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static int INPUT_DATA_NOT_CONFIRMED = 3;
    private int status = 255;
    public static int WIDTH = 1024;

    public abstract void execute(String[] var1) throws Exception;

    public void help() {
    }

    public boolean isAlias(String alias) {
        return this.aliases().contains(alias);
    }

    protected Set<String> aliases() {
        return Collections.emptySet();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public static boolean isWindows() {
        String opsys = System.getProperty("os.name").toLowerCase();
        return opsys.indexOf("win") >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String prompt(boolean echo, String prompt, boolean confirm, String confirmPrompt) throws Exception {
        Console console = System.console();
        if (echo || console == null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in));){
                String first;
                String string = first = console != null ? console.readLine(prompt, new Object[0]) : in.readLine();
                if (first != null && confirm) {
                    String second;
                    String string2 = second = console != null ? console.readLine(confirmPrompt, new Object[0]) : in.readLine();
                    if (first.equals(second)) {
                        String string3 = first;
                        return string3;
                    }
                    System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
                    System.exit(INPUT_DATA_NOT_CONFIRMED);
                    String string4 = null;
                    return string4;
                }
                String string5 = first;
                return string5;
            }
            catch (IOException e) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw new Exception(e);
            }
        }
        char[] inVisible = console.readPassword(prompt != null ? prompt : "Password:", new Object[0]);
        if (inVisible != null && confirm) {
            char[] inVisible2 = console.readPassword(confirmPrompt != null ? confirmPrompt : "Confirm password:", new Object[0]);
            if (Arrays.equals(inVisible, inVisible2)) {
                return new String(inVisible);
            }
            System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
            System.exit(INPUT_DATA_NOT_CONFIRMED);
            return null;
        }
        if (inVisible == null) return null;
        return new String(inVisible);
    }
}

