/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;

public final class SaslMechanismInformation {
    private static final Set<String> MD5_MECHS = SaslMechanismInformation.nSet("CRAM-MD5", "DIGEST-MD5");
    private static final Set<String> SHA_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA", "SCRAM-SHA-1", "SCRAM-SHA-1-PLUS");
    private static final Set<String> SHA_256_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-256", "SCRAM-SHA-256", "SCRAM-SHA-256-PLUS");
    private static final Set<String> SHA_384_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-384", "SCRAM-SHA-384", "SCRAM-SHA-384-PLUS");
    private static final Set<String> SHA_512_MECHS = SaslMechanismInformation.nSet("DIGEST-SHA-512", "SCRAM-SHA-512", "SCRAM-SHA-512-PLUS");
    private static final Set<String> MUTUAL_MECHS = SaslMechanismInformation.nSet("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC");
    private static final Set<String> RECOMMENDED_MECHS = SaslMechanismInformation.nSet("9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-U-RSA-SHA1-ENC", "ANONYMOUS", "EAP-AES128", "EAP-AES128-PLUS", "EXTERNAL", "OAUTH10A", "OAUTHBEARER", "OPENID20", "OTP", "SAML20", "SECURID");
    public static final Predicate<String> HASH_MD5 = MD5_MECHS::contains;
    public static final Predicate<String> HASH_SHA = SHA_MECHS::contains;
    public static final Predicate<String> HASH_SHA_256 = SHA_256_MECHS::contains;
    public static final Predicate<String> HASH_SHA_384 = SHA_384_MECHS::contains;
    public static final Predicate<String> HASH_SHA_512 = SHA_512_MECHS::contains;
    public static final Predicate<String> GS2 = name -> name.startsWith("GS2-");
    public static final Predicate<String> SCRAM = name -> name.startsWith("SCRAM-");
    public static final Predicate<String> DIGEST = name -> name.startsWith("DIGEST-");
    public static final Predicate<String> IEC_ISO_9798 = name -> name.startsWith("9798-");
    public static final Predicate<String> EAP = name -> name.startsWith("EAP-");
    public static final Predicate<String> MUTUAL = ((Predicate<String>)MUTUAL_MECHS::contains).or(SCRAM).or(GS2);
    public static final Predicate<String> BINDING = name -> name.endsWith("-PLUS");
    public static final Predicate<String> RECOMMENDED = ((Predicate<String>)RECOMMENDED_MECHS::contains).or(GS2).or(SCRAM).and(HASH_MD5.negate());
    static final Set<Class<? extends Password>> JUST_ONE_WAY = Collections.singleton(OneTimePassword.class);
    static final Set<Class<? extends Password>> JUST_TWO_WAY = Collections.singleton(TwoWayPassword.class);
    static final Set<Class<? extends Password>> ONE_WAY_AND_TWO_WAY = SaslMechanismInformation.nSet(OneWayPassword.class, TwoWayPassword.class);
    static final Set<Class<? extends Password>> DIGEST_AND_TWO_WAY = SaslMechanismInformation.nSet(DigestPassword.class, TwoWayPassword.class);
    static final Set<Class<? extends Password>> SCRAM_AND_TWO_WAY = SaslMechanismInformation.nSet(ScramDigestPassword.class, TwoWayPassword.class);
    static final Set<Class<? extends Credential>> JUST_X509 = Collections.singleton(X509CertificateChainPrivateCredential.class);
    static final Set<Class<? extends Credential>> X_509_PUBLIC_OR_PRIVATE = SaslMechanismInformation.nSet(X509CertificateChainPublicCredential.class, X509CertificateChainPrivateCredential.class);
    static final Set<Class<? extends Credential>> JUST_PASSWORD = Collections.singleton(PasswordCredential.class);
    static final Set<Class<? extends Credential>> JUST_GSS = Collections.singleton(GSSKerberosCredential.class);
    static final Set<Class<? extends Credential>> JUST_BEARER_TOKEN = Collections.singleton(BearerTokenCredential.class);
    static final Set<Class<? extends Evidence>> JUST_PASSWORD_EVIDENCE = Collections.singleton(PasswordGuessEvidence.class);
    static final Set<Class<? extends Evidence>> JUST_BEARER_TOKEN_EVIDENCE = Collections.singleton(BearerTokenEvidence.class);
    static final Set<String> DIGEST_MD5_AND_PLAIN = SaslMechanismInformation.nSet("digest-md5", "clear");
    static final Set<String> DIGEST_SHA_AND_PLAIN = SaslMechanismInformation.nSet("digest-sha", "clear");
    static final Set<String> DIGEST_SHA_256_AND_PLAIN = SaslMechanismInformation.nSet("digest-sha-256", "clear");
    static final Set<String> DIGEST_SHA_384_AND_PLAIN = SaslMechanismInformation.nSet("digest-sha-384", "clear");
    static final Set<String> DIGEST_SHA_512_AND_PLAIN = SaslMechanismInformation.nSet("digest-sha-512", "clear");
    static final Set<String> SCRAM_SHA_1_AND_PLAIN = SaslMechanismInformation.nSet("scram-sha-1", "clear");
    static final Set<String> SCRAM_SHA_256_AND_PLAIN = SaslMechanismInformation.nSet("scram-sha-256", "clear");
    static final Set<String> SCRAM_SHA_384_AND_PLAIN = SaslMechanismInformation.nSet("scram-sha-384", "clear");
    static final Set<String> SCRAM_SHA_512_AND_PLAIN = SaslMechanismInformation.nSet("scram-sha-512", "clear");
    static final Set<String> JUST_PLAIN = Collections.singleton("clear");
    static final Set<String> JUST_DSA = Collections.singleton("DSA");
    static final Set<String> JUST_EC = Collections.singleton("EC");
    static final Set<String> JUST_RSA = Collections.singleton("RSA");
    static final Set<String> ALL_ALGORITHMS = Collections.singleton("*");

    public static Set<Class<? extends Credential>> getSupportedClientCredentialTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": 
            case "OTP": 
            case "CRAM-MD5": 
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": 
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return JUST_PASSWORD;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return X_509_PUBLIC_OR_PRIVATE;
            }
            case "OAUTHBEARER": {
                return JUST_BEARER_TOKEN;
            }
            case "GSSAPI": {
                return JUST_GSS;
            }
        }
        if (GS2.test(mechName)) {
            return JUST_GSS;
        }
        return Collections.emptySet();
    }

    public static Set<Class<? extends Password>> getSupportedClientPasswordTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": 
            case "OTP": 
            case "CRAM-MD5": {
                return JUST_TWO_WAY;
            }
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": {
                return DIGEST_AND_TWO_WAY;
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return SCRAM_AND_TWO_WAY;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static Set<Class<? extends Credential>> getSupportedServerCredentialTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": 
            case "OTP": 
            case "CRAM-MD5": 
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": 
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return JUST_PASSWORD;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return JUST_X509;
            }
            case "GSSAPI": {
                return JUST_GSS;
            }
        }
        if (GS2.test(mechName)) {
            return JUST_GSS;
        }
        return Collections.emptySet();
    }

    public static Set<Class<? extends Password>> getSupportedServerPasswordTypes(String mechName) {
        switch (mechName) {
            case "EXTERNAL": 
            case "ANONYMOUS": {
                return Collections.emptySet();
            }
            case "PLAIN": {
                return ONE_WAY_AND_TWO_WAY;
            }
            case "OTP": {
                return JUST_ONE_WAY;
            }
            case "CRAM-MD5": {
                return JUST_TWO_WAY;
            }
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": {
                return DIGEST_AND_TWO_WAY;
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return SCRAM_AND_TWO_WAY;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getSupportedClientCredentialAlgorithms(String mechName, Class<? extends Credential> credentialType) {
        switch (mechName) {
            case "CRAM-MD5": 
            case "PLAIN": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? JUST_PLAIN : Collections.emptySet();
            }
            case "DIGEST-MD5": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_MD5_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-256": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_256_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-384": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_384_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-512": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_512_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_1_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_256_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_384_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_512_AND_PLAIN : Collections.emptySet();
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": {
                return credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class) ? JUST_DSA : Collections.emptySet();
            }
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": {
                return credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class) ? JUST_EC : Collections.emptySet();
            }
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class) ? JUST_RSA : Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getSupportedServerCredentialAlgorithms(String mechName, Class<? extends Credential> credentialType) {
        switch (mechName) {
            case "PLAIN": {
                return ALL_ALGORITHMS;
            }
            case "DIGEST-MD5": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_MD5_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-256": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_256_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-384": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_384_AND_PLAIN : Collections.emptySet();
            }
            case "DIGEST-SHA-512": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? DIGEST_SHA_512_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_1_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_256_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_384_AND_PLAIN : Collections.emptySet();
            }
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return credentialType.isAssignableFrom(PasswordCredential.class) ? SCRAM_SHA_512_AND_PLAIN : Collections.emptySet();
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static Set<Class<? extends Evidence>> getSupportedServerEvidenceTypes(String mechName) {
        switch (mechName) {
            case "OTP": 
            case "CRAM-MD5": 
            case "PLAIN": 
            case "DIGEST-MD5": 
            case "DIGEST-SHA": 
            case "DIGEST-SHA-256": 
            case "DIGEST-SHA-384": 
            case "DIGEST-SHA-512": 
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-384": 
            case "SCRAM-SHA-384-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return JUST_PASSWORD_EVIDENCE;
            }
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
            case "OAUTHBEARER": {
                return JUST_BEARER_TOKEN_EVIDENCE;
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getSupportedServerEvidenceAlgorithms(String mechName, Class<? extends AlgorithmEvidence> evidenceType) {
        switch (mechName) {
            case "9798-M-DSA-SHA1": 
            case "9798-U-DSA-SHA1": 
            case "9798-M-ECDSA-SHA1": 
            case "9798-U-ECDSA-SHA1": 
            case "9798-M-RSA-SHA1-ENC": 
            case "9798-U-RSA-SHA1-ENC": {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    public static boolean needsServerCredentials(String mechName) {
        switch (mechName) {
            case "ANONYMOUS": 
            case "EXTERNAL": 
            case "JBOSS-LOCAL-USER": 
            case "GSSAPI": 
            case "GS2-KRB5": 
            case "GS2-KRB5-PLUS": {
                return false;
            }
        }
        return true;
    }

    public static boolean doesNotUsePrincipal(String mechName) {
        switch (mechName) {
            case "ANONYMOUS": 
            case "GSSAPI": 
            case "OAUTHBEARER": {
                return true;
            }
        }
        return false;
    }

    public static boolean doesNotRequireClientCredentials(String mechName) {
        switch (mechName) {
            case "JBOSS-LOCAL-USER": 
            case "ANONYMOUS": 
            case "GSSAPI": 
            case "EXTERNAL": {
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    private static <T> Set<T> nSet(T ... values) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(Arrays.asList(values)));
    }

    public static final class Names {
        public static final String CRAM_MD5 = "CRAM-MD5";
        public static final String DIGEST_MD5 = "DIGEST-MD5";
        public static final String DIGEST_SHA = "DIGEST-SHA";
        public static final String DIGEST_SHA_256 = "DIGEST-SHA-256";
        public static final String DIGEST_SHA_384 = "DIGEST-SHA-384";
        public static final String DIGEST_SHA_512 = "DIGEST-SHA-512";
        public static final String SCRAM_SHA_1 = "SCRAM-SHA-1";
        public static final String SCRAM_SHA_1_PLUS = "SCRAM-SHA-1-PLUS";
        public static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
        public static final String SCRAM_SHA_256_PLUS = "SCRAM-SHA-256-PLUS";
        public static final String SCRAM_SHA_384 = "SCRAM-SHA-384";
        public static final String SCRAM_SHA_384_PLUS = "SCRAM-SHA-384-PLUS";
        public static final String SCRAM_SHA_512 = "SCRAM-SHA-512";
        public static final String SCRAM_SHA_512_PLUS = "SCRAM-SHA-512-PLUS";
        public static final String IEC_ISO_9798_M_DSA_SHA1 = "9798-M-DSA-SHA1";
        public static final String IEC_ISO_9798_M_ECDSA_SHA1 = "9798-M-ECDSA-SHA1";
        public static final String IEC_ISO_9798_M_RSA_SHA1_ENC = "9798-M-RSA-SHA1-ENC";
        public static final String IEC_ISO_9798_U_DSA_SHA1 = "9798-U-DSA-SHA1";
        public static final String IEC_ISO_9798_U_ECDSA_SHA1 = "9798-U-ECDSA-SHA1";
        public static final String IEC_ISO_9798_U_RSA_SHA1_ENC = "9798-U-RSA-SHA1-ENC";
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String EAP_AES128 = "EAP-AES128";
        public static final String EAP_AES128_PLUS = "EAP-AES128-PLUS";
        public static final String EXTERNAL = "EXTERNAL";
        public static final String OAUTH_10_A = "OAUTH10A";
        public static final String OAUTHBEARER = "OAUTHBEARER";
        public static final String OPENID20 = "OPENID20";
        public static final String OTP = "OTP";
        public static final String SAML20 = "SAML20";
        public static final String SECURID = "SECURID";
        public static final String PLAIN = "PLAIN";
        public static final String GSSAPI = "GSSAPI";

        private Names() {
        }
    }
}

