/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.X509CertificateChainCredential;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClient;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class LocalPrincipalSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    public LocalPrincipalSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        CallbackHandler realCallbackHandler;
        Supplier<Principal> principalSupplier;
        if (authorizationId != null) {
            NamePrincipal principal = new NamePrincipal(authorizationId);
            principalSupplier = () -> principal;
            realCallbackHandler = cbh;
        } else {
            ClientPrincipalQueryCallbackHandler handler = new ClientPrincipalQueryCallbackHandler(cbh);
            principalSupplier = handler::getPrincipal;
            realCallbackHandler = handler;
        }
        SaslClient delegate = super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, realCallbackHandler);
        if (delegate == null) {
            return null;
        }
        return new LocalPrincipalSaslClient(delegate, principalSupplier);
    }

    class LocalPrincipalSaslClient
    extends AbstractDelegatingSaslClient {
        private final Supplier<Principal> principalSupplier;

        LocalPrincipalSaslClient(SaslClient delegate, Supplier<Principal> principalSupplier) {
            super(delegate);
            this.principalSupplier = principalSupplier;
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            Object value = super.getNegotiatedProperty(propName);
            return value == null && "wildfly.sasl.principal".equals(propName) ? this.principalSupplier.get() : value;
        }
    }

    static final class ClientPrincipalQueryCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler delegate;
        private final AtomicReference<Principal> principalRef = new AtomicReference<AnonymousPrincipal>(AnonymousPrincipal.getInstance());

        ClientPrincipalQueryCallbackHandler(CallbackHandler delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                this.delegate.handle(callbacks);
            }
            finally {
                for (Callback callback : callbacks) {
                    Principal localPrincipal;
                    SSLSession sslSession;
                    if (callback instanceof NameCallback) {
                        String name = ((NameCallback)callback).getName();
                        if (name == null) continue;
                        this.principalRef.set(new NamePrincipal(name));
                        continue;
                    }
                    if (callback instanceof CredentialCallback) {
                        X500Principal principal;
                        Credential credential = ((CredentialCallback)callback).getCredential();
                        if (!(credential instanceof X509CertificateChainCredential) || (principal = ((X509CertificateChainCredential)credential).getFirstCertificate().getSubjectX500Principal()) == null) continue;
                        this.principalRef.set(principal);
                        continue;
                    }
                    if (!(callback instanceof SSLCallback) || (sslSession = ((SSLCallback)callback).getSslSession()) == null || (localPrincipal = sslSession.getLocalPrincipal()) == null) continue;
                    this.principalRef.set(localPrincipal);
                }
            }
        }

        public Principal getPrincipal() {
            return this.principalRef.get();
        }
    }
}

