/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.callback.ParameterCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;

class SetParameterSpecAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.HandlesCallbacks {
    private final List<AlgorithmParameterSpec> parameterSpecs;

    SetParameterSpecAuthenticationConfiguration(AuthenticationConfiguration parent, AlgorithmParameterSpec parameterSpec) {
        this(parent, Collections.singletonList(parameterSpec));
    }

    SetParameterSpecAuthenticationConfiguration(AuthenticationConfiguration parent, List<AlgorithmParameterSpec> parameterSpecs) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class));
        this.parameterSpecs = parameterSpecs;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        ParameterCallback parameterCallback;
        Callback callback = callbacks[index];
        if (callback instanceof ParameterCallback && (parameterCallback = (ParameterCallback)callback).getParameterSpec() == null) {
            for (AlgorithmParameterSpec parameterSpec : this.parameterSpecs) {
                if (!parameterCallback.isParameterSupported(parameterSpec)) continue;
                parameterCallback.setParameterSpec(parameterSpec);
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetParameterSpecAuthenticationConfiguration(newParent, this.parameterSpecs);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.parameterSpecs, other.getParameterSpecs());
    }

    @Override
    List<AlgorithmParameterSpec> getParameterSpecs() {
        return this.parameterSpecs;
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 7817, this.parameterSpecs.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("ParameterSpec,");
    }
}

