/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.sasl.util.StringPrep;

final class PlainSaslClient
implements SaslClient,
SaslWrapper {
    private final String authorizationId;
    private final CallbackHandler cbh;
    private final long profile;
    private boolean complete = false;

    PlainSaslClient(String authorizationId, CallbackHandler cbh, boolean skipNormalization) {
        this.authorizationId = authorizationId;
        this.cbh = cbh;
        this.profile = skipNormalization ? 16379L : 16383L;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        if (challenge.length > 0) {
            throw ElytronMessages.saslPlain.mechInvalidMessageReceived().toSaslException();
        }
        NameCallback nameCallback = new NameCallback("Login name");
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            this.cbh.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.saslPlain.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toSaslException();
        }
        String name = nameCallback.getName();
        if (name == null) {
            throw ElytronMessages.saslPlain.mechNoLoginNameGiven().toSaslException();
        }
        char[] password = passwordCallback.getPassword();
        if (password == null) {
            throw ElytronMessages.saslPlain.mechNoPasswordGiven().toSaslException();
        }
        try {
            ByteStringBuilder b = new ByteStringBuilder();
            if (this.authorizationId != null) {
                StringPrep.encode((String)this.authorizationId, (ByteStringBuilder)b, (long)this.profile);
            }
            b.append((byte)0);
            StringPrep.encode((String)name, (ByteStringBuilder)b, (long)this.profile);
            b.append((byte)0);
            StringPrep.encode((char[])password, (ByteStringBuilder)b, (long)this.profile);
            return b.toArray();
        }
        catch (IllegalArgumentException ex) {
            throw ElytronMessages.saslPlain.mechMalformedFields(ex).toSaslException();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.saslPlain.mechNoSecurityLayer();
        }
        throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.complete) {
            return null;
        }
        throw ElytronMessages.saslPlain.mechAuthenticationNotComplete();
    }

    @Override
    public void dispose() throws SaslException {
    }
}

