/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.auth.server.event.RealmFailedAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmSuccessfulAuthenticationEvent;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class BruteForceRealmWrapper {
    private static final String HANDLE_REALM_EVENT_NAME = "handleRealmEvent";
    private static final Set<Method> GET_IDENTITY_METHODS;
    private static final Method EVENT_HANDLER_METHOD;
    private static final int MINUTES_TO_MS = 60000;
    private static final long MINUTES_TO_NANOS = 60000000000L;
    private static final long LOG_INTERVAL_NANOS = 900000000000L;
    private volatile boolean built = false;
    private ScheduledExecutorService executor;
    private SecurityRealm wrapped;
    private String realmName;
    private int maxFailedAttempts = 10;
    private int lockoutInterval = 15;
    private int failureSessionTimeout = 30;
    private int maxCachedSessions = 25000;
    private List<Class<?>> additionalInterfaces = new ArrayList();
    private static final ThreadLocal<Boolean> BRUTE_FORCE_EVENT_HANDLED;

    public static BruteForceRealmWrapper create() {
        return new BruteForceRealmWrapper();
    }

    public BruteForceRealmWrapper withExecutor(ScheduledExecutorService executor) {
        this.assertNotBuilt();
        this.executor = executor;
        return this;
    }

    public BruteForceRealmWrapper setRealmName(String realmName) {
        this.assertNotBuilt();
        this.realmName = realmName;
        return this;
    }

    public BruteForceRealmWrapper setMaxFailedAttempts(int maxFailedAttempts) {
        this.assertNotBuilt();
        if (maxFailedAttempts > 0) {
            this.maxFailedAttempts = maxFailedAttempts;
        }
        return this;
    }

    public BruteForceRealmWrapper setLockoutInterval(int lockoutInterval) {
        this.assertNotBuilt();
        if (lockoutInterval > 0) {
            this.lockoutInterval = lockoutInterval;
        }
        return this;
    }

    public BruteForceRealmWrapper setFailureSessionTimeout(int failureSessionTimeout) {
        this.assertNotBuilt();
        if (failureSessionTimeout > 0) {
            this.failureSessionTimeout = failureSessionTimeout;
        }
        return this;
    }

    public BruteForceRealmWrapper setMaxCachedSessions(int maxCachedSessions) {
        this.assertNotBuilt();
        if (maxCachedSessions > 0) {
            this.maxCachedSessions = maxCachedSessions;
        }
        return this;
    }

    public BruteForceRealmWrapper addAdditionalInterface(Class<?> interfaze) {
        this.assertNotBuilt();
        Assert.checkNotNullParam((String)"interfaze", interfaze);
        if (!interfaze.isInterface()) {
            throw ElytronMessages.log.notAnInterface(interfaze.getName());
        }
        this.additionalInterfaces.add(interfaze);
        return this;
    }

    public BruteForceRealmWrapper wrapping(SecurityRealm toWrap) {
        this.assertNotBuilt();
        this.wrapped = (SecurityRealm)Assert.checkNotNullParam((String)"toWrap", (Object)toWrap);
        return this;
    }

    public <S extends SecurityRealm> S wrap(Class<S> securityRealmType) {
        this.assertNotBuilt();
        Assert.checkNotNullParam((String)"executor", (Object)this.executor);
        Assert.checkNotNullParam((String)"wrapped", (Object)this.wrapped);
        ArrayList proxiedInterfaces = new ArrayList();
        if (this.wrapped instanceof ModifiableSecurityRealm) {
            proxiedInterfaces.add(ModifiableSecurityRealm.class);
        }
        if (this.wrapped instanceof CacheableSecurityRealm) {
            proxiedInterfaces.add(CacheableSecurityRealm.class);
        }
        if (proxiedInterfaces.isEmpty()) {
            proxiedInterfaces.add(SecurityRealm.class);
        }
        String realmName = this.realmName != null ? this.realmName : this.wrapped.getClass().getSimpleName();
        for (Class<?> additionalInterface : this.additionalInterfaces) {
            if (!additionalInterface.isInstance(this.wrapped)) {
                throw ElytronMessages.log.doesNotImplementRequiredInterface(realmName, this.wrapped.getClass().getName(), additionalInterface.getName());
            }
            proxiedInterfaces.add(additionalInterface);
        }
        Object proxy = Proxy.newProxyInstance(BruteForceRealmWrapper.class.getClassLoader(), proxiedInterfaces.toArray(new Class[proxiedInterfaces.size()]), (InvocationHandler)new RealmWrapper(realmName, this.maxCachedSessions));
        if (!securityRealmType.isInstance(proxy)) {
            throw ElytronMessages.log.doesNotImplementRequiredInterface(realmName, this.wrapped.getClass().getName(), securityRealmType.getName());
        }
        SecurityRealm response = (SecurityRealm)securityRealmType.cast(proxy);
        this.built = true;
        return (S)response;
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw ElytronMessages.log.bruteForceWrapperAlreadyBuilt();
        }
    }

    static {
        HashSet<Method> getIdentityMethods = new HashSet<Method>();
        for (Method method : ModifiableSecurityRealm.class.getMethods()) {
            if (!RealmIdentity.class.isAssignableFrom(method.getReturnType())) continue;
            getIdentityMethods.add(method);
        }
        GET_IDENTITY_METHODS = Collections.unmodifiableSet(getIdentityMethods);
        try {
            EVENT_HANDLER_METHOD = SecurityRealm.class.getMethod(HANDLE_REALM_EVENT_NAME, RealmEvent.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        BRUTE_FORCE_EVENT_HANDLED = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    private class RealmWrapper
    implements InvocationHandler {
        private final String realmName;
        private final Map<Principal, FailureSession> failedAttempts;
        private long lastWarnLoggedNanos = Long.MIN_VALUE;

        RealmWrapper(final String realmName, final int maxSessions) {
            this.realmName = realmName;
            this.failedAttempts = new LinkedHashMap<Principal, FailureSession>(16, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Principal, FailureSession> eldest) {
                    if (this.size() > maxSessions) {
                        eldest.getValue().cancelExpiry(true);
                        long nowNanos = System.nanoTime();
                        if (RealmWrapper.this.lastWarnLoggedNanos == Long.MIN_VALUE || nowNanos - RealmWrapper.this.lastWarnLoggedNanos > 900000000000L) {
                            ElytronMessages.log.bruteForceSessionEvicted(realmName);
                            RealmWrapper.this.lastWarnLoggedNanos = nowNanos;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean eventHandled = BRUTE_FORCE_EVENT_HANDLED.get();
            try {
                BRUTE_FORCE_EVENT_HANDLED.set(true);
                Object object = this.invoke(proxy, method, args, eventHandled);
                return object;
            }
            finally {
                BRUTE_FORCE_EVENT_HANDLED.set(eventHandled);
            }
        }

        private Object invoke(Object proxy, Method method, Object[] args, boolean eventHandled) throws Throwable {
            if (EVENT_HANDLER_METHOD.equals(method) && args[0] instanceof RealmEvent) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.tracef("Event Received %s, for Realm %s, alreadyHandled %b", args[0].getClass().getSimpleName(), this.realmName, eventHandled);
                }
                if (!eventHandled) {
                    this.handleRealmEvent((RealmEvent)args[0]);
                }
            } else if (GET_IDENTITY_METHODS.contains(method) && (args[0] instanceof Principal || args[0] instanceof Evidence)) {
                Principal principal;
                Principal principal2 = principal = args[0] instanceof Principal ? (Principal)args[0] : ((Evidence)args[0]).getDecodedPrincipal();
                if (this.isDisabled(principal)) {
                    ElytronMessages.log.tracef("Protecting realm %s and Returning DisabledRealmIdentity for %s", this.realmName, principal.getName());
                    Class<?> returnType = method.getReturnType();
                    if (ModifiableRealmIdentity.class.equals(returnType)) {
                        return new DisabledModifiableRealmIdentity(principal);
                    }
                    if (RealmIdentity.class.equals(returnType)) {
                        return new DisabledRealmIdentity(principal);
                    }
                } else if (principal != null) {
                    ElytronMessages.log.tracef("Identity not disabled for realm %s, proceeding for %s", this.realmName, principal.getName());
                }
            }
            try {
                return method.invoke((Object)BruteForceRealmWrapper.this.wrapped, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDisabled(Principal principal) {
            if (principal == null) {
                return false;
            }
            Map<Principal, FailureSession> map = this.failedAttempts;
            synchronized (map) {
                FailureSession session = this.failedAttempts.get(principal);
                return session != null && session.isDisabled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate(Principal principal) {
            Map<Principal, FailureSession> map = this.failedAttempts;
            synchronized (map) {
                ElytronMessages.log.tracef("Removing brute force session for %s in realm %s", principal.getName(), this.realmName);
                this.failedAttempts.remove(principal);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRealmEvent(RealmEvent event) {
            if (event instanceof RealmFailedAuthenticationEvent) {
                Principal principal;
                RealmFailedAuthenticationEvent rfae = (RealmFailedAuthenticationEvent)event;
                RealmIdentity identity = rfae.getRealmIdentity();
                Principal principal2 = principal = identity != null ? identity.getRealmIdentityPrincipal() : null;
                if (principal != null && this.exists(identity)) {
                    Map<Principal, FailureSession> map = this.failedAttempts;
                    synchronized (map) {
                        int count;
                        FailureSession session = this.failedAttempts.get(principal);
                        if (session != null) {
                            if (!session.cancelExpiry(true)) {
                                ElytronMessages.log.tracef("Unable to cancel cleanup for '%s' in realm %s", principal, this.realmName);
                                return;
                            }
                        } else {
                            session = new FailureSession(() -> this.invalidate(principal));
                            ElytronMessages.log.tracef("Beginning tracking of failed authentication attempts for '%s' in realm %s", principal, this.realmName);
                            this.failedAttempts.put(principal, session);
                        }
                        if ((count = session.failAuthentication()) >= BruteForceRealmWrapper.this.maxFailedAttempts) {
                            ElytronMessages.log.tracef("Disabling authentication for '%s' in realm %s", principal, this.realmName);
                            session.disableForMs(BruteForceRealmWrapper.this.lockoutInterval * 60000);
                        }
                        session.scheduleTimeout(BruteForceRealmWrapper.this.failureSessionTimeout * 60000);
                    }
                }
            } else if (event instanceof RealmSuccessfulAuthenticationEvent) {
                Principal principal;
                RealmSuccessfulAuthenticationEvent rsae = (RealmSuccessfulAuthenticationEvent)event;
                RealmIdentity identity = rsae.getRealmIdentity();
                Principal principal3 = principal = identity != null ? identity.getRealmIdentityPrincipal() : null;
                if (principal != null) {
                    Map<Principal, FailureSession> map = this.failedAttempts;
                    synchronized (map) {
                        FailureSession session = this.failedAttempts.get(principal);
                        if (session != null) {
                            ElytronMessages.log.tracef("Successful authentication for previously cached failed authentication '%s' in realm %s", principal.getName(), this.realmName);
                            if (session.cancelExpiry(false)) {
                                this.invalidate(principal);
                            }
                        }
                    }
                }
            }
        }

        private boolean exists(RealmIdentity identity) {
            try {
                return identity.exists();
            }
            catch (RealmUnavailableException e) {
                ElytronMessages.log.tracef(e, "Unable to determine if identity exists in realm %s", this.realmName);
                return false;
            }
        }
    }

    static class DisabledModifiableRealmIdentity
    extends DisabledRealmIdentity
    implements ModifiableRealmIdentity {
        DisabledModifiableRealmIdentity(Principal principal) {
            super(principal);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        public void delete() throws RealmUnavailableException {
        }

        public void create() throws RealmUnavailableException {
            throw ElytronMessages.log.unableToCreateIdentity();
        }

        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            throw ElytronMessages.log.noSuchIdentity();
        }

        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            throw ElytronMessages.log.noSuchIdentity();
        }
    }

    static class DisabledRealmIdentity
    implements RealmIdentity {
        private final Principal principal;

        DisabledRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.principal;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            return false;
        }

        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        public String toString() {
            return "DISABLED";
        }
    }

    private class FailureSession {
        private final Runnable invalidate;
        private volatile int failedCount = 0;
        private volatile long disableUntil = 0L;
        private volatile ScheduledFuture<?> futureCleanup;

        FailureSession(Runnable invalidate) {
            this.invalidate = invalidate;
        }

        int failAuthentication() {
            return ++this.failedCount;
        }

        void disableForMs(long duration) {
            this.disableUntil = System.currentTimeMillis() + duration;
        }

        boolean isDisabled() {
            return System.currentTimeMillis() < this.disableUntil;
        }

        boolean cancelExpiry(boolean interrupt) {
            return this.futureCleanup.cancel(interrupt);
        }

        void scheduleTimeout(long duration) {
            long now = System.currentTimeMillis();
            long disabledDuration = this.disableUntil - now;
            long scheduleTime = disabledDuration > duration ? disabledDuration : duration;
            this.futureCleanup = BruteForceRealmWrapper.this.executor.schedule(this.invalidate::run, scheduleTime, TimeUnit.MILLISECONDS);
        }
    }
}

