/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.provider.util.ProviderUtil;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final Supplier<Provider[]> providers;
    private final NameRewriter rewriter;
    private volatile Map<String, SimpleRealmEntry> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter) {
        this(rewriter, ProviderUtil.INSTALLED_PROVIDERS);
    }

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter, Supplier<Provider[]> providers) {
        this.rewriter = (NameRewriter)Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
        this.providers = (Supplier)Assert.checkNotNullParam((String)"provider", providers);
    }

    public SimpleMapBackedSecurityRealm() {
        this(NameRewriter.IDENTITY_REWRITER);
    }

    public SimpleMapBackedSecurityRealm(Supplier<Provider[]> providers) {
        this(NameRewriter.IDENTITY_REWRITER, providers);
    }

    public void setIdentityMap(Map<String, SimpleRealmEntry> map) {
        Assert.checkNotNullParam((String)"map", map);
        this.map = map;
    }

    @Deprecated
    public void setPasswordMap(Map<String, SimpleRealmEntry> map) {
        this.setIdentityMap(map);
    }

    @Deprecated
    public void setPasswordMap(String name, Password password, Attributes attributes) {
        this.setIdentityMap(Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password)), attributes)));
    }

    @Deprecated
    public void setPasswordMap(String name, Password password) {
        this.setPasswordMap(name, password, Attributes.EMPTY);
    }

    public RealmIdentity getRealmIdentity(Principal principal) {
        if (!NamePrincipal.isConvertibleTo((Principal)principal)) {
            return RealmIdentity.NON_EXISTENT;
        }
        String name = this.rewriter.rewriteName(principal.getName());
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new SimpleMapRealmIdentity(name);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final String name;

        SimpleMapRealmIdentity(String name) {
            this.name = name;
        }

        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.getCredential(credentialType, algorithmName, null);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return null;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.matches(credentialType, algorithmName, parameterSpec)) continue;
                return (C)((Credential)credentialType.cast(credential.clone()));
            }
            return null;
        }

        public AuthorizationIdentity getAuthorizationIdentity() {
            SimpleRealmEntry entry = SimpleMapBackedSecurityRealm.this.map.get(this.name);
            return entry == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity((Attributes)entry.getAttributes());
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            SimpleRealmEntry entry = SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidenceType, algorithmName)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            SimpleRealmEntry entry = SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return false;
            }
            ElytronMessages.log.tracef("Trying to authenticate %s using SimpleMapBackedSecurityRealm.", this.name);
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidence)) continue;
                return credential.verify(SimpleMapBackedSecurityRealm.this.providers, evidence);
            }
            return false;
        }

        public boolean exists() throws RealmUnavailableException {
            return SimpleMapBackedSecurityRealm.this.map.containsKey(this.name);
        }
    }
}

