/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token._private;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.token._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String tokenRealmFailedToObtainPrincipal$str() {
        return "ELY01104: OAuth2-based realm failed to obtain principal";
    }

    @Override
    public final RuntimeException tokenRealmFailedToObtainPrincipal(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.tokenRealmFailedToObtainPrincipal$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String tokenRealmOAuth2TokenIntrospectionFailed$str() {
        return "ELY01105: OAuth2-based realm failed to introspect token";
    }

    @Override
    public final RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.tokenRealmOAuth2TokenIntrospectionFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmFailedToObtainPrincipalWithClaim$str() {
        return "ELY01113: Token-based realm failed to obtain principal from token using claim [%s]";
    }

    @Override
    public final IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(String claimName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmFailedToObtainPrincipalWithClaim$str(), claimName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmJwtInvalidFormat$str() {
        return "ELY01114: Invalid token format. Tokens must have a signature part accordingly with JWS specification";
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidFormat() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtInvalidFormat$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmJwtParseFailed$str() {
        return "ELY01115: Failed to parse token";
    }

    @Override
    public final IllegalStateException tokenRealmJwtParseFailed(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmJwtParseFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmJwtSignatureCheckFailed$str() {
        return "ELY01116: Signature verification failed";
    }

    @Override
    public final IllegalStateException tokenRealmJwtSignatureCheckFailed(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmJwtSignatureCheckFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmJwtSignatureInvalidAlgorithm$str() {
        return "ELY01117: Invalid signature algorithm [%s]";
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtSignatureInvalidAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenRealmJwtInvalidPublicKeyPem$str() {
        return "ELY01118: Public key could not be obtained. Probably due to an invalid PEM format.";
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtInvalidPublicKeyPem$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str() {
        return "ELY01126: Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.";
    }

    @Override
    public final void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str() {
        return "ELY01127: Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.";
    }

    @Override
    public final void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str() {
        return "ELY01128: Jwt-based token not configured with a public key. Ignoring signature verification.";
    }

    @Override
    public final void unableToFetchJwks(String url) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToFetchJwks$str(), (Object)url);
    }

    protected String unableToFetchJwks$str() {
        return "ELY01178: Unable to update jwk set from \"%1$s\".";
    }

    @Override
    public final void tokenRealmJwtNoSSLIgnoringJku() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.tokenRealmJwtNoSSLIgnoringJku$str(), new Object[0]);
    }

    protected String tokenRealmJwtNoSSLIgnoringJku$str() {
        return "ELY01179: SSL not configured. jku claim will not be supported.";
    }

    @Override
    public final void tokenRealmJwkMissingClaim(String claim) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.tokenRealmJwkMissingClaim$str(), (Object)claim);
    }

    protected String tokenRealmJwkMissingClaim$str() {
        return "ELY01180: Fetched jwk does not contain \"%1$s\" claim, ignoring...";
    }

    @Override
    public final void avoidingFetchJwks(URL url, long timestamp) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.avoidingFetchJwks$str(), (Object)url, (Object)timestamp);
    }

    protected String avoidingFetchJwks$str() {
        return "ELY01181: Not sending new request to jwks url \"%s\". Last request time was %d.";
    }

    @Override
    public final void allowedJkuValuesNotConfigured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.allowedJkuValuesNotConfigured$str(), new Object[0]);
    }

    protected String allowedJkuValuesNotConfigured$str() {
        return "ELY01182: Allowed jku values haven't been configured for the JWT validator. Token validation will fail if the token contains a 'jku' header parameter.";
    }
}

