/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.provider.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.wildfly.common.array.Arrays2;

public class ServiceLoaderSupplier<E>
implements Supplier<E[]> {
    private final Class<E> service;
    final ClassLoader classLoader;
    private int hashCode;
    private volatile E[] result;
    private final AccessControlContext acc;

    public ServiceLoaderSupplier(Class<E> service, ClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
        this.acc = AccessController.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E[] get() {
        if (this.result == null) {
            ServiceLoaderSupplier serviceLoaderSupplier = this;
            synchronized (serviceLoaderSupplier) {
                if (this.result == null) {
                    this.result = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> this.loadServices(this.service, this.classLoader), this.acc) : this.loadServices(this.service, this.classLoader);
                }
            }
        }
        return (Object[])this.result.clone();
    }

    E[] loadServices(Class<E> service, ClassLoader classLoader) {
        ArrayList<E> list = new ArrayList<E>();
        ServiceLoader<E> loader = ServiceLoader.load(service, classLoader);
        Iterator<E> iterator = loader.iterator();
        while (true) {
            try {
                while (true) {
                    if (!iterator.hasNext()) {
                        return list.toArray(Arrays2.createArray(service, (int)list.size()));
                    }
                    list.add(iterator.next());
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        int hc = this.hashCode;
        if (hc == 0) {
            hc = this.service.hashCode() * 19 + (this.classLoader != null ? this.classLoader.hashCode() : 0);
            if (hc == 0) {
                hc = 1;
            }
            this.hashCode = hc;
            return this.hashCode;
        }
        return hc;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceLoaderSupplier && this.equals((ServiceLoaderSupplier)obj);
    }

    private boolean equals(ServiceLoaderSupplier<?> other) {
        return other == this || other.service == this.service && other.classLoader == this.classLoader;
    }
}

